/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.interpreter.values.datawriter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.intocps.maestro.interpreter.InterpreterException;
import org.intocps.maestro.interpreter.values.ArrayValue;
import org.intocps.maestro.interpreter.values.FunctionValue;
import org.intocps.maestro.interpreter.values.ModuleValue;
import org.intocps.maestro.interpreter.values.RealValue;
import org.intocps.maestro.interpreter.values.StringValue;
import org.intocps.maestro.interpreter.values.Value;
import org.intocps.maestro.interpreter.values.VoidValue;
import org.intocps.maestro.interpreter.values.datawriter.DataWriterConfigValue;
import org.intocps.maestro.interpreter.values.datawriter.IDataListener;

public class DataWriterValue
extends ModuleValue {
    public DataWriterValue(List<IDataListener> dataListeners) {
        super(DataWriterValue.createMembers(dataListeners));
    }

    public static <T extends Value> List<T> getArrayValue(Value value, Class<T> clz) {
        if ((value = value.deref()) instanceof ArrayValue) {
            ArrayValue array = (ArrayValue)value;
            if (((ArrayValue)value).getValues().isEmpty()) {
                return Collections.emptyList();
            }
            if (!clz.isAssignableFrom(array.getValues().get(0).getClass())) {
                throw new InterpreterException("Array not containing the right type");
            }
            return array.getValues();
        }
        throw new InterpreterException("Value is not an array");
    }

    private static Map<String, Value> createMembers(List<IDataListener> IDataListeners) {
        HashMap<String, Value> componentMembers = new HashMap<String, Value>();
        componentMembers.put("writeHeader", new FunctionValue.ExternalFunctionValue(fcargs -> {
            if (fcargs == null) {
                throw new InterpreterException("No values passed");
            }
            if (fcargs.stream().anyMatch(Objects::isNull)) {
                throw new InterpreterException("Argument list contains null values");
            }
            List<StringValue> arrayValue = DataWriterValue.getArrayValue((Value)fcargs.get(0), StringValue.class);
            ArrayList<String> headers = new ArrayList<String>();
            for (StringValue strValue : arrayValue) {
                headers.add(strValue.getValue());
            }
            UUID uuid = UUID.randomUUID();
            IDataListeners.forEach(x -> x.writeHeader(uuid, headers));
            return new DataWriterConfigValue(uuid);
        }));
        componentMembers.put("writeDataPoint", new FunctionValue.ExternalFunctionValue(fcargs -> {
            if (fcargs == null) {
                throw new InterpreterException("No values passed");
            }
            if (fcargs.stream().anyMatch(Objects::isNull)) {
                throw new InterpreterException("Argument list contains null values");
            }
            Value id = ((Value)fcargs.get(0)).deref();
            if (id instanceof DataWriterConfigValue) {
                double time = ((RealValue)((Value)fcargs.get(1)).deref()).getValue();
                List arrayValue = ((ArrayValue)((Value)fcargs.get(2)).deref()).getValues();
                IDataListeners.forEach(dataListener -> dataListener.writeDataPoint(((DataWriterConfigValue)id).getUuid(), time, arrayValue));
            }
            return new VoidValue();
        }));
        componentMembers.put("close", new FunctionValue.ExternalFunctionValue(fcargs -> {
            IDataListeners.forEach(x -> x.close());
            return new VoidValue();
        }));
        return componentMembers;
    }
}

