/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.interpreter.values.derivativeestimator;

import java.util.HashMap;
import java.util.Map;
import org.intocps.orchestration.coe.config.ModelConnection;
import org.intocps.orchestration.coe.cosim.varstep.derivatives.ScalarDerivativeEstimator;
import org.intocps.orchestration.coe.modeldefinition.ModelDescription;

public class DerivativeEstimator {
    private static final Integer ESTIMATIONORDER = 2;
    private Map<ModelConnection.ModelInstance, Map<ModelDescription.ScalarVariable, ScalarDerivativeEstimator>> estimators = null;

    public Map<ModelConnection.ModelInstance, Map<ModelDescription.ScalarVariable, Map<Integer, Double>>> advance(Map<ModelConnection.ModelInstance, Map<ModelDescription.ScalarVariable, Object>> readValues, Map<ModelConnection.ModelInstance, Map<ModelDescription.ScalarVariable, Map<Integer, Double>>> readDerivatives, Double stepsize) {
        HashMap<ModelConnection.ModelInstance, Map<ModelDescription.ScalarVariable, Map<Integer, Double>>> derivatives = new HashMap<ModelConnection.ModelInstance, Map<ModelDescription.ScalarVariable, Map<Integer, Double>>>();
        if (this.estimators == null) {
            this.initialize(readValues);
        }
        for (ModelConnection.ModelInstance mi : readValues.keySet()) {
            HashMap scalarVariablesState = null;
            Map<ModelDescription.ScalarVariable, Object> svo = readValues.get(mi);
            for (ModelDescription.ScalarVariable sv : svo.keySet()) {
                if (!ModelDescription.Types.Real.equals((Object)sv.getType().type)) continue;
                if (scalarVariablesState == null) {
                    scalarVariablesState = new HashMap();
                    derivatives.put(mi, scalarVariablesState);
                }
                HashMap<Integer, Double> calculatedDerivatives = new HashMap<Integer, Double>();
                scalarVariablesState.put(sv, calculatedDerivatives);
                Double[] x = this.getReadValueAndDerivatives(readValues, readDerivatives, mi, sv);
                ScalarDerivativeEstimator estimator = this.estimators.get(mi).get(sv);
                estimator.advance(x, stepsize);
                Integer order = 1;
                while (order <= ESTIMATIONORDER) {
                    calculatedDerivatives.put(order, estimator.getDerivative(order));
                    Integer n = order;
                    Integer n2 = order = Integer.valueOf(order + 1);
                }
            }
        }
        return derivatives;
    }

    public Map<ModelConnection.ModelInstance, Map<Integer, Map<ModelDescription.ScalarVariable, Double>>> rollback() {
        HashMap<ModelConnection.ModelInstance, Map<Integer, Map<ModelDescription.ScalarVariable, Double>>> derivatives = new HashMap<ModelConnection.ModelInstance, Map<Integer, Map<ModelDescription.ScalarVariable, Double>>>();
        for (ModelConnection.ModelInstance mi : this.estimators.keySet()) {
            HashMap isvd = new HashMap();
            Integer order = 1;
            while (order <= ESTIMATIONORDER) {
                HashMap<ModelDescription.ScalarVariable, Double> svd = new HashMap<ModelDescription.ScalarVariable, Double>();
                for (ModelDescription.ScalarVariable sv : this.estimators.get(mi).keySet()) {
                    ScalarDerivativeEstimator estimator = this.estimators.get(mi).get(sv);
                    if (ModelDescription.Types.Real.equals((Object)sv.getType().type)) {
                        estimator.rollback();
                        svd.put(sv, estimator.getDerivative(order));
                        continue;
                    }
                    svd.put(sv, null);
                }
                isvd.put(order, svd);
                Integer n = order;
                order = order + 1;
                Integer n2 = order;
            }
            derivatives.put(mi, isvd);
        }
        return derivatives;
    }

    private Double[] getReadValueAndDerivatives(Map<ModelConnection.ModelInstance, Map<ModelDescription.ScalarVariable, Object>> readValues, Map<ModelConnection.ModelInstance, Map<ModelDescription.ScalarVariable, Map<Integer, Double>>> readDerivatives, ModelConnection.ModelInstance mi, ModelDescription.ScalarVariable sv) {
        Double derVal;
        Map<Integer, Double> orderDer;
        Map<ModelDescription.ScalarVariable, Map<Integer, Double>> derMi;
        Double[] x = new Double[]{null, null, null};
        x[0] = (Double)readValues.get(mi).get(sv);
        Integer order = 1;
        while (order <= ESTIMATIONORDER && (derMi = readDerivatives.get(mi)) != null && (orderDer = derMi.get(sv)) != null && (derVal = orderDer.get(order)) != null) {
            x[order.intValue()] = derVal;
            Integer n = order;
            Integer n2 = order = Integer.valueOf(order + 1);
        }
        return x;
    }

    private void initialize(Map<ModelConnection.ModelInstance, Map<ModelDescription.ScalarVariable, Object>> currentValues) {
        this.estimators = new HashMap<ModelConnection.ModelInstance, Map<ModelDescription.ScalarVariable, ScalarDerivativeEstimator>>();
        for (ModelConnection.ModelInstance mi : currentValues.keySet()) {
            Map<ModelDescription.ScalarVariable, Object> svo = currentValues.get(mi);
            HashMap<ModelDescription.ScalarVariable, ScalarDerivativeEstimator> svde = new HashMap<ModelDescription.ScalarVariable, ScalarDerivativeEstimator>();
            for (ModelDescription.ScalarVariable sv : svo.keySet()) {
                ScalarDerivativeEstimator de = null;
                if (ModelDescription.Types.Real.equals((Object)sv.getType().type)) {
                    de = new ScalarDerivativeEstimator(ESTIMATIONORDER);
                }
                svde.put(sv, de);
            }
            this.estimators.put(mi, svde);
        }
    }
}

