/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.interpreter.values.derivativeestimator;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.intocps.maestro.interpreter.ValueExtractionUtilities;
import org.intocps.maestro.interpreter.values.ArrayValue;
import org.intocps.maestro.interpreter.values.BooleanValue;
import org.intocps.maestro.interpreter.values.FunctionValue;
import org.intocps.maestro.interpreter.values.IntegerValue;
import org.intocps.maestro.interpreter.values.ModuleValue;
import org.intocps.maestro.interpreter.values.RealValue;
import org.intocps.maestro.interpreter.values.StringValue;
import org.intocps.maestro.interpreter.values.UnsignedIntegerValue;
import org.intocps.maestro.interpreter.values.Value;
import org.intocps.maestro.interpreter.values.derivativeestimator.ScalarDerivativeEstimator;

public class DerivativeEstimatorInstanceValue
extends ModuleValue {
    HashMap<Integer, DerivativesForVariable> derivatives;
    long variablesCount;

    public DerivativeEstimatorInstanceValue(long variablesCount_, HashMap<Integer, DerivativesForVariable> derivatives) {
        super(DerivativeEstimatorInstanceValue.createMembers(variablesCount_, derivatives));
        this.variablesCount = variablesCount_;
        this.derivatives = derivatives;
    }

    public static DerivativeEstimatorInstanceValue createDerivativeEstimatorInstanceValue(List<StringValue> variables, List<IntegerValue> orders, List<IntegerValue> provided, UnsignedIntegerValue variablesCount) {
        long variablesCount_ = variablesCount.getValue();
        HashMap<Integer, DerivativesForVariable> derivatives = new HashMap<Integer, DerivativesForVariable>();
        int i = 0;
        while ((long)i < variablesCount_) {
            String s = variables.get(i).getValue();
            Integer order = orders.get(i).getValue();
            Integer provided_ = provided.get(i).getValue();
            ScalarDerivativeEstimator estimator = new ScalarDerivativeEstimator(order);
            derivatives.put(i, new DerivativesForVariable(order, provided_, i, s, estimator));
            ++i;
        }
        return new DerivativeEstimatorInstanceValue(variablesCount_, derivatives);
    }

    private static Map<String, Value> createMembers(long size, HashMap<Integer, DerivativesForVariable> derivatives) {
        HashMap<String, Value> componentMembers = new HashMap<String, Value>();
        componentMembers.put("calculate", new FunctionValue.ExternalFunctionValue(fcargs -> {
            Double time = ValueExtractionUtilities.getValue((Value)fcargs.get(0), RealValue.class).getValue();
            List values = ValueExtractionUtilities.getArrayValue((Value)fcargs.get(1), RealValue.class).stream().map(RealValue::getValue).collect(Collectors.toList());
            List outputReference = ((ArrayValue)((Value)fcargs.get(2)).deref()).getValues();
            HashMap<Integer, Double[]> variableIndexToProvidedValues = new HashMap<Integer, Double[]>();
            int valuesIndex = 0;
            int outputReferenceIndex = 0;
            int variableIterator = 0;
            while ((long)variableIterator < size) {
                DerivativesForVariable derivativesForVariable = (DerivativesForVariable)derivatives.get(variableIterator);
                int nextValuesIndex = valuesIndex + derivativesForVariable.sizeOfProvidedValues;
                Double[] provided = values.subList(valuesIndex, nextValuesIndex).toArray(new Double[3]);
                variableIndexToProvidedValues.put(variableIterator, provided);
                derivativesForVariable.estimator.advance(provided, time);
                int derivativeOrder = 1;
                while (derivativeOrder <= derivativesForVariable.order) {
                    outputReference.add(outputReferenceIndex, new RealValue(derivativesForVariable.estimator.getDerivative(derivativeOrder)));
                    ++derivativeOrder;
                    ++outputReferenceIndex;
                }
                valuesIndex = nextValuesIndex;
                ++variableIterator;
            }
            return new BooleanValue(true);
        }));
        componentMembers.put("rollback", new FunctionValue.ExternalFunctionValue(fcargs -> {
            derivatives.values().forEach(l -> l.estimator.rollback());
            return new BooleanValue(true);
        }));
        return componentMembers;
    }

    public static class DerivativesForVariable {
        public final Integer order;
        public final Integer provided;
        public final Integer index;
        public final String variable;
        public final ScalarDerivativeEstimator estimator;
        public final int sizeOfProvidedValues;

        public DerivativesForVariable(Integer order, Integer provided, Integer index, String variable, ScalarDerivativeEstimator estimator) {
            this.order = order;
            this.provided = provided;
            this.index = index;
            this.variable = variable;
            this.estimator = estimator;
            this.sizeOfProvidedValues = this.provided + 1;
        }
    }
}

