/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.interpreter.values.derivativeestimator;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.intocps.maestro.interpreter.ValueExtractionUtilities;
import org.intocps.maestro.interpreter.values.FunctionValue;
import org.intocps.maestro.interpreter.values.IntegerValue;
import org.intocps.maestro.interpreter.values.ModuleValue;
import org.intocps.maestro.interpreter.values.StringValue;
import org.intocps.maestro.interpreter.values.UnsignedIntegerValue;
import org.intocps.maestro.interpreter.values.Value;
import org.intocps.maestro.interpreter.values.derivativeestimator.DerivativeEstimatorInstanceValue;

public class DerivativeEstimatorValue
extends ModuleValue {
    public DerivativeEstimatorValue() {
        super(DerivativeEstimatorValue.createMembers());
    }

    private static Map<String, Value> createMembers() {
        HashMap<String, Value> componentMembers = new HashMap<String, Value>();
        componentMembers.put("variablesOfInterest", new FunctionValue.ExternalFunctionValue(fcargs -> {
            fcargs = fcargs.stream().map(Value::deref).collect(Collectors.toList());
            DerivativeEstimatorValue.checkArgLength(fcargs, 4);
            List<StringValue> variables = ValueExtractionUtilities.getArrayValue(fcargs.get(0), StringValue.class);
            List<IntegerValue> order = ValueExtractionUtilities.getArrayValue(fcargs.get(1), IntegerValue.class);
            List<IntegerValue> provided = ValueExtractionUtilities.getArrayValue(fcargs.get(2), IntegerValue.class);
            UnsignedIntegerValue size = ValueExtractionUtilities.getValue(fcargs.get(3), UnsignedIntegerValue.class);
            DerivativeEstimatorInstanceValue de = DerivativeEstimatorInstanceValue.createDerivativeEstimatorInstanceValue(variables, order, provided, size);
            return de;
        }));
        return componentMembers;
    }
}

