/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.interpreter.values.derivativeestimator;

import org.intocps.maestro.interpreter.values.derivativeestimator.DerivativeEstimationAlgorithm;

public class SecondOrderDerivativeEstimationAlgorithm
implements DerivativeEstimationAlgorithm {
    @Override
    public Double[] update(Double[] x, Double[] xPrev, Double[] xPrevPrev, Double dt, Double dtPrev) {
        if (x[2] != null) {
            return new Double[]{x[0], x[1], x[2]};
        }
        if (x[1] != null) {
            Double xdotdot = 0.0;
            if (xPrev != null && xPrev[1] != null) {
                xdotdot = (x[1] - xPrev[1]) / dt;
            }
            return new Double[]{x[0], x[1], xdotdot};
        }
        if (xPrev == null) {
            return new Double[]{x[0], 0.0, 0.0};
        }
        if (dtPrev == null || xPrevPrev == null) {
            return new Double[]{x[0], (x[0] - xPrev[0]) / dt, 0.0};
        }
        Double r1 = (x[0] - xPrev[0]) / dt;
        Double r2 = (xPrevPrev[0] - xPrev[0]) / dtPrev;
        Double a = (r1 + r2) / (dt + dtPrev);
        Double b = -r2.doubleValue() - a * dtPrev;
        Double xdotdot = 2.0 * a;
        Double xdot = xdotdot * (dt + dtPrev) + b;
        return new Double[]{x[0], xdot, xdotdot};
    }
}

