/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.interpreter.values.derivativeestimator;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.intocps.maestro.interpreter.ValueExtractionUtilities;
import org.intocps.maestro.interpreter.values.BooleanValue;
import org.intocps.maestro.interpreter.values.FunctionValue;
import org.intocps.maestro.interpreter.values.ModuleValue;
import org.intocps.maestro.interpreter.values.NullValue;
import org.intocps.maestro.interpreter.values.RealValue;
import org.intocps.maestro.interpreter.values.Value;
import org.intocps.maestro.interpreter.values.derivativeestimator.ScalarDerivativeEstimator;

public class DerivativeEstimatorInstanceValue
extends ModuleValue {
    private static final Map<Long, ScalarDerivativeEstimator> estimators = new HashMap<Long, ScalarDerivativeEstimator>();

    public DerivativeEstimatorInstanceValue(List<Long> indicesOfInterest, List<Long> derivativeOrder, List<Long> providedDerivativesOrder) {
        super(DerivativeEstimatorInstanceValue.createMembers(indicesOfInterest, derivativeOrder, providedDerivativesOrder));
        for (int i = 0; i < indicesOfInterest.size(); ++i) {
            estimators.put(indicesOfInterest.get(i), new ScalarDerivativeEstimator(derivativeOrder.get(i).intValue()));
        }
    }

    private static Map<String, Value> createMembers(List<Long> indicesOfInterest, List<Long> derivativeOrders, List<Long> providedDerivativesOrder) {
        HashMap<String, Value> componentMembers = new HashMap<String, Value>();
        componentMembers.put("estimate", new FunctionValue.ExternalFunctionValue(fcargs -> {
            fcargs = fcargs.stream().map(Value::deref).collect(Collectors.toList());
            DerivativeEstimatorInstanceValue.checkArgLength(fcargs, 3);
            Double stepSize = ValueExtractionUtilities.getValue(fcargs.get(0), RealValue.class).getValue();
            List<Value> sharedDataDerivatives = ValueExtractionUtilities.getArrayValue(fcargs.get(2), Value.class);
            for (int i = 0; i < indicesOfInterest.size(); ++i) {
                Long indexOfInterest = (Long)indicesOfInterest.get(i);
                double dataOfInterest = ValueExtractionUtilities.getArrayValue(fcargs.get(1), RealValue.class).get(indexOfInterest.intValue()).getValue();
                List dataDerivativesOfInterest = ValueExtractionUtilities.getArrayValue(sharedDataDerivatives.get(indexOfInterest.intValue()), Value.class).stream().map(v -> {
                    if (v instanceof RealValue) {
                        return ((RealValue)v).getValue();
                    }
                    return null;
                }).collect(Collectors.toList());
                Double[] provided = new Double[]{dataOfInterest, null, null};
                int derOrderIndex = 1;
                while ((long)derOrderIndex <= (Long)providedDerivativesOrder.get(i)) {
                    provided[derOrderIndex] = (Double)dataDerivativesOfInterest.get(derOrderIndex - 1);
                    ++derOrderIndex;
                }
                estimators.get(indexOfInterest).advance(provided, stepSize);
                int derOrder = ((Long)providedDerivativesOrder.get(i)).intValue();
                while ((long)derOrder < (Long)derivativeOrders.get(i)) {
                    ValueExtractionUtilities.getArrayValue(sharedDataDerivatives.get(indexOfInterest.intValue()), Value.class).set(derOrder, new RealValue(estimators.get(indexOfInterest).getDerivative(derOrder + 1)));
                    ++derOrder;
                }
            }
            return new BooleanValue(true);
        }));
        componentMembers.put("rollback", new FunctionValue.ExternalFunctionValue(fcargs -> {
            fcargs = fcargs.stream().map(Value::deref).collect(Collectors.toList());
            DerivativeEstimatorInstanceValue.checkArgLength(fcargs, 1);
            List<Value> sharedDataDerivativesForIndex = ValueExtractionUtilities.getArrayValue(fcargs.get(0), Value.class);
            estimators.forEach((indexOfInterest, estimator) -> {
                estimator.rollback();
                for (int derOrder = ((Long)providedDerivativesOrder.get(indicesOfInterest.indexOf(indexOfInterest))).intValue(); derOrder < estimators.get(indexOfInterest).getOrder(); ++derOrder) {
                    Double der = estimator.getDerivative(derOrder + 1);
                    ValueExtractionUtilities.getArrayValue((Value)sharedDataDerivativesForIndex.get(indexOfInterest.intValue()), Value.class).set(derOrder, der != null ? new RealValue(der) : new NullValue());
                }
            });
            return new BooleanValue(true);
        }));
        return componentMembers;
    }
}

