/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.interpreter.values.variablestep;

import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import org.intocps.maestro.fmi.ModelDescription;
import org.intocps.maestro.framework.fmi2.ModelConnection;

public class CurrentSolutionPoint
extends Observable {
    private CurrentSolutionPoint previousState = null;
    private Double currentTime;
    private Double nextTime;
    private Double prevStepsize;
    private Double lastStepsizeLimitedByContinuousConstraint;
    private Boolean wasLastStepsizeLimitedByDiscreteConstraint;
    private Map<ModelConnection.ModelInstance, Map<ModelDescription.ScalarVariable, Object>> currentValues;
    private Map<ModelConnection.ModelInstance, Map<ModelDescription.ScalarVariable, Object>> nextValues;
    private Map<ModelConnection.ModelInstance, Map<ModelDescription.ScalarVariable, Map<Integer, Double>>> currentDerivatives;
    private Operation operation;

    public CurrentSolutionPoint() {
    }

    public CurrentSolutionPoint(CurrentSolutionPoint cs) {
        this.currentTime = cs.currentTime;
        this.nextTime = cs.nextTime;
        this.prevStepsize = cs.prevStepsize;
        this.lastStepsizeLimitedByContinuousConstraint = cs.lastStepsizeLimitedByContinuousConstraint;
        this.wasLastStepsizeLimitedByDiscreteConstraint = cs.wasLastStepsizeLimitedByDiscreteConstraint;
        this.currentValues = cs.currentValues;
        this.currentDerivatives = cs.currentDerivatives;
        this.nextValues = cs.nextValues;
    }

    public void advance(Double currentTime, Map<ModelConnection.ModelInstance, Map<ModelDescription.ScalarVariable, Object>> currentValues, Map<ModelConnection.ModelInstance, Map<ModelDescription.ScalarVariable, Map<Integer, Double>>> currentDerivatives, Double prevStepsize, Boolean wasStepsizeLimitedByDiscreteConstraint) {
        this.previousState = new CurrentSolutionPoint(this);
        this.operation = Operation.ADVANCE;
        this.currentTime = currentTime;
        this.currentValues = currentValues;
        this.currentDerivatives = currentDerivatives;
        this.prevStepsize = prevStepsize;
        this.wasLastStepsizeLimitedByDiscreteConstraint = wasStepsizeLimitedByDiscreteConstraint;
        if (!wasStepsizeLimitedByDiscreteConstraint.booleanValue()) {
            this.lastStepsizeLimitedByContinuousConstraint = prevStepsize;
        }
        this.setChanged();
        this.notifyObservers();
    }

    public void peek(Double nextTime, Map<ModelConnection.ModelInstance, Map<ModelDescription.ScalarVariable, Object>> nextValues) {
        this.operation = Operation.PEEK;
        this.nextValues = nextValues;
        this.nextTime = nextTime;
        this.setChanged();
        this.notifyObservers();
    }

    public void rollback() {
        this.operation = Operation.ROLLBACK;
        this.currentTime = this.previousState.currentTime;
        this.prevStepsize = this.previousState.prevStepsize;
        this.lastStepsizeLimitedByContinuousConstraint = this.previousState.lastStepsizeLimitedByContinuousConstraint;
        this.wasLastStepsizeLimitedByDiscreteConstraint = this.previousState.wasLastStepsizeLimitedByDiscreteConstraint;
        this.currentValues = this.previousState.currentValues;
        this.currentDerivatives = this.previousState.currentDerivatives;
        this.nextValues = this.previousState.nextValues;
        this.nextTime = this.previousState.nextTime;
        this.previousState = null;
        this.setChanged();
        this.notifyObservers();
    }

    public Operation getOperation() {
        return this.operation;
    }

    public Double getCurrentTime() {
        return this.currentTime;
    }

    public Double getNextTime() {
        return this.nextTime;
    }

    public Double getPrevStepsize() {
        return this.prevStepsize;
    }

    public Double getDoubleValue(ModelConnection.Variable variable) {
        return (Double)this.retrieveValue(this.currentValues.get(variable.instance), variable);
    }

    public Double getNextDoubleValue(ModelConnection.Variable variable) {
        return (Double)this.retrieveValue(this.nextValues.get(variable.instance), variable);
    }

    public Integer getIntegerValue(ModelConnection.Variable variable) {
        return (Integer)this.retrieveValue(this.currentValues.get(variable.instance), variable);
    }

    public Boolean getBooleanValue(ModelConnection.Variable variable) {
        return (Boolean)this.retrieveValue(this.currentValues.get(variable.instance), variable);
    }

    public String getStringValue(ModelConnection.Variable variable) {
        return (String)this.retrieveValue(this.currentValues.get(variable.instance), variable);
    }

    public Double getDerivative(ModelConnection.Variable variable, Integer order) {
        if (order < 1) {
            return null;
        }
        Map<ModelDescription.ScalarVariable, Map<Integer, Double>> dersInstance = this.currentDerivatives.get(variable.instance);
        if (dersInstance == null) {
            return null;
        }
        HashMap<ModelDescription.ScalarVariable, Double> dersInstanceOrder = new HashMap<ModelDescription.ScalarVariable, Double>();
        for (Map.Entry<ModelDescription.ScalarVariable, Map<Integer, Double>> entry : dersInstance.entrySet()) {
            dersInstanceOrder.put(entry.getKey(), entry.getValue().get(order));
        }
        if (dersInstanceOrder.isEmpty()) {
            return null;
        }
        return (Double)this.retrieveValue(dersInstanceOrder, variable);
    }

    public Double getLastStepsizeLimitedByContinuousConstraint() {
        return this.lastStepsizeLimitedByContinuousConstraint;
    }

    public Boolean wasLastStepsizeLimitedByDiscreteConstraint() {
        return this.wasLastStepsizeLimitedByDiscreteConstraint != null && this.wasLastStepsizeLimitedByDiscreteConstraint != false;
    }

    private <T> T retrieveValue(Map<ModelDescription.ScalarVariable, T> values, ModelConnection.Variable variable) {
        if (values == null) {
            return null;
        }
        for (ModelDescription.ScalarVariable sv : values.keySet()) {
            if (!sv.getName().equals(variable.variable) || !ModelDescription.Types.Real.equals((Object)sv.getType().type) && !ModelDescription.Types.Integer.equals((Object)sv.getType().type)) continue;
            return values.get(sv);
        }
        return null;
    }

    public static enum Operation {
        ADVANCE,
        PEEK,
        ROLLBACK;

    }
}

