/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.interpreter.values.variablestep;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.intocps.maestro.fmi.FmiSimulationInstance;
import org.intocps.maestro.fmi.ModelDescription;
import org.intocps.maestro.framework.fmi2.ModelConnection;
import org.intocps.maestro.interpreter.InterpreterException;
import org.intocps.maestro.interpreter.values.variablestep.CurrentSolutionPoint;
import org.intocps.maestro.interpreter.values.variablestep.InitializationMsgJson;
import org.intocps.maestro.interpreter.values.variablestep.StepValidationResult;
import org.intocps.maestro.interpreter.values.variablestep.StepsizeInterval;
import org.intocps.maestro.interpreter.values.variablestep.constraint.ConstraintHandler;
import org.intocps.maestro.interpreter.values.variablestep.constraint.ConstraintHandlerFactory;
import org.intocps.maestro.interpreter.values.variablestep.constraint.FmuMaxStepSizeHandler;
import org.intocps.maestro.interpreter.values.variablestep.constraint.samplingrate.SamplingRateHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StepsizeCalculator {
    static final Logger logger = LoggerFactory.getLogger(StepsizeCalculator.class);
    private static final Double STRONG_RELAXATION_FACTOR = 3.0;
    private static final Double INVALID_STEP_TIGHTENING_FACTOR = 0.25;
    private static final String ROLLBACK_MSG = "Discarding previous step and rolling back internal states";
    private final CurrentSolutionPoint currentSolutionPoint = new CurrentSolutionPoint();
    private final List<ConstraintHandler> handler = new Vector<ConstraintHandler>();
    private final Double initialStepsize;
    private final StepsizeInterval stepsizeInterval;
    private Double stepsize = null;
    private Double endTime = null;
    private Boolean wasStepsizeLimitedByDiscreteConstraint = false;
    private FmuMaxStepSizeHandler fmuMaxStepSizeHandler = null;

    public StepsizeCalculator(Set<InitializationMsgJson.Constraint> constraints, StepsizeInterval stepsizeInterval, Double initialStepsize, Map<ModelConnection.ModelInstance, FmiSimulationInstance> instances) throws InterpreterException {
        this.initialStepsize = stepsizeInterval.saturateStepsize(initialStepsize);
        this.stepsizeInterval = stepsizeInterval;
        for (InitializationMsgJson.Constraint constraint : constraints) {
            try {
                ConstraintHandler h = ConstraintHandlerFactory.getHandler(this.currentSolutionPoint, constraint, stepsizeInterval, STRONG_RELAXATION_FACTOR, this.getTypeMap(instances), logger);
                if (h == null) {
                    logger.warn("Unable to instantiate constraint: {}", (Object)constraint.getId());
                }
                if (h instanceof FmuMaxStepSizeHandler) {
                    this.fmuMaxStepSizeHandler = (FmuMaxStepSizeHandler)h;
                    continue;
                }
                this.handler.add(h);
            }
            catch (Exception e) {
                throw new InterpreterException("The simulation has been aborted because the constraint '" + constraint.getId() + "' could not be instantiated. Details: " + e.getMessage(), e);
            }
        }
    }

    public Double getStepsize(Double currentTime, Map<ModelConnection.ModelInstance, Map<ModelDescription.ScalarVariable, Object>> currentValues, Map<ModelConnection.ModelInstance, Map<ModelDescription.ScalarVariable, Map<Integer, Double>>> currentDerivatives, Double maxFmuStepsize) {
        this.currentSolutionPoint.advance(currentTime, currentValues, currentDerivatives, this.stepsize, this.wasStepsizeLimitedByDiscreteConstraint);
        this.wasStepsizeLimitedByDiscreteConstraint = false;
        Double stepsizeToEnd = this.endTime - currentTime;
        Double maxStepsize = this.fmuMaxStepSizeHandler == null && maxFmuStepsize == null ? Double.MAX_VALUE : maxFmuStepsize;
        if (this.isInitialStep().booleanValue()) {
            this.stepsize = this.initialStepsize;
            Double thisStepsize = Math.min(this.stepsize, stepsizeToEnd);
            if (maxStepsize < thisStepsize) {
                this.logFmuRequiredConstraint(currentTime, maxStepsize);
                return maxStepsize;
            }
            return thisStepsize;
        }
        Map<ConstraintHandler, Double> stepsizes = this.collectStepsizes();
        if (stepsizes.isEmpty()) {
            this.stepsize = this.stepsizeInterval.getMaximalStepsize();
            Double thisStepsize = Math.min(this.stepsize, stepsizeToEnd);
            if (maxStepsize < thisStepsize) {
                this.logFmuRequiredConstraint(currentTime, maxStepsize);
                this.wasStepsizeLimitedByDiscreteConstraint = true;
                return maxStepsize;
            }
            return thisStepsize;
        }
        this.stepsize = Math.min(Collections.min(stepsizes.values()), this.stepsizeInterval.getMaximalStepsize());
        if (maxStepsize < Math.min(this.stepsize, stepsizeToEnd)) {
            this.logFmuRequiredConstraint(currentTime, maxStepsize);
            this.wasStepsizeLimitedByDiscreteConstraint = true;
            return maxStepsize;
        }
        if (this.stepsize > stepsizeToEnd) {
            return stepsizeToEnd;
        }
        if (this.stepsize < this.stepsizeInterval.getMaximalStepsize()) {
            Set<ConstraintHandler> limitingConstraints = this.findLimitingConstraints(stepsizes);
            this.produceLogOutput(currentTime, limitingConstraints);
            this.wasStepsizeLimitedByDiscreteConstraint = this.containsOnlyDiscreteConstraints(limitingConstraints);
        }
        return this.stepsize;
    }

    public StepValidationResult validateStep(Double nextTime, Map<ModelConnection.ModelInstance, Map<ModelDescription.ScalarVariable, Object>> nextValues, Boolean supportsRollback) {
        this.currentSolutionPoint.peek(nextTime, nextValues);
        Boolean valid = this.wasStepValid();
        Double reducedStepsize = this.stepsize;
        Boolean hasReducedStepsize = false;
        if (!valid.booleanValue() && supportsRollback.booleanValue()) {
            reducedStepsize = Math.max(this.stepsize * INVALID_STEP_TIGHTENING_FACTOR, this.stepsizeInterval.getMinimalStepsize());
            hasReducedStepsize = reducedStepsize < this.stepsize;
            this.stepsize = reducedStepsize;
            if (hasReducedStepsize.booleanValue()) {
                logger.info(ROLLBACK_MSG);
            }
        }
        return new StepValidationResult(valid, hasReducedStepsize, this.stepsize);
    }

    public void setEndTime(Double endTime) {
        this.endTime = endTime;
    }

    private Map<ModelConnection.Variable, ModelDescription.Types> getTypeMap(Map<ModelConnection.ModelInstance, FmiSimulationInstance> instances) {
        HashMap<ModelConnection.Variable, ModelDescription.Types> map = new HashMap<ModelConnection.Variable, ModelDescription.Types>();
        for (ModelConnection.ModelInstance key : instances.keySet()) {
            for (ModelDescription.ScalarVariable sv : instances.get((Object)key).config.scalarVariables) {
                map.put(new ModelConnection.Variable(key, sv.getName()), sv.getType().type);
            }
        }
        return map;
    }

    private Boolean wasStepValid() {
        Boolean valid = true;
        for (ConstraintHandler h : this.handler) {
            if (h.wasStepValid().booleanValue()) continue;
            valid = false;
        }
        return valid;
    }

    private void produceLogOutput(Double currentTime, Set<ConstraintHandler> limitingConstraints) {
        if (limitingConstraints.size() > 1 && this.areAllConstraintsRelaxingStrongly(limitingConstraints).booleanValue()) {
            this.logAllConstraintsRelaxStrongly(currentTime);
        } else {
            this.logLimitingConstraintsDecisions(currentTime, limitingConstraints);
        }
    }

    private Boolean areAllConstraintsRelaxingStrongly(Set<ConstraintHandler> limitingConstraints) {
        for (ConstraintHandler h : limitingConstraints) {
            if (h.isRelaxingStrongly().booleanValue()) continue;
            return false;
        }
        return true;
    }

    private Boolean containsOnlyDiscreteConstraints(Set<ConstraintHandler> handlers) {
        for (ConstraintHandler h : handlers) {
            if (h instanceof SamplingRateHandler) continue;
            return false;
        }
        return true;
    }

    private Set<ConstraintHandler> findLimitingConstraints(Map<ConstraintHandler, Double> maxStepsizes) {
        HashSet<ConstraintHandler> limitingConstraints = new HashSet<ConstraintHandler>();
        for (ConstraintHandler h : maxStepsizes.keySet()) {
            if (!maxStepsizes.get(h).equals(this.stepsize)) continue;
            limitingConstraints.add(h);
        }
        return limitingConstraints;
    }

    private void logLimitingConstraintsDecisions(Double currentTime, Set<ConstraintHandler> limitingConstraints) {
        String msg = "Time " + currentTime + ", stepsize " + this.stepsize;
        for (ConstraintHandler h : limitingConstraints) {
            msg = msg + ", limited by constraint \"" + h.getId() + "\" with decision to " + h.getDecision();
        }
        logger.debug(msg);
    }

    private void logAllConstraintsRelaxStrongly(Double currentTime) {
        String msg = "Time " + currentTime + ", stepsize " + this.stepsize;
        msg = msg + ", all continuous constraint handlers allow strong relaxation";
        logger.debug(msg);
    }

    private void logFmuRequiredConstraint(Double currentTime, Double maxStepsize) {
        String msg = "Time " + currentTime + ", stepsize " + maxStepsize;
        msg = msg + ", limited by an FMU";
        logger.debug(msg);
    }

    private Boolean isInitialStep() {
        return this.stepsize == null;
    }

    private Map<ConstraintHandler, Double> collectStepsizes() {
        HashMap<ConstraintHandler, Double> stepsizes = new HashMap<ConstraintHandler, Double>();
        for (ConstraintHandler h : this.handler) {
            stepsizes.put(h, h.getMaxStepSize());
        }
        return stepsizes;
    }
}

