/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.interpreter.values.variablestep;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.intocps.maestro.fmi.FmiSimulationInstance;
import org.intocps.maestro.fmi.ModelDescription;
import org.intocps.maestro.framework.fmi2.ModelConnection;
import org.intocps.maestro.interpreter.InterpreterException;
import org.intocps.maestro.interpreter.values.BooleanValue;
import org.intocps.maestro.interpreter.values.EnumerationValue;
import org.intocps.maestro.interpreter.values.IntegerValue;
import org.intocps.maestro.interpreter.values.RealValue;
import org.intocps.maestro.interpreter.values.StringValue;
import org.intocps.maestro.interpreter.values.Value;
import org.intocps.maestro.interpreter.values.derivativeestimator.ScalarDerivativeEstimator;
import org.intocps.maestro.interpreter.values.variablestep.InitializationMsgJson;
import org.intocps.maestro.interpreter.values.variablestep.StepValidationResult;
import org.intocps.maestro.interpreter.values.variablestep.StepsizeCalculator;
import org.intocps.maestro.interpreter.values.variablestep.StepsizeInterval;

public class VariableStepConfigValue
extends Value {
    private final Map<ModelConnection.ModelInstance, FmiSimulationInstance> instances;
    private List<String> portNames;
    private List<StepVal> dataPoints;
    private Double currTime = 0.0;
    private Double stepSize = 0.0;
    private final Double maxStepSize;
    private StepValidationResult stepValidationResult;
    private final StepsizeCalculator stepsizeCalculator;
    private final Map<ModelDescription.ScalarVariable, ScalarDerivativeEstimator> derivativeEstimators;

    public VariableStepConfigValue(Map<ModelConnection.ModelInstance, FmiSimulationInstance> instances, Set<InitializationMsgJson.Constraint> constraints, StepsizeInterval stepsizeInterval, Double initSize, Double maxStepSize) throws InterpreterException {
        this.instances = instances;
        this.stepsizeCalculator = new StepsizeCalculator(constraints, stepsizeInterval, initSize, instances);
        HashMap<ModelDescription.ScalarVariable, ScalarDerivativeEstimator> derEsts = new HashMap<ModelDescription.ScalarVariable, ScalarDerivativeEstimator>();
        instances.forEach((mi, fsi) -> fsi.config.scalarVariables.forEach(sv -> derEsts.put((ModelDescription.ScalarVariable)sv, new ScalarDerivativeEstimator(2))));
        this.derivativeEstimators = derEsts;
        this.maxStepSize = maxStepSize;
    }

    public void initializePorts(List<String> portNames) {
        this.portNames = portNames;
    }

    public void addDataPoint(Double time, List<Value> portValues) {
        this.stepSize = time - this.currTime;
        this.currTime = time;
        this.dataPoints = this.convertValuesToDataPoint(portValues);
    }

    public double getStepSize() {
        HashMap<ModelConnection.ModelInstance, Map<ModelDescription.ScalarVariable, Map<Integer, Double>>> currentDerivatives = new HashMap<ModelConnection.ModelInstance, Map<ModelDescription.ScalarVariable, Map<Integer, Double>>>();
        HashMap<ModelConnection.ModelInstance, Map<ModelDescription.ScalarVariable, Object>> currentPortValues = new HashMap<ModelConnection.ModelInstance, Map<ModelDescription.ScalarVariable, Object>>();
        this.instances.forEach((mi, fsi) -> {
            HashMap derivatives = new HashMap();
            HashMap portValues = new HashMap();
            fsi.config.scalarVariables.forEach(sv -> this.dataPoints.stream().filter(dp -> dp.getName().contains(mi.key + "." + mi.instanceName + "." + sv.name)).findFirst().ifPresent(val -> {
                final ScalarDerivativeEstimator derEst = this.derivativeEstimators.get(sv);
                derEst.advance(new Double[]{(Double)val.getValue(), null, null}, this.stepSize);
                derivatives.putIfAbsent(sv, new HashMap<Integer, Double>(){
                    {
                        this.put(1, derEst.getFirstDerivative());
                        this.put(2, derEst.getSecondDerivative());
                    }
                });
                portValues.putIfAbsent(sv, val.getValue());
            }));
            currentDerivatives.put((ModelConnection.ModelInstance)mi, derivatives);
            currentPortValues.put((ModelConnection.ModelInstance)mi, portValues);
        });
        return this.stepsizeCalculator.getStepsize(this.currTime, currentPortValues, currentDerivatives, this.maxStepSize);
    }

    public boolean isStepValid(Double nextTime, List<Value> portValues, boolean supportsRollBack) {
        this.stepValidationResult = this.stepsizeCalculator.validateStep(nextTime, this.mapModelInstancesToPortValues(this.convertValuesToDataPoint(portValues)), supportsRollBack);
        return this.stepValidationResult.isValid();
    }

    public boolean hasReducedStepSize() {
        if (this.stepValidationResult == null) {
            throw new InterpreterException("'isStepValid' needs to be called before 'hasReducedStepSize'");
        }
        return this.stepValidationResult.hasReducedStepsize();
    }

    public Double getReducedStepSize() {
        if (this.stepValidationResult == null) {
            throw new InterpreterException("'isStepValid' needs to be called before 'reducedStepSize'");
        }
        return this.stepValidationResult.getStepsize();
    }

    public void setEndTime(Double endTime) {
        if (this.stepsizeCalculator != null) {
            this.stepsizeCalculator.setEndTime(endTime);
        }
    }

    private List<StepVal> convertValuesToDataPoint(List<Value> arrayValues) {
        ArrayList<StepVal> stepVals = new ArrayList<StepVal>();
        for (int i = 0; i < arrayValues.size(); ++i) {
            Value value = arrayValues.get(i);
            if (value instanceof StringValue) {
                stepVals.add(new StepVal(this.portNames.get(i), ((StringValue)value).getValue()));
                continue;
            }
            if (value instanceof IntegerValue) {
                stepVals.add(new StepVal(this.portNames.get(i), ((IntegerValue)value).getValue()));
                continue;
            }
            if (value instanceof RealValue) {
                stepVals.add(new StepVal(this.portNames.get(i), ((RealValue)value).getValue()));
                continue;
            }
            if (value instanceof BooleanValue) {
                stepVals.add(new StepVal(this.portNames.get(i), ((BooleanValue)value).getValue()));
                continue;
            }
            if (!(value instanceof EnumerationValue)) continue;
            stepVals.add(new StepVal(this.portNames.get(i), ((EnumerationValue)value).getValue()));
        }
        return stepVals;
    }

    private Map<ModelConnection.ModelInstance, Map<ModelDescription.ScalarVariable, Object>> mapModelInstancesToPortValues(List<StepVal> dataPointsToMap) {
        HashMap<ModelConnection.ModelInstance, Map<ModelDescription.ScalarVariable, Object>> values = new HashMap<ModelConnection.ModelInstance, Map<ModelDescription.ScalarVariable, Object>>();
        this.instances.forEach((mi, fsi) -> {
            HashMap portValues = new HashMap();
            fsi.config.scalarVariables.forEach(sv -> dataPointsToMap.stream().filter(dp -> dp.getName().equals(mi.key + "." + mi.instanceName + "." + sv.name)).findFirst().ifPresent(val -> portValues.putIfAbsent(sv, val.getValue())));
            values.put((ModelConnection.ModelInstance)mi, portValues);
        });
        return values;
    }

    public static class StepVal {
        private String name;
        private Object value;

        public StepVal(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setValue(Object value) {
            this.value = value;
        }
    }
}

