/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.interpreter.values.variablestep;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.stream.Collectors;
import org.apache.commons.text.StringEscapeUtils;
import org.intocps.fmi.Fmi2Status;
import org.intocps.fmi.FmiInvalidNativeStateException;
import org.intocps.fmi.FmuResult;
import org.intocps.fmi.IFmiComponent;
import org.intocps.maestro.fmi.FmiInstanceConfig;
import org.intocps.maestro.fmi.FmiSimulationInstance;
import org.intocps.maestro.fmi.ModelDescription;
import org.intocps.maestro.framework.fmi2.ModelConnection;
import org.intocps.maestro.interpreter.InterpreterException;
import org.intocps.maestro.interpreter.ValueExtractionUtilities;
import org.intocps.maestro.interpreter.values.BooleanValue;
import org.intocps.maestro.interpreter.values.FunctionValue;
import org.intocps.maestro.interpreter.values.ModuleValue;
import org.intocps.maestro.interpreter.values.RealValue;
import org.intocps.maestro.interpreter.values.StringValue;
import org.intocps.maestro.interpreter.values.Value;
import org.intocps.maestro.interpreter.values.VoidValue;
import org.intocps.maestro.interpreter.values.fmi.FmuComponentValue;
import org.intocps.maestro.interpreter.values.variablestep.InitializationMsgJson;
import org.intocps.maestro.interpreter.values.variablestep.StepsizeInterval;
import org.intocps.maestro.interpreter.values.variablestep.VariableStepConfigValue;

public class VariableStepValue
extends ModuleValue {
    public VariableStepValue(String configuration) {
        super(VariableStepValue.createMembers(configuration));
    }

    private static Set<InitializationMsgJson.Constraint> getConstraintsFromConfig(JsonNode config) {
        HashSet<InitializationMsgJson.Constraint> constraints = new HashSet<InitializationMsgJson.Constraint>();
        Map namedConstraints = (Map)new ObjectMapper().convertValue((Object)config.get("constraints"), (TypeReference)new TypeReference<Map<String, Map<String, Object>>>(){});
        if (namedConstraints == null) {
            return constraints;
        }
        for (Map.Entry entry : namedConstraints.entrySet()) {
            InitializationMsgJson.Constraint constraint = InitializationMsgJson.Constraint.parse((Map)entry.getValue());
            constraint.setId((String)entry.getKey());
            constraints.add(constraint);
        }
        return constraints;
    }

    private static StepsizeInterval getStepSizeIntervalFromConfig(JsonNode config) {
        Vector<Double> sizes = new Vector<Double>();
        List objSizes = (List)new ObjectMapper().convertValue((Object)config.get("size"), (TypeReference)new TypeReference<List<Object>>(){});
        for (Object number : objSizes) {
            if (number instanceof Integer) {
                sizes.add(Double.valueOf(((Integer)number).intValue()));
                continue;
            }
            if (!(number instanceof Double)) continue;
            sizes.add((Double)number);
        }
        return new StepsizeInterval((Double)sizes.get(0), (Double)sizes.get(1));
    }

    private static Double getInitSizeFromConfig(JsonNode config) {
        Double initsize = -1.0;
        Object objInitsize = new ObjectMapper().convertValue((Object)config.get("initsize"), (TypeReference)new TypeReference<Object>(){});
        if (objInitsize instanceof Double) {
            initsize = (Double)objInitsize;
        } else if (objInitsize instanceof Integer) {
            initsize = (double)((Integer)objInitsize);
        }
        return initsize;
    }

    private static Double calculateMaxStepSize(Double minStepSize, Double maxStepSize, Map<ModelConnection.ModelInstance, FmiSimulationInstance> instances) {
        boolean allGreaterOrEqualMaxSize = true;
        Double stepSize = Double.MAX_VALUE;
        for (FmiSimulationInstance instance : instances.values()) {
            try {
                if (instance.instance == null) continue;
                FmuResult res = instance.instance.getMaxStepSize();
                if (res.status == Fmi2Status.Error) continue;
                double maxSize = (Double)res.result;
                if (maxSize < minStepSize) {
                    return minStepSize;
                }
                allGreaterOrEqualMaxSize = allGreaterOrEqualMaxSize && maxSize >= maxStepSize;
                stepSize = Math.min(maxSize, stepSize);
            }
            catch (FmiInvalidNativeStateException fmiInvalidNativeStateException) {}
        }
        if (allGreaterOrEqualMaxSize || stepSize.equals(Double.MAX_VALUE)) {
            return maxStepSize;
        }
        return stepSize;
    }

    private static Map<String, Value> createMembers(String algorithmAsUriOrJson) {
        JsonNode config;
        block7: {
            config = null;
            try {
                URI pathAsUri = URI.create(new URI(algorithmAsUriOrJson).getRawPath());
                if (!pathAsUri.isAbsolute()) {
                    pathAsUri = new File(".").toURI().resolve(pathAsUri);
                }
                config = new ObjectMapper().readTree(new String(Files.readAllBytes(Paths.get(pathAsUri))));
            }
            catch (IOException | URISyntaxException e) {
                if (!(e instanceof IOException)) break block7;
                throw new InterpreterException("Configuration could not be passed", e);
            }
        }
        if (config == null) {
            try {
                config = new ObjectMapper().readTree(StringEscapeUtils.unescapeJava((String)algorithmAsUriOrJson));
            }
            catch (JsonProcessingException e) {
                throw new InterpreterException("Configuration could not be passed", e);
            }
        }
        if (config == null) {
            throw new InterpreterException("Configuration could not be passed");
        }
        Set<InitializationMsgJson.Constraint> constraints = VariableStepValue.getConstraintsFromConfig(config);
        StepsizeInterval stepsizeInterval = VariableStepValue.getStepSizeIntervalFromConfig(config);
        Double initSize = VariableStepValue.getInitSizeFromConfig(config);
        HashMap<String, Value> componentMembers = new HashMap<String, Value>();
        componentMembers.put("setFMUs", new FunctionValue.ExternalFunctionValue(fcargs -> {
            VariableStepValue.checkArgLength(fcargs, 2);
            try {
                List<StringValue> fullyQualifiedFMUInstanceNames = ValueExtractionUtilities.getArrayValue((Value)fcargs.get(0), StringValue.class);
                List<FmuComponentValue> fmus = ValueExtractionUtilities.getArrayValue((Value)fcargs.get(1), FmuComponentValue.class);
                HashMap<ModelConnection.ModelInstance, FmiSimulationInstance> instances = new HashMap<ModelConnection.ModelInstance, FmiSimulationInstance>();
                for (int i = 0; i < fullyQualifiedFMUInstanceNames.size(); ++i) {
                    String instanceName = fullyQualifiedFMUInstanceNames.get(i).getValue().split("\\.")[1];
                    String fmuName = fullyQualifiedFMUInstanceNames.get(i).getValue().split("\\.")[0];
                    ModelConnection.ModelInstance mi = new ModelConnection.ModelInstance(fmuName, instanceName);
                    IFmiComponent fmu = (IFmiComponent)fmus.get(i).getModule();
                    ModelDescription modelDescription = new ModelDescription(fmu.getFmu().getModelDescription());
                    FmiInstanceConfig fmiInstanceConfig = new FmiInstanceConfig(modelDescription, modelDescription.getScalarVariables());
                    FmiSimulationInstance si = new FmiSimulationInstance(null, fmiInstanceConfig);
                    instances.put(mi, si);
                }
                return new VariableStepConfigValue(instances, constraints, stepsizeInterval, initSize, VariableStepValue.calculateMaxStepSize(stepsizeInterval.getMinimalStepsize(), stepsizeInterval.getMaximalStepsize(), instances));
            }
            catch (Exception e) {
                throw new InterpreterException("Could not set FMUs", e);
            }
        }));
        componentMembers.put("initializePortNames", new FunctionValue.ExternalFunctionValue(fcargs -> {
            VariableStepValue.checkArgLength(fcargs, 2);
            Value cv = ((Value)fcargs.get(0)).deref();
            if (!(cv instanceof VariableStepConfigValue)) {
                throw new InterpreterException("Invalid arguments");
            }
            VariableStepConfigValue variableStepConfig = (VariableStepConfigValue)cv;
            variableStepConfig.initializePorts(ValueExtractionUtilities.getArrayValue((Value)fcargs.get(1), StringValue.class).stream().map(StringValue::getValue).collect(Collectors.toList()));
            return new VoidValue();
        }));
        componentMembers.put("addDataPoint", new FunctionValue.ExternalFunctionValue(fcargs -> {
            VariableStepValue.checkArgLength(fcargs, 3);
            Value cv = ((Value)fcargs.get(0)).deref();
            if (!(cv instanceof VariableStepConfigValue)) {
                throw new InterpreterException("Invalid arguments");
            }
            VariableStepConfigValue variableStepConfigValue = (VariableStepConfigValue)cv;
            double time = ((RealValue)((Value)fcargs.get(1)).deref()).getValue();
            List<Value> portValues = ValueExtractionUtilities.getArrayValue((Value)fcargs.get(2), Value.class);
            variableStepConfigValue.addDataPoint(time, portValues);
            return new VoidValue();
        }));
        componentMembers.put("getStepSize", new FunctionValue.ExternalFunctionValue(fcargs -> {
            VariableStepValue.checkArgLength(fcargs, 1);
            Value cv = ((Value)fcargs.get(0)).deref();
            if (cv instanceof VariableStepConfigValue) {
                VariableStepConfigValue variableStepConfigValue = (VariableStepConfigValue)cv;
                return new RealValue(variableStepConfigValue.getStepSize());
            }
            throw new InterpreterException("Invalid arguments");
        }));
        componentMembers.put("setEndTime", new FunctionValue.ExternalFunctionValue(fcargs -> {
            VariableStepValue.checkArgLength(fcargs, 2);
            Value cv = ((Value)fcargs.get(0)).deref();
            if (!(cv instanceof VariableStepConfigValue)) {
                throw new InterpreterException("Invalid arguments");
            }
            ((VariableStepConfigValue)cv).setEndTime(((RealValue)((Value)fcargs.get(1)).deref()).getValue());
            return new VoidValue();
        }));
        componentMembers.put("isStepValid", new FunctionValue.ExternalFunctionValue(fcargs -> {
            VariableStepValue.checkArgLength(fcargs, 4);
            Value cv = ((Value)fcargs.get(0)).deref();
            if (cv instanceof VariableStepConfigValue) {
                VariableStepConfigValue variableStepConfigValue = (VariableStepConfigValue)cv;
                double nextTime = ((RealValue)((Value)fcargs.get(1)).deref()).getValue();
                boolean supportsRollBack = ((BooleanValue)((Value)fcargs.get(2)).deref()).getValue();
                List<Value> portValues = ValueExtractionUtilities.getArrayValue((Value)fcargs.get(3), Value.class);
                return new BooleanValue(variableStepConfigValue.isStepValid(nextTime, portValues, supportsRollBack));
            }
            throw new InterpreterException("Invalid arguments");
        }));
        componentMembers.put("hasReducedStepsize", new FunctionValue.ExternalFunctionValue(fcargs -> {
            VariableStepValue.checkArgLength(fcargs, 1);
            Value cv = ((Value)fcargs.get(0)).deref();
            if (cv instanceof VariableStepConfigValue) {
                VariableStepConfigValue variableStepConfigValue = (VariableStepConfigValue)cv;
                return new BooleanValue(variableStepConfigValue.hasReducedStepSize());
            }
            throw new InterpreterException("Invalid arguments");
        }));
        componentMembers.put("getReducedStepSize", new FunctionValue.ExternalFunctionValue(fcargs -> {
            VariableStepValue.checkArgLength(fcargs, 1);
            Value cv = ((Value)fcargs.get(0)).deref();
            if (cv instanceof VariableStepConfigValue) {
                VariableStepConfigValue variableStepConfigValue = (VariableStepConfigValue)cv;
                return new RealValue(variableStepConfigValue.getReducedStepSize());
            }
            throw new InterpreterException("Invalid arguments");
        }));
        return componentMembers;
    }
}

