/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.interpreter.values.variablestep.constraint;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Observable;
import java.util.Set;
import org.intocps.maestro.fmi.ModelDescription;
import org.intocps.maestro.framework.fmi2.ModelConnection;
import org.intocps.maestro.interpreter.InterpreterException;
import org.intocps.maestro.interpreter.values.variablestep.InitializationMsgJson;
import org.intocps.maestro.interpreter.values.variablestep.StepsizeInterval;
import org.intocps.maestro.interpreter.values.variablestep.constraint.ConstraintHandler;
import org.intocps.maestro.interpreter.values.variablestep.constraint.ConstraintType;
import org.intocps.maestro.interpreter.values.variablestep.constraint.FmuMaxStepSizeHandler;
import org.intocps.maestro.interpreter.values.variablestep.constraint.boundeddifference.BoundedDifferenceHandler;
import org.intocps.maestro.interpreter.values.variablestep.constraint.samplingrate.SamplingRateHandler;
import org.intocps.maestro.interpreter.values.variablestep.constraint.zerocrossing.ZerocrossingHandler;
import org.slf4j.Logger;

public class ConstraintHandlerFactory {
    public static ConstraintHandler getHandler(Observable obs, InitializationMsgJson.Constraint jc, StepsizeInterval interval, Double strongRelaxationFactor, Map<ModelConnection.Variable, ModelDescription.Types> portTypeMap, Logger logger) throws InterpreterException {
        HashMap<ConstraintType, HashSet<ModelDescription.Types>> validTypeMap = new HashMap<ConstraintType, HashSet<ModelDescription.Types>>();
        validTypeMap.put(ConstraintType.ZEROCROSSING, new HashSet<ModelDescription.Types>(Arrays.asList(ModelDescription.Types.Real)));
        validTypeMap.put(ConstraintType.BOUNDEDDIFFERENCE, new HashSet<ModelDescription.Types>(Arrays.asList(ModelDescription.Types.Real, ModelDescription.Types.Integer)));
        if (ConstraintType.ZEROCROSSING.equals((Object)jc.getType())) {
            ConstraintHandlerFactory.validatePortTypes(portTypeMap, (Set)validTypeMap.get((Object)ConstraintType.ZEROCROSSING), jc, logger);
            return new ZerocrossingHandler(obs, jc, interval, strongRelaxationFactor);
        }
        if (ConstraintType.BOUNDEDDIFFERENCE.equals((Object)jc.getType())) {
            ConstraintHandlerFactory.validatePortTypes(portTypeMap, (Set)validTypeMap.get((Object)ConstraintType.BOUNDEDDIFFERENCE), jc, logger);
            return new BoundedDifferenceHandler(obs, jc, interval, strongRelaxationFactor);
        }
        if (ConstraintType.SAMPLINGRATE.equals((Object)jc.getType())) {
            return new SamplingRateHandler(obs, jc, interval);
        }
        if (ConstraintType.FMUMAXSTEPSIZE.equals((Object)jc.getType())) {
            return new FmuMaxStepSizeHandler(jc);
        }
        return null;
    }

    private static void validatePortTypes(Map<ModelConnection.Variable, ModelDescription.Types> portTypeMap, Set<ModelDescription.Types> validTypes, InitializationMsgJson.Constraint jc, Logger logger) throws InterpreterException {
        for (ModelConnection.Variable var : jc.getPorts()) {
            String varname = var.instance.key + "." + var.instance.instanceName + "." + var.variable;
            Boolean isFound = false;
            for (ModelConnection.Variable port : portTypeMap.keySet()) {
                if (!var.instance.key.equals(port.instance.key) || !var.instance.instanceName.equals(port.instance.instanceName) || !var.variable.equals(port.variable)) continue;
                isFound = true;
                ModelDescription.Types type = portTypeMap.get(port);
                if (validTypes.contains(type)) break;
                String errMsg = "Datatype " + type.toString() + " of variable " + varname + " is not a valid port-type for constraint of type " + jc.type + ". Please use only ports with type " + validTypes.toString();
                logger.error(errMsg);
                throw new InterpreterException(errMsg);
            }
            if (isFound.booleanValue()) continue;
            String foundMsg = "Variable '" + varname + "' and datatype could not be validated.";
            logger.error(foundMsg);
            throw new InterpreterException(foundMsg);
        }
    }
}

