/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.interpreter.values.variablestep.constraint.boundeddifference;

import java.util.Observable;
import java.util.Observer;
import org.intocps.maestro.interpreter.values.variablestep.CurrentSolutionPoint;
import org.intocps.maestro.interpreter.values.variablestep.InitializationMsgJson;
import org.intocps.maestro.interpreter.values.variablestep.StepsizeInterval;
import org.intocps.maestro.interpreter.values.variablestep.constraint.ConstraintHandler;
import org.intocps.maestro.interpreter.values.variablestep.constraint.boundeddifference.BoundedDifferenceCalculator;
import org.intocps.maestro.interpreter.values.variablestep.constraint.boundeddifference.stepsize.BdStepsizeAdjustmentStrategy;
import org.intocps.maestro.interpreter.values.variablestep.constraint.boundeddifference.stepsize.SimpleBdStepsizeAdjustmentStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoundedDifferenceHandler
implements Observer,
ConstraintHandler {
    static final Logger logger = LoggerFactory.getLogger(BoundedDifferenceHandler.class);
    private final BdStepsizeAdjustmentStrategy stepsizeAdjustmentStrategy;
    private final BoundedDifferenceCalculator calculator;
    private final StepsizeInterval interval;
    private final String id;
    private final Double absTol;
    private final Double relTol;
    private BoundedDifferenceHandler previousState = null;
    private Double prevStepsize;
    private Double currentTime;
    private Double nextTime;

    public BoundedDifferenceHandler(Observable observable, InitializationMsgJson.Constraint jc, StepsizeInterval interval, Double strongRelaxationFactor) {
        this.calculator = new BoundedDifferenceCalculator(observable, jc.getPorts());
        this.absTol = jc.getAbsoluteTolerance();
        this.relTol = jc.getRelativeTolerance();
        this.id = jc.getId();
        this.interval = interval;
        this.stepsizeAdjustmentStrategy = new SimpleBdStepsizeAdjustmentStrategy(this.calculator, jc, interval, strongRelaxationFactor, observable);
        observable.addObserver(this);
    }

    public BoundedDifferenceHandler(BoundedDifferenceHandler bdh) {
        this.prevStepsize = bdh.prevStepsize;
        this.stepsizeAdjustmentStrategy = bdh.stepsizeAdjustmentStrategy;
        this.calculator = bdh.calculator;
        this.interval = bdh.interval;
        this.id = bdh.id;
        this.currentTime = bdh.currentTime;
        this.absTol = bdh.absTol;
        this.relTol = bdh.relTol;
        this.nextTime = bdh.nextTime;
        this.previousState = null;
    }

    @Override
    public void update(Observable obs, Object arg) {
        if (obs instanceof CurrentSolutionPoint) {
            CurrentSolutionPoint cs = (CurrentSolutionPoint)obs;
            CurrentSolutionPoint.Operation op = cs.getOperation();
            if (CurrentSolutionPoint.Operation.ADVANCE.equals((Object)op)) {
                this.previousState = new BoundedDifferenceHandler(this);
                this.prevStepsize = cs.getPrevStepsize();
                this.currentTime = cs.getCurrentTime();
                this.nextTime = null;
            }
            if (CurrentSolutionPoint.Operation.PEEK.equals((Object)op)) {
                this.nextTime = cs.getNextTime();
            }
            if (CurrentSolutionPoint.Operation.ROLLBACK.equals((Object)op)) {
                this.prevStepsize = this.previousState.prevStepsize;
                this.currentTime = this.previousState.currentTime;
                this.nextTime = this.previousState.nextTime;
                this.previousState = null;
            }
        }
    }

    @Override
    public Double getMaxStepSize() {
        return this.stepsizeAdjustmentStrategy.getStepsize(this.prevStepsize);
    }

    @Override
    public String getDecision() {
        return this.stepsizeAdjustmentStrategy.getDecision();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Boolean isRelaxingStrongly() {
        return this.stepsizeAdjustmentStrategy.isRelaxingStrongly();
    }

    @Override
    public Boolean wasStepValid() {
        Double relDistance;
        Boolean valid = true;
        Double absDistance = this.calculator.getNextAbsoluteDifference();
        if (Math.abs(absDistance) > this.absTol) {
            this.logAbsoluteToleranceViolation(absDistance);
            valid = false;
        }
        if (Math.abs(relDistance = this.calculator.getNextRelativeDifference()) > this.relTol) {
            this.logRelativeToleranceViolation(relDistance);
            valid = false;
        }
        return valid;
    }

    private void logAbsoluteToleranceViolation(Double distance) {
        Double peekStepsize = this.nextTime - this.currentTime;
        Boolean isStepsizeMinimal = peekStepsize.equals(this.interval.getMinimalStepsize());
        Object msg = "Absolute tolerance violated!\n";
        msg = (String)msg + "\t| The bound difference defined by the constraint \"";
        msg = (String)msg + this.id;
        msg = (String)msg + "\"\n\t| could not be met in the time interval [ ";
        msg = (String)msg + this.currentTime;
        msg = (String)msg + " ; ";
        msg = (String)msg + this.nextTime;
        msg = (String)msg + " ]\n\t| as the absolute difference of ";
        msg = (String)msg + distance;
        msg = (String)msg + "\n\t| exceeds the absolute tolerance of ";
        msg = (String)msg + this.absTol;
        if (isStepsizeMinimal.booleanValue()) {
            msg = (String)msg + "\n\t| The stepsize equals the minimal stepsize of ";
            msg = (String)msg + this.interval.getMinimalStepsize();
            msg = (String)msg + " !";
        }
        logger.warn((String)msg);
    }

    private void logRelativeToleranceViolation(Double distance) {
        Double peekStepsize = this.nextTime - this.currentTime;
        Boolean isStepsizeMinimal = peekStepsize.equals(this.interval.getMinimalStepsize());
        Object msg = "Relative tolerance violated!\n";
        msg = (String)msg + "\t| The bound difference defined by the constraint \"";
        msg = (String)msg + this.id;
        msg = (String)msg + "\"\n\t| could not be met in the time interval [ ";
        msg = (String)msg + this.currentTime;
        msg = (String)msg + " ; ";
        msg = (String)msg + this.nextTime;
        msg = (String)msg + " ]\n\t| as the relative difference of ";
        msg = (String)msg + distance;
        msg = (String)msg + "\n\t| exceeds the relative tolerance of ";
        msg = (String)msg + this.relTol;
        if (isStepsizeMinimal.booleanValue()) {
            msg = (String)msg + "\n\t| The stepsize equals the minimal stepsize of ";
            msg = (String)msg + this.interval.getMinimalStepsize();
            msg = (String)msg + " !";
        }
        logger.warn((String)msg);
    }
}

