/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.interpreter.values;

import java.util.HashMap;
import java.util.Map;
import org.intocps.maestro.interpreter.InterpreterException;
import org.intocps.maestro.interpreter.values.FunctionValue;
import org.intocps.maestro.interpreter.values.IntegerValue;
import org.intocps.maestro.interpreter.values.ModuleValue;
import org.intocps.maestro.interpreter.values.RealValue;
import org.intocps.maestro.interpreter.values.Value;
import org.intocps.maestro.interpreter.values.VoidValue;

public class RealTimeValue
extends ModuleValue {
    public RealTimeValue() {
        super(RealTimeValue.createMembers());
    }

    private static Map<String, Value> createMembers() {
        HashMap<String, Value> componentMembers = new HashMap<String, Value>();
        componentMembers.put("getRealTime", new FunctionValue.ExternalFunctionValue(fcArgs -> {
            long sysTime = System.currentTimeMillis();
            return new RealValue(sysTime);
        }));
        componentMembers.put("sleep", new FunctionValue.ExternalFunctionValue(args -> {
            long sleepTime;
            if (((Value)args.get(0)).deref() instanceof RealValue) {
                sleepTime = (long)((RealValue)((Value)args.get(0)).deref()).getValue();
            } else if (((Value)args.get(0)).deref() instanceof IntegerValue) {
                sleepTime = ((IntegerValue)((Value)args.get(0)).deref()).getValue();
            } else {
                throw new InterpreterException("Sleep time is not a valid value.");
            }
            if (sleepTime < 0L) {
                throw new InterpreterException("Sleep time cannot be a negative number.");
            }
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {
                throw new InterpreterException("Error occurred during sleep: " + e);
            }
            return new VoidValue();
        }));
        return componentMembers;
    }
}

