/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.interpreter.values.variablestep.extrapolationerror;

public class ExtrapolationErrorEstimator {
    private final Double FIRSTORDER_IIR_PAST_WEIGHT = 0.7;
    private final Double INITIAL_PREDICTION_ERROR = 0.0;
    private ExtrapolationErrorEstimator previousState = null;
    private Double filteredExtrapolationError = this.INITIAL_PREDICTION_ERROR;
    private Integer predictionOrder;
    private Double[] x = null;

    public ExtrapolationErrorEstimator(Integer predictionOrder) {
        assert (this.FIRSTORDER_IIR_PAST_WEIGHT >= 0.0 && this.FIRSTORDER_IIR_PAST_WEIGHT <= 1.0);
        this.predictionOrder = predictionOrder;
    }

    public ExtrapolationErrorEstimator(ExtrapolationErrorEstimator eee) {
        this.filteredExtrapolationError = eee.filteredExtrapolationError;
        this.predictionOrder = eee.predictionOrder;
        this.x = eee.x;
    }

    public Double getEstimate() {
        return this.filteredExtrapolationError;
    }

    public void update(Double[] xNew, Double prevStepsize) {
        this.previousState = new ExtrapolationErrorEstimator(this);
        Double currentError = this.calcCurrentExtrapolationError(xNew[0], prevStepsize);
        this.filteredExtrapolationError = currentError >= this.filteredExtrapolationError ? currentError : Double.valueOf(this.FIRSTORDER_IIR_PAST_WEIGHT * this.filteredExtrapolationError + (1.0 - this.FIRSTORDER_IIR_PAST_WEIGHT) * currentError);
        this.x = xNew;
    }

    public void rollback() {
        this.filteredExtrapolationError = this.previousState.filteredExtrapolationError;
        this.x = this.previousState.x;
        this.previousState = null;
    }

    private Double calcCurrentExtrapolationError(Double currentValue, Double prevStepsize) {
        if (prevStepsize == null || this.x == null || this.x[1] == null) {
            return this.filteredExtrapolationError;
        }
        Double prediction = this.x[0] + this.x[1] * prevStepsize;
        if (this.predictionOrder == 2) {
            prediction = prediction + 0.5 * this.x[2] * Math.pow(prevStepsize, 2.0);
        }
        return Math.abs((currentValue - prediction) / Math.max(Math.abs(currentValue), Double.MIN_VALUE));
    }
}

