/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.interpreter;

import java.util.List;
import java.util.stream.Collectors;
import org.intocps.maestro.ast.analysis.AnalysisException;
import org.intocps.maestro.ast.analysis.intf.IQuestionAnswer;
import org.intocps.maestro.ast.node.AArrayIndexExp;
import org.intocps.maestro.interpreter.Context;
import org.intocps.maestro.interpreter.IExternalValueFactory;
import org.intocps.maestro.interpreter.Interpreter;
import org.intocps.maestro.interpreter.values.ArrayValue;
import org.intocps.maestro.interpreter.values.NumericValue;
import org.intocps.maestro.interpreter.values.Value;
import org.intocps.maestro.interpreter.values.utilities.ArrayUpdatableValue;

class ByRefInterpreter
extends Interpreter {
    public ByRefInterpreter(IExternalValueFactory loadFactory) {
        super(loadFactory);
    }

    @Override
    protected Value getInnerArrayValue(ArrayValue<Value> arrayValue, List<NumericValue> indices) {
        if (indices.size() > 2) {
            return this.getInnerArrayValue((ArrayValue)arrayValue.getValues().get(indices.get(0).intValue()).deref(), indices.subList(1, indices.size()));
        }
        return new ArrayUpdatableValue(arrayValue, indices.get(0).intValue());
    }

    @Override
    public Value caseAArrayIndexExp(AArrayIndexExp node, Context question) throws AnalysisException {
        Value value = ((Value)node.getArray().apply((IQuestionAnswer)this, (Object)question)).deref();
        if (value instanceof ArrayValue) {
            List<NumericValue> indices = this.evaluate(node.getIndices(), question).stream().map(Value::deref).map(NumericValue.class::cast).collect(Collectors.toList());
            return this.getInnerArrayValue((ArrayValue)value, indices);
        }
        throw new AnalysisException("No array or index for: " + node);
    }
}

