/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.interpreter;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.spencerwi.either.Either;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import org.intocps.maestro.ast.analysis.AnalysisException;
import org.intocps.maestro.interpreter.Fmi2Interpreter;
import org.intocps.maestro.interpreter.IExternalValueFactory;
import org.intocps.maestro.interpreter.InterpreterException;
import org.intocps.maestro.interpreter.api.IValueLifecycleHandler;
import org.intocps.maestro.interpreter.values.BooleanLogicValue;
import org.intocps.maestro.interpreter.values.BooleanValue;
import org.intocps.maestro.interpreter.values.ConsolePrinterValue;
import org.intocps.maestro.interpreter.values.ExternalModuleValue;
import org.intocps.maestro.interpreter.values.FunctionValue;
import org.intocps.maestro.interpreter.values.IntegerValue;
import org.intocps.maestro.interpreter.values.LoggerValue;
import org.intocps.maestro.interpreter.values.MathValue;
import org.intocps.maestro.interpreter.values.RealTimeValue;
import org.intocps.maestro.interpreter.values.RealValue;
import org.intocps.maestro.interpreter.values.StringValue;
import org.intocps.maestro.interpreter.values.Value;
import org.intocps.maestro.interpreter.values.VoidValue;
import org.intocps.maestro.interpreter.values.csv.CSVValue;
import org.intocps.maestro.interpreter.values.csv.CsvDataWriter;
import org.intocps.maestro.interpreter.values.datawriter.DataWriterValue;
import org.intocps.maestro.interpreter.values.derivativeestimator.DerivativeEstimatorValue;
import org.intocps.maestro.interpreter.values.fmi.FmuValue;
import org.intocps.maestro.interpreter.values.simulationcontrol.SimulationControlValue;
import org.intocps.maestro.interpreter.values.utilities.ArrayUtilValue;
import org.intocps.maestro.interpreter.values.variablestep.VariableStepValue;
import org.reflections.Reflections;
import org.reflections.scanners.SubTypesScanner;

public class DefaultExternalValueFactory
implements IExternalValueFactory {
    static final List<Class<? extends IValueLifecycleHandler>> defaultHandlers = Arrays.asList(LoggerLifecycleHandler.class, CsvLifecycleHandler.class, ArrayUtilLifecycleHandler.class, JavaClasspathLoaderLifecycleHandler.class, MathLifecycleHandler.class, Fmi2LifecycleHandler.class);
    private final File workingDirectory;
    protected Map<String, IValueLifecycleHandler> lifecycleHandlers;
    protected Map<Value, IValueLifecycleHandler> values = new HashMap<Value, IValueLifecycleHandler>();

    public DefaultExternalValueFactory(File workingDirectory, InputStream config) throws IOException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        this.workingDirectory = workingDirectory;
        this.lifecycleHandlers = new HashMap<String, IValueLifecycleHandler>();
        for (Class<? extends IValueLifecycleHandler> handler : defaultHandlers) {
            this.lifecycleHandlers.put(handler.getAnnotation(IValueLifecycleHandler.ValueLifecycle.class).name(), this.instantiateHandler(workingDirectory, handler));
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (config != null) {
            config.transferTo(baos);
        }
        this.lifecycleHandlers.put(DataWriterLifecycleHandler.class.getAnnotation(IValueLifecycleHandler.ValueLifecycle.class).name(), new DataWriterLifecycleHandler(workingDirectory, new ByteArrayInputStream(baos.toByteArray())));
        this.lifecycleHandlers.put(MEnvLifecycleHandler.class.getAnnotation(IValueLifecycleHandler.ValueLifecycle.class).name(), new MEnvLifecycleHandler(new ByteArrayInputStream(baos.toByteArray())));
        for (Class cls : new Class[]{Fmi2LifecycleHandler.class, LoggerLifecycleHandler.class, BooleanLogicLifecycleHandler.class, MathLifecycleHandler.class}) {
            this.lifecycleHandlers.put(cls.getAnnotation(IValueLifecycleHandler.ValueLifecycle.class).name(), this.instantiateHandler(workingDirectory, cls));
        }
    }

    public void addLifecycleHandler(Class<? extends IValueLifecycleHandler> handlerClass) throws InvocationTargetException, InstantiationException, IllegalAccessException, NoSuchMethodException {
        IValueLifecycleHandler value;
        IValueLifecycleHandler.ValueLifecycle annotation = handlerClass.getAnnotation(IValueLifecycleHandler.ValueLifecycle.class);
        if (annotation != null && (value = this.instantiateHandler(this.workingDirectory, handlerClass)) != null) {
            this.lifecycleHandlers.put(annotation.name(), value);
        }
    }

    public void addLifecycleHandler(IValueLifecycleHandler handler) {
        IValueLifecycleHandler.ValueLifecycle annotation = handler.getClass().getAnnotation(IValueLifecycleHandler.ValueLifecycle.class);
        if (annotation != null && handler != null) {
            this.lifecycleHandlers.put(annotation.name(), handler);
        }
    }

    private IValueLifecycleHandler instantiateHandler(File workingDirectory, Class<? extends IValueLifecycleHandler> handler) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        IValueLifecycleHandler value;
        try {
            value = handler.getDeclaredConstructor(File.class).newInstance(workingDirectory);
        }
        catch (NoSuchMethodException e) {
            try {
                value = handler.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (NoSuchMethodException e2) {
                return null;
            }
        }
        return value;
    }

    @Override
    public boolean supports(String type) throws Exception {
        return this.lazyGet(type) != null;
    }

    private IValueLifecycleHandler lazyGet(String type) throws Exception {
        IValueLifecycleHandler known = this.lifecycleHandlers.get(type);
        if (known != null) {
            return known;
        }
        List<Class<IValueLifecycleHandler>> handlers = this.scanForLifecycleHandlers(IValueLifecycleHandler.class);
        for (Class handler : handlers.stream().filter(h -> !this.lifecycleHandlers.containsKey(h.getAnnotation(IValueLifecycleHandler.ValueLifecycle.class).name())).collect(Collectors.toList())) {
            IValueLifecycleHandler value = this.instantiateHandler(this.workingDirectory, handler);
            if (value == null) continue;
            this.lifecycleHandlers.putIfAbsent(handler.getAnnotation(IValueLifecycleHandler.ValueLifecycle.class).name(), value);
        }
        if (this.lifecycleHandlers.containsKey(type)) {
            return this.lifecycleHandlers.get(type);
        }
        return null;
    }

    private <T> List<Class<? extends T>> scanForLifecycleHandlers(Class<T> type) {
        Reflections reflections = new Reflections(new Object[]{"org.intocps.maestro", this.getClass().getClassLoader(), new SubTypesScanner()});
        Set subTypes = reflections.getSubTypesOf(type);
        Predicate<Class> containsAnnotation = clz -> clz.getAnnotation(IValueLifecycleHandler.ValueLifecycle.class) != null;
        return subTypes.stream().filter(containsAnnotation).collect(Collectors.toList());
    }

    @Override
    public Either<Exception, Value> create(String loaderName, List<Value> args) {
        IValueLifecycleHandler handler = null;
        try {
            handler = this.lazyGet(loaderName);
        }
        catch (Exception e) {
            return Either.left((Object)e);
        }
        if (handler == null) {
            throw new InterpreterException("Could not construct type: " + loaderName);
        }
        Either<Exception, Value> value = handler.instantiate(args);
        if (value.isRight()) {
            this.values.put((Value)value.getRight(), handler);
        }
        return value;
    }

    @Override
    public Value destroy(Value value) {
        IValueLifecycleHandler handler = this.values.get(value.deref());
        if (handler != null) {
            handler.destroy(value);
            this.values.remove(value);
            return new VoidValue();
        }
        throw new InterpreterException("UnLoad of unknown type: " + value);
    }

    @IValueLifecycleHandler.ValueLifecycle(name="DataWriter")
    protected class DataWriterLifecycleHandler
    extends BaseLifecycleHandler {
        static final String DEFAULT_CSV_FILENAME = "outputs.csv";
        final String DATA_WRITER_TYPE_NAME;
        final String dataWriterFileNameFinal;
        final List<String> dataWriterFilterFinal;
        private final File workingDirectory;

        public DataWriterLifecycleHandler(File workingDirectory, InputStream config) throws IOException {
            JsonNode configTree;
            this.workingDirectory = workingDirectory;
            this.DATA_WRITER_TYPE_NAME = this.getClass().getAnnotation(IValueLifecycleHandler.ValueLifecycle.class).name();
            String dataWriterFileName = DEFAULT_CSV_FILENAME;
            List dataWriterFilter = null;
            if (config != null && (configTree = new ObjectMapper().readTree(config)).has(this.DATA_WRITER_TYPE_NAME)) {
                JsonNode dwConfig = configTree.get(this.DATA_WRITER_TYPE_NAME);
                for (JsonNode val : dwConfig) {
                    if (!val.has("type") || !val.get("type").isTextual() || !val.get("type").asText().equals("CSV")) continue;
                    if (val.has("filename") && val.get("filename").isTextual()) {
                        dataWriterFileName = val.get("filename").asText();
                    }
                    if (!val.has("filter")) continue;
                    dataWriterFilter = StreamSupport.stream(Spliterators.spliteratorUnknownSize(val.get("filter").iterator(), 16), false).map(v -> v.asText()).collect(Collectors.toList());
                }
            }
            this.dataWriterFileNameFinal = dataWriterFileName;
            this.dataWriterFilterFinal = dataWriterFilter;
        }

        @Override
        public Either<Exception, Value> instantiate(List<Value> args) {
            return Either.right((Object)new DataWriterValue(Collections.singletonList(new CsvDataWriter(this.workingDirectory == null ? new File(this.dataWriterFileNameFinal) : new File(this.workingDirectory, this.dataWriterFileNameFinal), this.dataWriterFilterFinal))));
        }
    }

    @IValueLifecycleHandler.ValueLifecycle(name="MEnv")
    public class MEnvLifecycleHandler
    extends BaseLifecycleHandler {
        public static final String ENVIRONMENT_VARIABLES = "environment_variables";
        private final Map<String, Object> rawData;

        public MEnvLifecycleHandler(InputStream config) throws IOException {
            Map map;
            this.rawData = config != null && config.available() > 0 ? (map = (Map)new ObjectMapper().readValue(config, (TypeReference)new TypeReference<Map<String, Object>>(){})) : null;
        }

        @Override
        public Either<Exception, Value> instantiate(List<Value> args) {
            if (this.rawData == null || !this.rawData.containsKey(ENVIRONMENT_VARIABLES)) {
                return Either.left((Object)new Exception("Missing required runtime key: environment_variables"));
            }
            Map data = (Map)this.rawData.get(ENVIRONMENT_VARIABLES);
            HashMap<String, FunctionValue.ExternalFunctionValue> members = new HashMap<String, FunctionValue.ExternalFunctionValue>();
            members.put("getBool", new FunctionValue.ExternalFunctionValue(a -> {
                Value.checkArgLength(a, 1);
                String key = this.getEnvName((List<Value>)a);
                Object val = data.get(key);
                if (val instanceof Integer) {
                    return new BooleanValue((Integer)val > 1);
                }
                if (val instanceof Boolean) {
                    return new BooleanValue((Boolean)val);
                }
                throw new InterpreterException("Env key not found with the right type. Key '" + key + "' value '" + val + "'");
            }));
            members.put("getInt", new FunctionValue.ExternalFunctionValue(a -> {
                Value.checkArgLength(a, 1);
                String key = this.getEnvName((List<Value>)a);
                Object val = data.get(key);
                if (val instanceof Integer) {
                    return new IntegerValue((Integer)val);
                }
                throw new InterpreterException("Env key not found with the right type. Key '" + key + "' value '" + val + "'");
            }));
            members.put("getReal", new FunctionValue.ExternalFunctionValue(a -> {
                Value.checkArgLength(a, 1);
                String key = this.getEnvName((List<Value>)a);
                Object val = data.get(key);
                if (val instanceof Integer) {
                    return new RealValue(((Integer)val).doubleValue());
                }
                if (val instanceof Double) {
                    return new RealValue((Double)val);
                }
                throw new InterpreterException("Env key not found with the right type. Key '" + key + "' value '" + val + "'");
            }));
            members.put("getString", new FunctionValue.ExternalFunctionValue(a -> {
                Value.checkArgLength(a, 1);
                String key = this.getEnvName((List<Value>)a);
                Object val = data.get(key);
                if (val instanceof String) {
                    return new StringValue((String)val);
                }
                throw new InterpreterException("Env key not found with the right type. Key '" + key + "' value '" + val + "'");
            }));
            ExternalModuleValue<Map<String, Object>> val = new ExternalModuleValue<Map<String, Object>>(members, data){};
            return Either.right((Object)val);
        }

        private String getEnvName(List<Value> a) {
            return ((StringValue)a.get(0).deref()).getValue();
        }
    }

    @IValueLifecycleHandler.ValueLifecycle(name="SimulationControl")
    public static class SimulationControlDefaultLifecycleHandler
    extends BaseLifecycleHandler {
        @Override
        public Either<Exception, Value> instantiate(List<Value> args) {
            return Either.right((Object)new SimulationControlValue());
        }
    }

    @IValueLifecycleHandler.ValueLifecycle(name="JFMI2")
    public static class JFmi2LifecycleHandler
    extends BaseLifecycleHandler {
        private final File workingDirectory;

        public JFmi2LifecycleHandler(File workingDirectory) {
            this.workingDirectory = workingDirectory;
        }

        @Override
        public void destroy(Value value) {
            if (value instanceof FmuValue) {
                FmuValue fmuVal = (FmuValue)value;
                FunctionValue unloadFunction = (FunctionValue)fmuVal.lookup("unload");
                unloadFunction.evaluate(Collections.emptyList());
            }
        }

        @Override
        public Either<Exception, Value> instantiate(List<Value> args) {
            String className = ((StringValue)args.get(0)).getValue();
            try {
                Class<?> clz = this.getClass().getClassLoader().loadClass(className);
                return Either.right((Object)new Fmi2Interpreter(this.workingDirectory).createFmiValue(clz));
            }
            catch (ClassNotFoundException e) {
                return Either.left((Object)((Object)new AnalysisException("The path passed to load is not a URI", (Throwable)e)));
            }
        }
    }

    @IValueLifecycleHandler.ValueLifecycle(name="FMI2")
    public static class Fmi2LifecycleHandler
    extends BaseLifecycleHandler {
        private final File workingDirectory;

        public Fmi2LifecycleHandler(File workingDirectory) {
            this.workingDirectory = workingDirectory;
        }

        @Override
        public void destroy(Value value) {
            if (value instanceof FmuValue) {
                FmuValue fmuVal = (FmuValue)value;
                FunctionValue unloadFunction = (FunctionValue)fmuVal.lookup("unload");
                unloadFunction.evaluate(Collections.emptyList());
            }
        }

        @Override
        public Either<Exception, Value> instantiate(List<Value> args) {
            String guid = ((StringValue)args.get(0)).getValue();
            String path = ((StringValue)args.get(1)).getValue();
            try {
                path = new URI(path).getRawPath();
            }
            catch (URISyntaxException e) {
                return Either.left((Object)((Object)new AnalysisException("The path passed to load is not a URI", (Throwable)e)));
            }
            return Either.right((Object)new Fmi2Interpreter(this.workingDirectory).createFmiValue(path, guid));
        }
    }

    @IValueLifecycleHandler.ValueLifecycle(name="BooleanLogic")
    public static class BooleanLogicLifecycleHandler
    extends BaseLifecycleHandler {
        @Override
        public Either<Exception, Value> instantiate(List<Value> args) {
            return Either.right((Object)new BooleanLogicValue());
        }
    }

    @IValueLifecycleHandler.ValueLifecycle(name="RealTime")
    public static class RealTimeLifecycleHandler
    extends BaseLifecycleHandler {
        @Override
        public Either<Exception, Value> instantiate(List<Value> args) {
            return Either.right((Object)new RealTimeValue());
        }
    }

    @IValueLifecycleHandler.ValueLifecycle(name="Math")
    public static class MathLifecycleHandler
    extends BaseLifecycleHandler {
        @Override
        public Either<Exception, Value> instantiate(List<Value> args) {
            return Either.right((Object)new MathValue());
        }
    }

    @IValueLifecycleHandler.ValueLifecycle(name="JavaClasspathLoader")
    public static class JavaClasspathLoaderLifecycleHandler
    extends BaseLifecycleHandler {
        @Override
        public Either<Exception, Value> instantiate(List<Value> args) {
            if (args.isEmpty()) {
                return Either.left((Object)new Exception("Missing arguments for java classpath loader. Expecting: <fully qualified class name> <args>..."));
            }
            Value classNameArg = args.get(0).deref();
            if (classNameArg instanceof StringValue) {
                String qualifiedClassName = ((StringValue)classNameArg).getValue();
                try {
                    Class<?> clz = Class.forName(qualifiedClassName);
                    if (!Value.class.isAssignableFrom(clz)) {
                        return Either.left((Object)new Exception("Class not compatible with: " + Value.class.getName()));
                    }
                    int argCount = args.size() - 1;
                    Class[] argTypes = (Class[])IntStream.range(0, argCount).mapToObj(i -> Value.class).toArray(Class[]::new);
                    if (argTypes.length == 0) {
                        Constructor<?> ctor = clz.getDeclaredConstructor(new Class[0]);
                        return Either.right((Object)((Value)ctor.newInstance(new Object[0])));
                    }
                    Constructor<?> ctor = clz.getDeclaredConstructor(argTypes);
                    return Either.right((Object)((Value)ctor.newInstance(args.stream().skip(1L).toArray(Value[]::new))));
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    return Either.left((Object)e);
                }
            }
            return Either.left((Object)new Exception("Missing name of the class to load"));
        }
    }

    @IValueLifecycleHandler.ValueLifecycle(name="ArrayUtil")
    public static class ArrayUtilLifecycleHandler
    extends BaseLifecycleHandler {
        @Override
        public Either<Exception, Value> instantiate(List<Value> args) {
            return Either.right((Object)new ArrayUtilValue());
        }
    }

    @IValueLifecycleHandler.ValueLifecycle(name="CSV")
    public static class CsvLifecycleHandler
    extends BaseLifecycleHandler {
        @Override
        public Either<Exception, Value> instantiate(List<Value> args) {
            return Either.right((Object)new CSVValue());
        }
    }

    @IValueLifecycleHandler.ValueLifecycle(name="ConsolePrinter")
    public static class ConsolePrinterLifecycleHandler
    extends BaseLifecycleHandler {
        @Override
        public Either<Exception, Value> instantiate(List<Value> args) {
            return Either.right((Object)new ConsolePrinterValue());
        }
    }

    @IValueLifecycleHandler.ValueLifecycle(name="Logger")
    public static class LoggerLifecycleHandler
    extends BaseLifecycleHandler {
        @Override
        public Either<Exception, Value> instantiate(List<Value> args) {
            return Either.right((Object)new LoggerValue());
        }
    }

    @IValueLifecycleHandler.ValueLifecycle(name="DerivativeEstimator")
    public static class DerivativeEstimatorLifecycleHandler
    extends BaseLifecycleHandler {
        @Override
        public Either<Exception, Value> instantiate(List<Value> args) {
            return Either.right((Object)new DerivativeEstimatorValue());
        }
    }

    @IValueLifecycleHandler.ValueLifecycle(name="VariableStep")
    public static class VariableStepLifecycleHandler
    extends BaseLifecycleHandler {
        @Override
        public Either<Exception, Value> instantiate(List<Value> args) {
            if (args == null || args.isEmpty()) {
                return Either.left((Object)((Object)new AnalysisException("No values passed")));
            }
            if (args.stream().anyMatch(Objects::isNull)) {
                return Either.left((Object)((Object)new AnalysisException("Argument list contains null values")));
            }
            String config = ((StringValue)args.get(0).deref()).getValue();
            return Either.right((Object)new VariableStepValue(config));
        }
    }

    protected static abstract class BaseLifecycleHandler
    implements IValueLifecycleHandler {
        protected BaseLifecycleHandler() {
        }

        @Override
        public void destroy(Value value) {
        }

        public InputStream getMablModule() {
            return null;
        }
    }
}

