/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.interpreter.values.variablestep.constraint.samplingrate;

import java.util.Observable;
import java.util.Observer;
import org.intocps.maestro.interpreter.values.variablestep.CurrentSolutionPoint;
import org.intocps.maestro.interpreter.values.variablestep.InitializationMsgJson;
import org.intocps.maestro.interpreter.values.variablestep.StepsizeInterval;
import org.intocps.maestro.interpreter.values.variablestep.constraint.ConstraintHandler;
import org.intocps.maestro.interpreter.values.variablestep.constraint.samplingrate.Sampling;

public class SamplingRateHandler
implements Observer,
ConstraintHandler {
    private final Sampling sampling;
    private final StepsizeInterval interval;
    private final String id;
    private Double currentTime;

    public SamplingRateHandler(Observable observable, InitializationMsgJson.Constraint jc, StepsizeInterval interval) {
        this.sampling = jc.getSampling();
        this.interval = interval;
        this.id = jc.getId();
        observable.addObserver(this);
    }

    @Override
    public void update(Observable obs, Object arg) {
        if (obs instanceof CurrentSolutionPoint) {
            CurrentSolutionPoint cs = (CurrentSolutionPoint)obs;
            this.currentTime = cs.getCurrentTime();
        }
    }

    @Override
    public Double getMaxStepSize() {
        return Math.min(this.sampling.calcTimeToNextSample(this.currentTime), this.interval.getMaximalStepsize());
    }

    @Override
    public String getDecision() {
        return "adjust stepsize to hit next sampling time";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Boolean isRelaxingStrongly() {
        return false;
    }

    @Override
    public Boolean wasStepValid() {
        return true;
    }
}

