/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.interpreter.values.variablestep.constraint.zerocrossing.stepsize;

import org.intocps.maestro.interpreter.values.variablestep.StepsizeInterval;
import org.intocps.maestro.interpreter.values.variablestep.constraint.zerocrossing.detection.ZerocrossingConstraintState;
import org.intocps.maestro.interpreter.values.variablestep.constraint.zerocrossing.stepsize.ZcStepsizeAdjustmentStrategy;
import org.intocps.maestro.interpreter.values.variablestep.constraint.zerocrossing.stepsize.ZerocrossingPredictor;
import org.intocps.maestro.interpreter.values.variablestep.oscillation.OscillationDetector;
import org.intocps.maestro.interpreter.values.variablestep.valuetracker.OptionalDifferenceTracker;

public class DefaultZcStepsizeAdjustmentStrategy
implements ZcStepsizeAdjustmentStrategy {
    private static final Double TIGHTENING_FACTOR = 0.5;
    private static final Double RELAXATION_FACTOR = 1.2;
    private static final Double TOLERANCE_SAFETY_FACTOR = 0.5;
    private static final Double TIGHTENING_BOUNDARY_WHILE_APPROACHING = 1.5 * RELAXATION_FACTOR;
    private static final Double STRONG_RELAXATION_BOUNDARY_WHILE_APPROACHING_FACTOR = 10.0;
    private ZerocrossingPredictor predictor;
    private OptionalDifferenceTracker tracker;
    private OscillationDetector oscillationDetector;
    private StepsizeInterval interval;
    private Double tol;
    private Decision decision = null;
    private Double strongRelaxationFactor;
    private Double relaxationBoundaryWhileApproaching;
    private Double strongRelaxationBoundaryWhileApproaching;

    public DefaultZcStepsizeAdjustmentStrategy(OptionalDifferenceTracker tracker, Double tol, StepsizeInterval interval, Double strongRelaxationFactor, Double safety) {
        this.oscillationDetector = new OscillationDetector(tracker);
        this.predictor = new ZerocrossingPredictor(tracker, safety);
        this.tracker = tracker;
        this.tol = tol;
        this.interval = interval;
        this.strongRelaxationFactor = strongRelaxationFactor;
        this.relaxationBoundaryWhileApproaching = strongRelaxationFactor;
        this.strongRelaxationBoundaryWhileApproaching = STRONG_RELAXATION_BOUNDARY_WHILE_APPROACHING_FACTOR * this.relaxationBoundaryWhileApproaching;
    }

    @Override
    public Double getStepsize(ZerocrossingConstraintState state, Double lastContinuousStepsize) {
        if (ZerocrossingConstraintState.CROSSED.equals((Object)state)) {
            return this.calcStepsizeAfterZerocrossing(lastContinuousStepsize);
        }
        if (ZerocrossingConstraintState.APPROACHING.equals((Object)state)) {
            return this.calcStepsizeWhenApproachingZerocrossing(lastContinuousStepsize);
        }
        if (ZerocrossingConstraintState.DISTANCING.equals((Object)state)) {
            return this.calcStepsizeWhenDistancingZerocrossing(lastContinuousStepsize);
        }
        throw new IllegalStateException("Illegal ZerocrossingState");
    }

    @Override
    public String getDecision() {
        return this.decision.getLogText();
    }

    @Override
    public Boolean isRelaxingStrongly() {
        return Decision.DISTANCING_RELAXSTRONGLY.equals((Object)this.decision);
    }

    private Double calcStepsizeAfterZerocrossing(Double lastContinuousStepsize) {
        Double distance = this.tracker.getCurrentValue();
        DistanceBin bin = this.getBinByDistanceAndTolerance(distance, this.tol);
        if (this.oscillationDetector.areOscillationsBuildingUp().booleanValue()) {
            if (DistanceBin.OUTSIDE_TOLERANCE.equals((Object)bin)) {
                this.updateDecision(Decision.OSCILLATIONS_MINIMAL);
                return this.interval.getMinimalStepsize();
            }
            if (DistanceBin.WITHIN_TOLERANCE.equals((Object)bin)) {
                this.updateDecision(Decision.OSCILLATIONS_TIGHTEN);
                return this.getTightenedStepsize(lastContinuousStepsize);
            }
            this.updateDecision(Decision.OSCILLATIONS_CONSTANT);
            return lastContinuousStepsize;
        }
        if (DistanceBin.OUTSIDE_TOLERANCE.equals((Object)bin)) {
            this.updateDecision(Decision.ZEROCROSSING_TIGHTEN);
            return this.getTightenedStepsize(lastContinuousStepsize);
        }
        if (DistanceBin.WITHIN_TOLERANCE.equals((Object)bin)) {
            this.updateDecision(Decision.ZEROCROSSING_CONSTANT);
            return lastContinuousStepsize;
        }
        if (DistanceBin.WELL_WITHIN_TOLERANCE.equals((Object)bin)) {
            this.updateDecision(Decision.ZEROCROSSING_RELAX);
            return this.getRelaxedStepsize(lastContinuousStepsize);
        }
        throw new IllegalStateException("Unreachable code");
    }

    private Double calcStepsizeWhenApproachingZerocrossing(Double lastContinuousStepsize) {
        Double distance = this.tracker.getCurrentValue();
        DistanceBin bin = this.getBinByDistanceAndTolerance(distance, this.tol);
        if (DistanceBin.WELL_WITHIN_TOLERANCE.equals((Object)bin)) {
            this.updateDecision(Decision.APPROACHING_AT0X_RELAX);
            return this.getRelaxedStepsize(lastContinuousStepsize);
        }
        if (DistanceBin.WITHIN_TOLERANCE.equals((Object)bin)) {
            this.updateDecision(Decision.APPROACHING_AT0X_CONSTANT);
            return lastContinuousStepsize;
        }
        Double nStepsTo0X = this.predictor.estimateNStepsToZerocrossing(lastContinuousStepsize);
        if (nStepsTo0X <= 1.0) {
            this.updateDecision(Decision.APPROACHING_HIT);
            return this.getStepsizeToHitZerocrossing(lastContinuousStepsize, nStepsTo0X);
        }
        if (nStepsTo0X > this.strongRelaxationBoundaryWhileApproaching) {
            this.updateDecision(Decision.APPROACHING_STRONGLYRELAX);
            return this.getStronglyRelaxedStepsize(lastContinuousStepsize);
        }
        if (nStepsTo0X > this.relaxationBoundaryWhileApproaching) {
            this.updateDecision(Decision.APPROACHING_RELAX);
            return this.getRelaxedStepsize(lastContinuousStepsize);
        }
        if (nStepsTo0X > TIGHTENING_BOUNDARY_WHILE_APPROACHING) {
            this.updateDecision(Decision.APPROACHING_CONSTANT);
            return lastContinuousStepsize;
        }
        if (nStepsTo0X <= TIGHTENING_BOUNDARY_WHILE_APPROACHING) {
            this.updateDecision(Decision.APPROACHING_TIGHTEN);
            return this.getTightenedStepsize(lastContinuousStepsize);
        }
        throw new IllegalStateException("Unreachable code");
    }

    private void updateDecision(Decision newDecision) {
        this.decision = newDecision;
    }

    private Double calcStepsizeWhenDistancingZerocrossing(Double lastContinuousStepsize) {
        this.updateDecision(Decision.DISTANCING_RELAXSTRONGLY);
        return this.getStronglyRelaxedStepsize(lastContinuousStepsize);
    }

    private DistanceBin getBinByDistanceAndTolerance(Double dist, Double tol) {
        if (Math.abs(dist) < tol * TOLERANCE_SAFETY_FACTOR) {
            return DistanceBin.WELL_WITHIN_TOLERANCE;
        }
        if (Math.abs(dist) < tol) {
            return DistanceBin.WITHIN_TOLERANCE;
        }
        return DistanceBin.OUTSIDE_TOLERANCE;
    }

    private Double getTightenedStepsize(Double prevStepsize) {
        return this.interval.saturateStepsize(prevStepsize * TIGHTENING_FACTOR);
    }

    private Double getRelaxedStepsize(Double prevStepsize) {
        return this.interval.saturateStepsize(prevStepsize * RELAXATION_FACTOR);
    }

    private Double getStronglyRelaxedStepsize(Double prevStepsize) {
        return this.interval.saturateStepsize(prevStepsize * this.strongRelaxationFactor);
    }

    private Double getStepsizeToHitZerocrossing(Double prevStepsize, Double nStepsTo0X) {
        return this.interval.saturateStepsize(prevStepsize * nStepsTo0X);
    }

    private static enum Decision {
        OSCILLATIONS_MINIMAL,
        OSCILLATIONS_TIGHTEN,
        OSCILLATIONS_CONSTANT,
        ZEROCROSSING_TIGHTEN,
        ZEROCROSSING_CONSTANT,
        ZEROCROSSING_RELAX,
        APPROACHING_HIT,
        APPROACHING_STRONGLYRELAX,
        APPROACHING_RELAX,
        APPROACHING_CONSTANT,
        APPROACHING_TIGHTEN,
        APPROACHING_AT0X_CONSTANT,
        APPROACHING_AT0X_RELAX,
        DISTANCING_RELAXSTRONGLY;


        public String getLogText() {
            switch (this) {
                case OSCILLATIONS_MINIMAL: {
                    return "set stepsize to minimum (oscillations are building up)";
                }
                case OSCILLATIONS_TIGHTEN: {
                    return "tighten stepsize (oscillations are building up)";
                }
                case OSCILLATIONS_CONSTANT: {
                    return "hold stepsize constant (oscillations are building up)";
                }
                case ZEROCROSSING_TIGHTEN: {
                    return "tighten stepsize (zerocrossing just occurred)";
                }
                case ZEROCROSSING_CONSTANT: {
                    return "hold stepsize constant (zerocrossing just occurred)";
                }
                case ZEROCROSSING_RELAX: {
                    return "relax stepsize (zerocrossing just occurred)";
                }
                case APPROACHING_HIT: {
                    return "adjust stepsize to hit (possible zerocrossing imminent)";
                }
                case APPROACHING_STRONGLYRELAX: {
                    return "strongly relax stepsize (approaching zerocrossing)";
                }
                case APPROACHING_RELAX: {
                    return "relax stepsize (approaching zerocrossing)";
                }
                case APPROACHING_CONSTANT: {
                    return "hold stepsize constant (approaching zerocrossing)";
                }
                case APPROACHING_TIGHTEN: {
                    return "tighten stepsize (approaching zerocrossing)";
                }
                case APPROACHING_AT0X_CONSTANT: {
                    return "hold stepsize constant (within zerocrossing tolerance)";
                }
                case APPROACHING_AT0X_RELAX: {
                    return "relax stepsize (well within zerocrossing tolerance)";
                }
                case DISTANCING_RELAXSTRONGLY: {
                    return "strongly relax stepsize (distancing zerocrossing)";
                }
            }
            return "";
        }
    }

    private static enum DistanceBin {
        OUTSIDE_TOLERANCE,
        WITHIN_TOLERANCE,
        WELL_WITHIN_TOLERANCE;

    }
}

