/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.interpreter.values.variablestep.constraint.zerocrossing.stepsize;

import org.intocps.maestro.interpreter.values.variablestep.valuetracker.OptionalDifferenceTracker;

public class ZerocrossingPredictor {
    private OptionalDifferenceTracker tracker;
    private Double safety;

    public ZerocrossingPredictor(OptionalDifferenceTracker tracker, Double safety) {
        this.tracker = tracker;
        this.safety = safety;
    }

    public Double estimateNStepsToZerocrossing(Double prevStepsize) {
        Double nStepsExtrapolated = this.extrapolateNStepsToZerocrossing(prevStepsize);
        Double estimatedError = this.tracker.getExtrapolationErrorEstimate();
        return nStepsExtrapolated / (1.0 + estimatedError + this.safety);
    }

    private Double extrapolateNStepsToZerocrossing(Double prevStepsize) {
        Double currDistance = this.tracker.getCurrentValue();
        if (currDistance == null || currDistance == Double.MAX_VALUE) {
            return Double.MAX_VALUE;
        }
        Integer predictionOrder = this.tracker.getPredictionOrder();
        if (predictionOrder == 1) {
            return this.calcFirstOrderExtrapolation();
        }
        if (predictionOrder == 2) {
            return this.calcSecondOrderExtrapolation(prevStepsize);
        }
        throw new IllegalStateException("Unreachable code");
    }

    private Double calcFirstOrderExtrapolation() {
        Double currDistance = this.tracker.getCurrentValue();
        Double prevDistance = this.tracker.getPreviousValue();
        if (prevDistance == null || prevDistance == Double.MAX_VALUE) {
            return Double.MAX_VALUE;
        }
        Double firstOrderEstimate = Math.abs(currDistance) / Math.max(Double.MIN_VALUE, Math.abs(currDistance - prevDistance));
        return firstOrderEstimate;
    }

    private Double calcSecondOrderExtrapolation(Double prevStepsize) {
        Double x = this.tracker.getCurrentValue();
        Double xdot = this.tracker.getFirstDerivative();
        Double xdotdot = this.tracker.getSecondDerivative();
        if (xdotdot == 0.0) {
            return this.calcFirstOrderExtrapolation();
        }
        Double p = 2.0 * xdot / xdotdot;
        Double q = 2.0 * x / xdotdot;
        Double d = p * p / 4.0 - q;
        if (d < 0.0) {
            return Double.MAX_VALUE;
        }
        if (d == 0.0) {
            Double t = -p.doubleValue() / 2.0;
            if (t == 0.0) {
                return Double.MIN_VALUE;
            }
            if (t < 0.0) {
                return Double.MAX_VALUE;
            }
            return t / prevStepsize;
        }
        Double sqrtD = Math.sqrt(d);
        Double t1 = -p.doubleValue() / 2.0 - sqrtD;
        Double t2 = -p.doubleValue() / 2.0 + sqrtD;
        if (t1 > 0.0) {
            return t1 / prevStepsize;
        }
        if (t2 > 0.0) {
            return t2 / prevStepsize;
        }
        return Double.MAX_VALUE;
    }
}

