/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.interpreter.values.variablestep.valuetracker;

import java.util.Observable;
import java.util.Observer;
import org.intocps.maestro.framework.fmi2.ModelConnection;
import org.intocps.maestro.interpreter.values.derivativeestimator.ScalarDerivativeEstimator;
import org.intocps.maestro.interpreter.values.variablestep.CurrentSolutionPoint;
import org.intocps.maestro.interpreter.values.variablestep.extrapolationerror.ExtrapolationErrorEstimator;
import org.intocps.maestro.interpreter.values.variablestep.valuetracker.ValueTracker;

public class DoubleValueTracker
implements Observer,
ValueTracker {
    private DoubleValueTracker previousState = null;
    private ModelConnection.Variable trackedVariable;
    private Double xNext = null;
    private Double x = null;
    private Double xPrev = null;
    private Double xPrevPrev = null;
    private ScalarDerivativeEstimator derivativeEstimator;
    private ExtrapolationErrorEstimator extrapolationErrorEstimator;
    private Integer order;

    public DoubleValueTracker(DoubleValueTracker dvt) {
        this.trackedVariable = dvt.trackedVariable;
        this.xNext = dvt.xNext;
        this.x = dvt.x;
        this.xPrev = dvt.xPrev;
        this.xPrevPrev = dvt.xPrevPrev;
        this.derivativeEstimator = dvt.derivativeEstimator;
        this.extrapolationErrorEstimator = dvt.extrapolationErrorEstimator;
        this.order = dvt.order;
    }

    public DoubleValueTracker(Observable observable, ModelConnection.Variable variable, Integer predictionOrder) {
        observable.addObserver(this);
        this.trackedVariable = variable;
        this.order = predictionOrder;
        this.derivativeEstimator = new ScalarDerivativeEstimator(predictionOrder);
        this.extrapolationErrorEstimator = new ExtrapolationErrorEstimator(predictionOrder);
    }

    @Override
    public void update(Observable obs, Object arg) {
        if (obs instanceof CurrentSolutionPoint) {
            CurrentSolutionPoint cs = (CurrentSolutionPoint)obs;
            CurrentSolutionPoint.Operation op = cs.getOperation();
            if (CurrentSolutionPoint.Operation.ADVANCE.equals((Object)op)) {
                this.previousState = new DoubleValueTracker(this);
                this.xPrevPrev = this.xPrev;
                this.xPrev = this.x;
                this.x = cs.getDoubleValue(this.trackedVariable);
                this.xNext = null;
                Double firstDerivative = cs.getDerivative(this.trackedVariable, 1);
                Double secondDerivative = cs.getDerivative(this.trackedVariable, 2);
                Double[] xVec = new Double[]{this.x, firstDerivative, secondDerivative};
                Double prevStepsize = cs.getPrevStepsize();
                this.derivativeEstimator.advance(xVec, prevStepsize);
                this.extrapolationErrorEstimator.update(xVec, prevStepsize);
            }
            if (CurrentSolutionPoint.Operation.PEEK.equals((Object)op)) {
                this.xNext = cs.getNextDoubleValue(this.trackedVariable);
            }
            if (CurrentSolutionPoint.Operation.ROLLBACK.equals((Object)op)) {
                this.xNext = this.previousState.xNext;
                this.x = this.previousState.x;
                this.xPrev = this.previousState.xPrev;
                this.xPrevPrev = this.previousState.xPrevPrev;
                this.previousState = null;
                this.derivativeEstimator.rollback();
                this.extrapolationErrorEstimator.rollback();
            }
        }
    }

    @Override
    public Integer getPredictionOrder() {
        return this.order;
    }

    @Override
    public Double getNextValue() {
        return this.xNext;
    }

    @Override
    public Double getCurrentValue() {
        return this.x;
    }

    @Override
    public Double getPreviousValue() {
        return this.xPrev;
    }

    @Override
    public Double getPrevPrevValue() {
        return this.xPrevPrev;
    }

    @Override
    public Double getFirstDerivative() {
        return this.derivativeEstimator.getFirstDerivative();
    }

    @Override
    public Double getSecondDerivative() {
        return this.derivativeEstimator.getSecondDerivative();
    }

    @Override
    public Double getExtrapolationErrorEstimate() {
        return this.extrapolationErrorEstimator.getEstimate();
    }
}

