/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.interpreter;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.intocps.fmi.Fmi2Status;
import org.intocps.fmi.Fmi2StatusKind;
import org.intocps.fmi.FmiInvalidNativeStateException;
import org.intocps.fmi.FmuInvocationException;
import org.intocps.fmi.FmuMissingLibraryException;
import org.intocps.fmi.FmuResult;
import org.intocps.fmi.IFmiComponent;
import org.intocps.fmi.IFmiComponentState;
import org.intocps.fmi.IFmu;
import org.intocps.fmi.IFmuCallback;
import org.intocps.fmi.InvalidParameterException;
import org.intocps.maestro.fmi.Fmi2ModelDescription;
import org.intocps.maestro.framework.fmi2.FmuFactory;
import org.intocps.maestro.interpreter.Interpreter;
import org.intocps.maestro.interpreter.InterpreterException;
import org.intocps.maestro.interpreter.values.ArrayValue;
import org.intocps.maestro.interpreter.values.BooleanValue;
import org.intocps.maestro.interpreter.values.FunctionValue;
import org.intocps.maestro.interpreter.values.IntegerValue;
import org.intocps.maestro.interpreter.values.NullValue;
import org.intocps.maestro.interpreter.values.NumericValue;
import org.intocps.maestro.interpreter.values.RealValue;
import org.intocps.maestro.interpreter.values.StringValue;
import org.intocps.maestro.interpreter.values.UnsignedIntegerValue;
import org.intocps.maestro.interpreter.values.UpdatableValue;
import org.intocps.maestro.interpreter.values.Value;
import org.intocps.maestro.interpreter.values.VoidValue;
import org.intocps.maestro.interpreter.values.fmi.FmuComponentStateValue;
import org.intocps.maestro.interpreter.values.fmi.FmuComponentValue;
import org.intocps.maestro.interpreter.values.fmi.FmuValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class Fmi2Interpreter {
    static final Logger logger = LoggerFactory.getLogger(Interpreter.class);
    private final File workingDirectory;

    public Fmi2Interpreter(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public static boolean getBool(Value value) {
        if ((value = value.deref()) instanceof BooleanValue) {
            return ((BooleanValue)value).getValue();
        }
        throw new InterpreterException("Value is not boolean");
    }

    public static double getDouble(Value value) {
        if ((value = value.deref()) instanceof RealValue) {
            return ((RealValue)value).getValue();
        }
        throw new InterpreterException("Value is not double");
    }

    public static long getUint(Value value) {
        if ((value = value.deref()) instanceof UnsignedIntegerValue) {
            return ((UnsignedIntegerValue)value).getValue();
        }
        if (value instanceof IntegerValue) {
            return ((IntegerValue)value).getValue();
        }
        throw new InterpreterException("Value is not unsigned integer");
    }

    public static String getString(Value value) {
        if ((value = value.deref()) instanceof StringValue) {
            return ((StringValue)value).getValue();
        }
        throw new InterpreterException("Value is not string");
    }

    static void checkArgLength(List<Value> values, int size) {
        if (values == null) {
            throw new InterpreterException("No values passed");
        }
        if (values.stream().anyMatch(Objects::isNull)) {
            throw new InterpreterException("Argument list contains null values");
        }
        if (values.size() != size) {
            if (values.size() < size) {
                throw new InterpreterException("Too few arguments");
            }
            throw new InterpreterException("Too many arguments");
        }
    }

    static <T extends Value> List<T> getArrayValue(Value value, Class<T> clz) {
        return Fmi2Interpreter.getArrayValue(value, Optional.empty(), clz);
    }

    static <T extends Value> List<T> getArrayValue(Value value, Optional<Long> limit, Class<T> clz) {
        if ((value = value.deref()) instanceof ArrayValue) {
            ArrayValue array = (ArrayValue)value;
            if (((ArrayValue)value).getValues().isEmpty()) {
                return Collections.emptyList();
            }
            if (!clz.isAssignableFrom(((Value)array.getValues().get(0)).deref().getClass())) {
                throw new InterpreterException("Array not containing the right type. Expected: " + clz.getSimpleName() + " Actual: " + ((Value)array.getValues().get(0)).getClass().getSimpleName());
            }
            if (limit.isPresent()) {
                return array.getValues().stream().limit(limit.get()).map(Value::deref).map(clz::cast).collect(Collectors.toList());
            }
            return array.getValues().stream().map(Value::deref).map(clz::cast).collect(Collectors.toList());
        }
        throw new InterpreterException("Value is not an array");
    }

    public static FmuComponentValue getFmuComponentValue(BufferedOutputStream fmuLogOutputStream, IFmiComponent component) {
        HashMap<String, Value> componentMembers = new HashMap<String, Value>();
        componentMembers.put("setDebugLogging", new FunctionValue.ExternalFunctionValue(fcargs -> {
            Fmi2Interpreter.checkArgLength(fcargs, 3);
            boolean debugLogginOn = Fmi2Interpreter.getBool((Value)fcargs.get(0));
            List<StringValue> categories = Fmi2Interpreter.getArrayValue((Value)fcargs.get(2), StringValue.class);
            try {
                Fmi2Status res = component.setDebugLogging(debugLogginOn, (String[])categories.stream().map(StringValue::getValue).toArray(String[]::new));
                return new IntegerValue(res.value);
            }
            catch (FmuInvocationException e) {
                throw new InterpreterException(e);
            }
        }));
        componentMembers.put("setupExperiment", new FunctionValue.ExternalFunctionValue(fcargs -> {
            Fmi2Interpreter.checkArgLength(fcargs, 5);
            boolean toleranceDefined = Fmi2Interpreter.getBool((Value)fcargs.get(0));
            double tolerance = Fmi2Interpreter.getDouble((Value)fcargs.get(1));
            double startTime = Fmi2Interpreter.getDouble((Value)fcargs.get(2));
            boolean stopTimeDefined = Fmi2Interpreter.getBool((Value)fcargs.get(3));
            double stopTime = Fmi2Interpreter.getDouble((Value)fcargs.get(4));
            try {
                Fmi2Status res = component.setupExperiment(toleranceDefined, tolerance, startTime, stopTimeDefined, stopTime);
                return new IntegerValue(res.value);
            }
            catch (FmuInvocationException e) {
                throw new InterpreterException(e);
            }
        }));
        componentMembers.put("enterInitializationMode", new FunctionValue.ExternalFunctionValue(fcargs -> {
            Fmi2Interpreter.checkArgLength(fcargs, 0);
            try {
                Fmi2Status res = component.enterInitializationMode();
                return new IntegerValue(res.value);
            }
            catch (FmuInvocationException e) {
                throw new InterpreterException(e);
            }
        }));
        componentMembers.put("exitInitializationMode", new FunctionValue.ExternalFunctionValue(fcargs -> {
            Fmi2Interpreter.checkArgLength(fcargs, 0);
            try {
                Fmi2Status res = component.exitInitializationMode();
                return new IntegerValue(res.value);
            }
            catch (FmuInvocationException e) {
                throw new InterpreterException(e);
            }
        }));
        componentMembers.put("setReal", new FunctionValue.ExternalFunctionValue(fcargs -> {
            Fmi2Interpreter.checkArgLength(fcargs, 3);
            long elementsToUse = Fmi2Interpreter.getUint((Value)fcargs.get(1));
            long[] scalarValueIndices = Fmi2Interpreter.getArrayValue((Value)fcargs.get(0), Optional.of(elementsToUse), NumericValue.class).stream().mapToLong(NumericValue::longValue).toArray();
            double[] values = Fmi2Interpreter.getArrayValue((Value)fcargs.get(2), Optional.of(elementsToUse), NumericValue.class).stream().limit(elementsToUse).mapToDouble(NumericValue::realValue).toArray();
            try {
                Fmi2Status res = component.setReals(scalarValueIndices, values);
                return new IntegerValue(res.value);
            }
            catch (FmiInvalidNativeStateException | InvalidParameterException e) {
                throw new InterpreterException(e);
            }
        }));
        componentMembers.put("getReal", new FunctionValue.ExternalFunctionValue(fcargs -> {
            Fmi2Interpreter.checkArgLength(fcargs, 3);
            if (!(fcargs.get(2) instanceof UpdatableValue)) {
                throw new InterpreterException("value not a reference value");
            }
            long elementsToUse = Fmi2Interpreter.getUint((Value)fcargs.get(1));
            long[] scalarValueIndices = Fmi2Interpreter.getArrayValue((Value)fcargs.get(0), Optional.of(elementsToUse), NumericValue.class).stream().mapToLong(NumericValue::longValue).toArray();
            try {
                FmuResult res = component.getReal(scalarValueIndices);
                if (res.status == Fmi2Status.OK) {
                    UpdatableValue ref = (UpdatableValue)fcargs.get(2);
                    List values = Arrays.stream(ArrayUtils.toObject((double[])((double[])res.result))).limit(elementsToUse).map(d -> new RealValue((double)d)).collect(Collectors.toList());
                    ref.setValue(new ArrayValue(values));
                }
                return new IntegerValue(res.status.value);
            }
            catch (FmuInvocationException e) {
                throw new InterpreterException(e);
            }
        }));
        componentMembers.put("setInteger", new FunctionValue.ExternalFunctionValue(fcargs -> {
            Fmi2Interpreter.checkArgLength(fcargs, 3);
            long elementsToUse = Fmi2Interpreter.getUint((Value)fcargs.get(1));
            long[] scalarValueIndices = Fmi2Interpreter.getArrayValue((Value)fcargs.get(0), Optional.of(elementsToUse), NumericValue.class).stream().mapToLong(NumericValue::longValue).toArray();
            int[] values = Fmi2Interpreter.getArrayValue((Value)fcargs.get(2), Optional.of(elementsToUse), IntegerValue.class).stream().mapToInt(IntegerValue::getValue).toArray();
            try {
                Fmi2Status res = component.setIntegers(scalarValueIndices, values);
                return new IntegerValue(res.value);
            }
            catch (FmiInvalidNativeStateException | InvalidParameterException e) {
                throw new InterpreterException(e);
            }
        }));
        componentMembers.put("getInteger", new FunctionValue.ExternalFunctionValue(fcargs -> {
            Fmi2Interpreter.checkArgLength(fcargs, 3);
            long elementsToUse = Fmi2Interpreter.getUint((Value)fcargs.get(1));
            if (!(fcargs.get(2) instanceof UpdatableValue)) {
                throw new InterpreterException("value not a reference value");
            }
            long[] scalarValueIndices = Fmi2Interpreter.getArrayValue((Value)fcargs.get(0), Optional.of(elementsToUse), NumericValue.class).stream().mapToLong(NumericValue::longValue).toArray();
            try {
                FmuResult res = component.getInteger(scalarValueIndices);
                if (res.status == Fmi2Status.OK) {
                    UpdatableValue ref = (UpdatableValue)fcargs.get(2);
                    List values = Arrays.stream(ArrayUtils.toObject((int[])((int[])res.result))).limit(elementsToUse).map(i -> new IntegerValue((int)i)).collect(Collectors.toList());
                    ref.setValue(new ArrayValue(values));
                }
                return new IntegerValue(res.status.value);
            }
            catch (FmuInvocationException e) {
                throw new InterpreterException(e);
            }
        }));
        componentMembers.put("setBoolean", new FunctionValue.ExternalFunctionValue(fcargs -> {
            Fmi2Interpreter.checkArgLength(fcargs, 3);
            long elementsToUse = Fmi2Interpreter.getUint((Value)fcargs.get(1));
            long[] scalarValueIndices = Fmi2Interpreter.getArrayValue((Value)fcargs.get(0), Optional.of(elementsToUse), NumericValue.class).stream().mapToLong(NumericValue::longValue).toArray();
            boolean[] values = ArrayUtils.toPrimitive((Boolean[])Fmi2Interpreter.getArrayValue((Value)fcargs.get(2), Optional.of(elementsToUse), BooleanValue.class).stream().map(BooleanValue::getValue).collect(Collectors.toList()).toArray(new Boolean[0]));
            try {
                Fmi2Status res = component.setBooleans(scalarValueIndices, values);
                return new IntegerValue(res.value);
            }
            catch (FmiInvalidNativeStateException | InvalidParameterException e) {
                throw new InterpreterException(e);
            }
        }));
        componentMembers.put("getBoolean", new FunctionValue.ExternalFunctionValue(fcargs -> {
            Fmi2Interpreter.checkArgLength(fcargs, 3);
            if (!(fcargs.get(2) instanceof UpdatableValue)) {
                throw new InterpreterException("value not a reference value");
            }
            long elementsToUse = Fmi2Interpreter.getUint((Value)fcargs.get(1));
            long[] scalarValueIndices = Fmi2Interpreter.getArrayValue((Value)fcargs.get(0), Optional.of(elementsToUse), NumericValue.class).stream().mapToLong(NumericValue::longValue).toArray();
            try {
                FmuResult res = component.getBooleans(scalarValueIndices);
                if (res.status == Fmi2Status.OK) {
                    UpdatableValue ref = (UpdatableValue)fcargs.get(2);
                    List values = Arrays.stream(ArrayUtils.toObject((boolean[])((boolean[])res.result))).limit(elementsToUse).map(BooleanValue::new).collect(Collectors.toList());
                    ref.setValue(new ArrayValue(values));
                }
                return new IntegerValue(res.status.value);
            }
            catch (FmuInvocationException e) {
                throw new InterpreterException(e);
            }
        }));
        componentMembers.put("setString", new FunctionValue.ExternalFunctionValue(fcargs -> {
            Fmi2Interpreter.checkArgLength(fcargs, 3);
            long elementsToUse = Fmi2Interpreter.getUint((Value)fcargs.get(1));
            long[] scalarValueIndices = Fmi2Interpreter.getArrayValue((Value)fcargs.get(0), Optional.of(elementsToUse), NumericValue.class).stream().mapToLong(NumericValue::longValue).toArray();
            String[] values = Fmi2Interpreter.getArrayValue((Value)fcargs.get(2), Optional.of(elementsToUse), StringValue.class).stream().map(StringValue::getValue).collect(Collectors.toList()).toArray(new String[0]);
            try {
                Fmi2Status res = component.setStrings(scalarValueIndices, values);
                return new IntegerValue(res.value);
            }
            catch (FmiInvalidNativeStateException | InvalidParameterException e) {
                throw new InterpreterException(e);
            }
        }));
        componentMembers.put("getString", new FunctionValue.ExternalFunctionValue(fcargs -> {
            Fmi2Interpreter.checkArgLength(fcargs, 3);
            if (!(fcargs.get(2) instanceof UpdatableValue)) {
                throw new InterpreterException("value not a reference value");
            }
            long elementsToUse = Fmi2Interpreter.getUint((Value)fcargs.get(1));
            long[] scalarValueIndices = Fmi2Interpreter.getArrayValue((Value)fcargs.get(0), Optional.of(elementsToUse), NumericValue.class).stream().mapToLong(NumericValue::longValue).toArray();
            try {
                FmuResult res = component.getStrings(scalarValueIndices);
                if (res.status == Fmi2Status.OK) {
                    UpdatableValue ref = (UpdatableValue)fcargs.get(2);
                    List values = Arrays.stream((String[])res.result).limit(elementsToUse).map(StringValue::new).collect(Collectors.toList());
                    ref.setValue(new ArrayValue(values));
                }
                return new IntegerValue(res.status.value);
            }
            catch (FmuInvocationException e) {
                throw new InterpreterException(e);
            }
        }));
        componentMembers.put("doStep", new FunctionValue.ExternalFunctionValue(fcargs -> {
            Fmi2Interpreter.checkArgLength(fcargs, 3);
            double currentCommunicationPoint = Fmi2Interpreter.getDouble((Value)fcargs.get(0));
            double communicationStepSize = Fmi2Interpreter.getDouble((Value)fcargs.get(1));
            boolean noSetFMUStatePriorToCurrentPoint = Fmi2Interpreter.getBool((Value)fcargs.get(2));
            try {
                Fmi2Status res = component.doStep(currentCommunicationPoint, communicationStepSize, noSetFMUStatePriorToCurrentPoint);
                return new IntegerValue(res.value);
            }
            catch (FmuInvocationException e) {
                throw new InterpreterException(e);
            }
        }));
        componentMembers.put("terminate", new FunctionValue.ExternalFunctionValue(fcargs -> {
            Fmi2Interpreter.checkArgLength(fcargs, 0);
            try {
                Fmi2Status res = component.terminate();
                return new IntegerValue(res.value);
            }
            catch (FmuInvocationException e) {
                throw new InterpreterException(e);
            }
        }));
        componentMembers.put("setState", new FunctionValue.ExternalFunctionValue(fcargs -> {
            Fmi2Interpreter.checkArgLength(fcargs, 1);
            Value v = ((Value)fcargs.get(0)).deref();
            if (v instanceof FmuComponentStateValue) {
                try {
                    FmuComponentStateValue stateValue = (FmuComponentStateValue)v;
                    Fmi2Status res = component.setState((IFmiComponentState)stateValue.getModule());
                    return new IntegerValue(res.value);
                }
                catch (FmuInvocationException e) {
                    throw new InterpreterException(e);
                }
            }
            throw new InterpreterException("Invalid value");
        }));
        componentMembers.put("getState", new FunctionValue.ExternalFunctionValue(fcargs -> {
            Fmi2Interpreter.checkArgLength(fcargs, 1);
            if (!(fcargs.get(0) instanceof UpdatableValue)) {
                throw new InterpreterException("value not a reference value");
            }
            try {
                FmuResult res = component.getState();
                if (res.status == Fmi2Status.OK) {
                    UpdatableValue ref = (UpdatableValue)fcargs.get(0);
                    ref.setValue(new FmuComponentStateValue((IFmiComponentState)res.result));
                }
                return new IntegerValue(res.status.value);
            }
            catch (FmuInvocationException e) {
                throw new InterpreterException(e);
            }
        }));
        componentMembers.put("freeState", new FunctionValue.ExternalFunctionValue(fcargs -> {
            Fmi2Interpreter.checkArgLength(fcargs, 1);
            Value v = ((Value)fcargs.get(0)).deref();
            if (v instanceof FmuComponentStateValue) {
                try {
                    FmuComponentStateValue stateValue = (FmuComponentStateValue)v;
                    Fmi2Status res = component.freeState((IFmiComponentState)stateValue.getModule());
                    return new IntegerValue(res.value);
                }
                catch (FmuInvocationException e) {
                    throw new InterpreterException(e);
                }
            }
            throw new InterpreterException("Invalid value");
        }));
        componentMembers.put("getRealStatus", new FunctionValue.ExternalFunctionValue(fcargs -> {
            Fmi2Interpreter.checkArgLength(fcargs, 2);
            if (!(fcargs.get(1) instanceof UpdatableValue)) {
                throw new InterpreterException("value not a reference value");
            }
            Value kindValue = ((Value)fcargs.get(0)).deref();
            if (!(kindValue instanceof IntegerValue)) {
                throw new InterpreterException("Invalid kind value: " + kindValue);
            }
            int kind = ((IntegerValue)kindValue).getValue();
            Fmi2StatusKind kindEnum = Arrays.stream(Fmi2StatusKind.values()).filter(v -> v.value == kind).findFirst().orElse(null);
            try {
                FmuResult res = component.getRealStatus(kindEnum);
                if (res.status == Fmi2Status.OK) {
                    UpdatableValue ref = (UpdatableValue)fcargs.get(1);
                    ref.setValue(new RealValue((Double)res.result));
                }
                return new IntegerValue(res.status.value);
            }
            catch (FmuInvocationException e) {
                throw new InterpreterException(e);
            }
        }));
        componentMembers.put("getRealOutputDerivatives", new FunctionValue.ExternalFunctionValue(fcargs -> {
            Fmi2Interpreter.checkArgLength(fcargs, 4);
            if (!(fcargs.get(3) instanceof UpdatableValue)) {
                throw new InterpreterException("value not a reference value");
            }
            long elementsToUse = Fmi2Interpreter.getUint((Value)fcargs.get(1));
            long[] scalarValueIndices = Fmi2Interpreter.getArrayValue((Value)fcargs.get(0), Optional.of(elementsToUse), NumericValue.class).stream().mapToLong(NumericValue::longValue).toArray();
            int[] orders = Fmi2Interpreter.getArrayValue((Value)fcargs.get(2), Optional.of(elementsToUse), NumericValue.class).stream().mapToInt(NumericValue::intValue).toArray();
            try {
                FmuResult res = component.getRealOutputDerivatives(scalarValueIndices, orders);
                if (res.status == Fmi2Status.OK) {
                    UpdatableValue ref = (UpdatableValue)fcargs.get(3);
                    List values = Arrays.stream(ArrayUtils.toObject((double[])((double[])res.result))).limit(elementsToUse).map(d -> new RealValue((double)d)).collect(Collectors.toList());
                    ref.setValue(new ArrayValue(values));
                }
                return new IntegerValue(res.status.value);
            }
            catch (FmuInvocationException e) {
                throw new InterpreterException(e);
            }
        }));
        componentMembers.put("setRealInputDerivatives", new FunctionValue.ExternalFunctionValue(fcargs -> {
            Fmi2Interpreter.checkArgLength(fcargs, 4);
            long elementsToUse = Fmi2Interpreter.getUint((Value)fcargs.get(1));
            long[] scalarValueIndices = Fmi2Interpreter.getArrayValue((Value)fcargs.get(0), Optional.of(elementsToUse), NumericValue.class).stream().mapToLong(NumericValue::longValue).toArray();
            int[] orders = Fmi2Interpreter.getArrayValue((Value)fcargs.get(2), Optional.of(elementsToUse), NumericValue.class).stream().mapToInt(NumericValue::intValue).toArray();
            double[] values = Fmi2Interpreter.getArrayValue((Value)fcargs.get(3), Optional.of(elementsToUse), RealValue.class).stream().mapToDouble(RealValue::getValue).toArray();
            try {
                Fmi2Status res = component.setRealInputDerivatives(scalarValueIndices, orders, values);
                return new IntegerValue(res.value);
            }
            catch (FmuInvocationException e) {
                throw new InterpreterException(e);
            }
        }));
        return new FmuComponentValue(componentMembers, component, fmuLogOutputStream);
    }

    public static Map<String, Value> createFmuMembers(File workingDirectory, String guid, IFmu fmu) {
        HashMap<String, Value> functions = new HashMap<String, Value>();
        functions.put("instantiate", new FunctionValue.ExternalFunctionValue(fargs -> {
            Fmi2Interpreter.checkArgLength(fargs, 3);
            String name = Fmi2Interpreter.getString((Value)fargs.get(0));
            boolean visible = Fmi2Interpreter.getBool((Value)fargs.get(1));
            boolean logginOn = Fmi2Interpreter.getBool((Value)fargs.get(2));
            try {
                long startInstantiateTime = System.nanoTime();
                logger.debug(String.format("Loading native FMU. GUID: %s, NAME: %s", guid, name));
                final BufferedOutputStream fmuLogOutputStream = workingDirectory == null ? null : new BufferedOutputStream(new FileOutputStream(new File(workingDirectory, name + ".log")));
                final String formatter = "{} {} {} {}";
                String pattern = "%d{ISO8601} %-5p - %m%n";
                PatternLayout layout = PatternLayout.newBuilder().withPattern(pattern).withCharset(StandardCharsets.UTF_8).build();
                IFmiComponent component = fmu.instantiate(guid, name, visible, logginOn, new IFmuCallback((Layout)layout){
                    final /* synthetic */ Layout val$layout;
                    {
                        this.val$layout = layout;
                    }

                    public void log(String instanceName, Fmi2Status status, String category, String message) {
                        logger.info("NATIVE: instance: '{}', status: '{}', category: '{}', message: {}", new Object[]{instanceName, status, category, message});
                        if (fmuLogOutputStream == null) {
                            return;
                        }
                        Log4jLogEvent.Builder builder = Log4jLogEvent.newBuilder().setMessage((Message)new ParameterizedMessage(formatter, new Object[]{category, status, instanceName, message}));
                        switch (status) {
                            case OK: 
                            case Discard: 
                            case Pending: {
                                builder.setLevel(Level.INFO);
                                break;
                            }
                            case Error: 
                            case Fatal: {
                                builder.setLevel(Level.ERROR);
                            }
                            case Warning: {
                                builder.setLevel(Level.WARN);
                                break;
                            }
                            default: {
                                builder.setLevel(Level.TRACE);
                            }
                        }
                        try {
                            Log4jLogEvent event = builder.build();
                            fmuLogOutputStream.write(this.val$layout.toByteArray((LogEvent)event));
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }

                    public void stepFinished(Fmi2Status status) {
                    }
                });
                if (component == null) {
                    logger.debug("Component instantiate failed");
                    return new NullValue();
                }
                long stopInstantiateTime = System.nanoTime();
                System.out.println("Interpretation instantiate took: " + (stopInstantiateTime - startInstantiateTime));
                return Fmi2Interpreter.getFmuComponentValue(fmuLogOutputStream, component);
            }
            catch (IOException | XPathExpressionException | FmiInvalidNativeStateException e) {
                e.printStackTrace();
                return null;
            }
        }));
        functions.put("freeInstance", new FunctionValue.ExternalFunctionValue(fargs -> {
            fargs = fargs.stream().map(Value::deref).collect(Collectors.toList());
            logger.debug("freeInstance");
            if (fargs.size() != 1) {
                throw new InterpreterException("Too few arguments");
            }
            if (!(fargs.get(0) instanceof FmuComponentValue)) {
                throw new InterpreterException("Argument must be an external module reference");
            }
            FmuComponentValue component = (FmuComponentValue)fargs.get(0);
            try {
                OutputStream loggerOutputStream = component.getFmuLoggerOutputStream();
                if (loggerOutputStream != null) {
                    loggerOutputStream.close();
                }
                ((IFmiComponent)component.getModule()).freeInstance();
            }
            catch (IOException | FmuInvocationException e) {
                e.printStackTrace();
            }
            return new VoidValue();
        }));
        functions.put("unload", new FunctionValue.ExternalFunctionValue(fargs -> {
            fargs = fargs.stream().map(Value::deref).collect(Collectors.toList());
            logger.debug("unload");
            if (fargs.size() != 0) {
                throw new InterpreterException("Too many arguments");
            }
            try {
                fmu.unLoad();
            }
            catch (FmuInvocationException e) {
                e.printStackTrace();
            }
            return new VoidValue();
        }));
        return functions;
    }

    public Value createFmiValue(String path, String guid) throws InterpreterException {
        try {
            long startExecTime = System.nanoTime();
            IFmu fmu = FmuFactory.create(null, (URI)URI.create(path));
            fmu.load();
            Map<String, Value> functions = Fmi2Interpreter.createFmuMembers(this.workingDirectory, guid, fmu);
            long stopTime = System.nanoTime();
            System.out.println("Interpretation load took: " + (stopTime - startExecTime));
            return new FmuValue(functions, fmu);
        }
        catch (IOException | FmuInvocationException | FmuMissingLibraryException e) {
            e.printStackTrace();
            return new NullValue();
        }
        catch (Exception e) {
            e.printStackTrace();
            return new NullValue();
        }
    }

    public Value createFmiValue(Class<?> clz) {
        try {
            long startExecTime = System.nanoTime();
            IFmu fmu = (IFmu)clz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            fmu.load();
            Fmi2ModelDescription md = new Fmi2ModelDescription(fmu.getModelDescription());
            Map<String, Value> functions = Fmi2Interpreter.createFmuMembers(this.workingDirectory, md.getGuid(), fmu);
            long stopTime = System.nanoTime();
            System.out.println("Interpretation load took: " + (stopTime - startExecTime));
            return new FmuValue(functions, fmu);
        }
        catch (IOException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException | ParserConfigurationException | XPathExpressionException | FmuInvocationException | FmuMissingLibraryException | SAXException e) {
            e.printStackTrace();
            return new NullValue();
        }
    }
}

