/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.interpreter;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.intocps.maestro.ast.AVariableDeclaration;
import org.intocps.maestro.ast.LexIdentifier;
import org.intocps.maestro.ast.analysis.AnalysisException;
import org.intocps.maestro.ast.analysis.DepthFirstAnalysisAdaptor;
import org.intocps.maestro.ast.analysis.intf.IAnalysis;
import org.intocps.maestro.ast.analysis.intf.IQuestionAnswer;
import org.intocps.maestro.ast.node.ALocalVariableStm;
import org.intocps.maestro.ast.node.ARootDocument;
import org.intocps.maestro.ast.node.ASimulationSpecificationCompilationUnit;
import org.intocps.maestro.ast.node.AStringLiteralExp;
import org.intocps.maestro.ast.node.ATransferAsStm;
import org.intocps.maestro.ast.node.ATransferStm;
import org.intocps.maestro.ast.node.INode;
import org.intocps.maestro.ast.node.PStm;
import org.intocps.maestro.ast.node.PType;
import org.intocps.maestro.ast.node.SBlockStm;
import org.intocps.maestro.interpreter.Context;
import org.intocps.maestro.interpreter.ITransitionManager;
import org.intocps.maestro.interpreter.Interpreter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransitionManager
implements ITransitionManager {
    static final Logger logger = LoggerFactory.getLogger(TransitionManager.class);
    private final ITransitionManager.ISpecificationProvider specificationProvider;

    public TransitionManager(ITransitionManager.ISpecificationProvider specificationProvider) {
        this.specificationProvider = specificationProvider;
    }

    @Override
    public ITransitionManager.ITTransitionInfo getTransferInfo(ATransferStm node, Context ctxt, String transferToName) throws AnalysisException {
        ITransitionManager.ISpecificationProvider provider = this.getSpecificationProvider();
        if (provider != null) {
            logger.trace("Transfer look for specifications");
            Map<Path, ARootDocument> candidates = transferToName == null ? provider.get() : provider.get(transferToName);
            logger.trace("Transfer {} candidates found", (Object)candidates.size());
            for (final Map.Entry<Path, ARootDocument> candidate : candidates.entrySet()) {
                Map<String, PType> externals = this.extractExternals((INode)candidate.getValue());
                Context remappedContext = this.createRemappedTransferContext(ctxt, (INode)node);
                if (externals.keySet().stream().map(remappedContext::lookup).filter(Objects::nonNull).count() != (long)externals.size()) continue;
                logger.debug("Candidate {} selected. All externals are available: '{}'", (Object)candidate.getKey(), (Object)String.join((CharSequence)", ", externals.keySet()));
                final Context transferContext = new Context(null);
                externals.keySet().forEach(name -> transferContext.put(new LexIdentifier(name, null), remappedContext.lookup((String)name)));
                return new ITransitionManager.ITTransitionInfo(){

                    @Override
                    public String describe() {
                        return ((Path)candidate.getKey()).toString();
                    }

                    @Override
                    public Path workingDirectory() {
                        return ((Path)candidate.getKey()).getParent();
                    }

                    @Override
                    public Context getContext() {
                        return transferContext;
                    }

                    @Override
                    public ARootDocument getSpecification() {
                        return (ARootDocument)candidate.getValue();
                    }
                };
            }
        }
        return null;
    }

    Context createRemappedTransferContext(Context ctxt, INode current) throws AnalysisException {
        final HashMap<String, String> remapping = new HashMap<String, String>();
        ((ASimulationSpecificationCompilationUnit)current.getAncestor(ASimulationSpecificationCompilationUnit.class)).apply((IAnalysis)new DepthFirstAnalysisAdaptor(){

            public void caseATransferAsStm(ATransferAsStm node) {
                if (node.parent() instanceof SBlockStm) {
                    SBlockStm block = (SBlockStm)node.parent();
                    for (int i = 0; i < block.getBody().size(); ++i) {
                        PStm nextStm;
                        if (block.getBody().get(i) != node || i + 1 >= block.getBody().size() || !((nextStm = (PStm)block.getBody().get(i + 1)) instanceof ALocalVariableStm)) continue;
                        remapping.put(((ALocalVariableStm)nextStm).getDeclaration().getName().getText(), ((AStringLiteralExp)node.getNames().get(0)).getValue());
                    }
                }
            }
        });
        Context remappedContext = new Context(ctxt);
        remapping.forEach((source, remappedName) -> {
            logger.debug("Transfer remapping {} -> {}", source, remappedName);
            remappedContext.put(new LexIdentifier(remappedName, null), ctxt.lookup((String)source));
        });
        return remappedContext;
    }

    private Map<String, PType> extractExternals(INode candidate) throws AnalysisException {
        final HashMap<String, PType> externals = new HashMap<String, PType>();
        candidate.apply((IAnalysis)new DepthFirstAnalysisAdaptor(){

            public void caseAVariableDeclaration(AVariableDeclaration node) {
                if (node.getExternal() != null && node.getExternal().booleanValue()) {
                    externals.put(node.getName().getText(), node.getType());
                }
            }
        });
        return externals;
    }

    @Override
    public void transfer(Interpreter interpreter, ITransitionManager.ITTransitionInfo info) throws AnalysisException {
        logger.debug("##########################################################################");
        logger.debug("# Transferring into new specification: {}", (Object)info.describe());
        logger.debug("##########################################################################");
        this.getSpecificationProvider().remove(info.getSpecification());
        info.getSpecification().apply((IQuestionAnswer)interpreter, (Object)info.getContext());
    }

    @Override
    public ITransitionManager.ISpecificationProvider getSpecificationProvider() {
        return this.specificationProvider;
    }
}

