/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.interpreter.values;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.intocps.maestro.interpreter.InterpreterException;
import org.intocps.maestro.interpreter.values.BooleanValue;
import org.intocps.maestro.interpreter.values.FunctionValue;
import org.intocps.maestro.interpreter.values.IntegerValue;
import org.intocps.maestro.interpreter.values.ModuleValue;
import org.intocps.maestro.interpreter.values.RealValue;
import org.intocps.maestro.interpreter.values.StringValue;
import org.intocps.maestro.interpreter.values.UnsignedIntegerValue;
import org.intocps.maestro.interpreter.values.Value;
import org.intocps.maestro.interpreter.values.VoidValue;

public class ConsolePrinterValue
extends ModuleValue {
    public ConsolePrinterValue() {
        super(ConsolePrinterValue.createMembers());
    }

    private static Object[] getValues(List<Value> values) {
        return values.stream().map(Value::deref).map(v -> {
            if (v instanceof IntegerValue) {
                return Integer.valueOf(((IntegerValue)v).intValue());
            }
            if (v instanceof BooleanValue) {
                return ((BooleanValue)v).getValue();
            }
            if (v instanceof RealValue) {
                return Double.valueOf(((RealValue)v).getValue());
            }
            if (v instanceof StringValue) {
                return ((StringValue)v).getValue();
            }
            if (v instanceof UnsignedIntegerValue) {
                return Long.valueOf(((UnsignedIntegerValue)v).getValue());
            }
            return v.toString();
        }).toArray();
    }

    private static Map<String, Value> createMembers() {
        HashMap<String, Value> componentMembers = new HashMap<String, Value>();
        componentMembers.put("print", new FunctionValue.ExternalFunctionValue(fcargs -> {
            ConsolePrinterValue.checkArgs(fcargs);
            String formattedMsg = String.format(((StringValue)((Value)fcargs.get(0)).deref()).getValue(), ConsolePrinterValue.getValues(fcargs.stream().skip(1L).collect(Collectors.toList())));
            System.out.print(formattedMsg);
            return new VoidValue();
        }));
        componentMembers.put("println", new FunctionValue.ExternalFunctionValue(fcargs -> {
            ConsolePrinterValue.checkArgs(fcargs);
            String formattedMsg = String.format(((StringValue)((Value)fcargs.get(0)).deref()).getValue(), ConsolePrinterValue.getValues(fcargs.stream().skip(1L).collect(Collectors.toList())));
            System.out.println(formattedMsg);
            return new VoidValue();
        }));
        return componentMembers;
    }

    private static void checkArgs(List<Value> args) {
        if (args == null) {
            throw new InterpreterException("No values passed");
        }
        if (args.stream().anyMatch(Objects::isNull)) {
            throw new InterpreterException("Argument list contains null values");
        }
    }
}

