/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.interpreter.values.csv;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.Vector;
import java.util.stream.Collectors;
import org.intocps.maestro.interpreter.InterpreterException;
import org.intocps.maestro.interpreter.values.BooleanValue;
import org.intocps.maestro.interpreter.values.IntegerValue;
import org.intocps.maestro.interpreter.values.RealValue;
import org.intocps.maestro.interpreter.values.StringValue;
import org.intocps.maestro.interpreter.values.Value;
import org.intocps.maestro.interpreter.values.datawriter.DataFileRotater;
import org.intocps.maestro.interpreter.values.datawriter.IDataListener;

public class CsvDataWriter
implements IDataListener {
    final List<String> filter;
    private final DataFileRotater dataFileRotater;
    HashMap<UUID, CsvDataWriterInstance> instances = new HashMap();

    public CsvDataWriter(File outputFile, List<String> filter) {
        this.dataFileRotater = new DataFileRotater(outputFile);
        this.filter = filter;
    }

    @Override
    public void writeHeader(UUID uuid, List<String> headers) {
        CsvDataWriterInstance instance = new CsvDataWriterInstance();
        instance.headersOfInterest = this.filter == null ? headers : headers.stream().filter(this.filter::contains).collect(Collectors.toList());
        for (int i = 0; i < headers.size(); ++i) {
            String header = headers.get(i);
            if (this.filter != null && !instance.headersOfInterest.contains(header)) continue;
            instance.indicesOfInterest.add(i);
        }
        try {
            PrintWriter writer;
            instance.printWriter = writer = new PrintWriter(new FileOutputStream(this.dataFileRotater.getNextOutputFile()));
            this.instances.put(uuid, instance);
            instance.println("time," + String.join((CharSequence)",", instance.headersOfInterest));
        }
        catch (FileNotFoundException e) {
            throw new InterpreterException(e);
        }
    }

    @Override
    public void writeDataPoint(UUID uuid, double time, List<Value> dataPoint) {
        Vector<String> data = new Vector<String>();
        data.add(Double.toString(time));
        for (Integer i : this.instances.get((Object)uuid).indicesOfInterest) {
            Value d = dataPoint.get(i).deref();
            Object value = null;
            if (d instanceof IntegerValue) {
                value = ((IntegerValue)d).getValue();
            } else if (d instanceof RealValue) {
                value = ((RealValue)d).getValue();
            } else if (d instanceof BooleanValue) {
                value = ((BooleanValue)d).getValue();
            } else if (d instanceof StringValue) {
                value = ((StringValue)d).getValue();
            }
            data.add(value.toString());
        }
        CsvDataWriterInstance instance = this.instances.get(uuid);
        instance.println(String.join((CharSequence)",", data));
        instance.flush();
    }

    @Override
    public void close() {
        this.instances.forEach((id, instance) -> instance.close());
        this.instances.clear();
    }

    static class CsvDataWriterInstance {
        public final List<Integer> indicesOfInterest = new ArrayList<Integer>();
        public List<String> headersOfInterest;
        public PrintWriter printWriter;

        CsvDataWriterInstance() {
        }

        public void println(String data) {
            this.printWriter.println(data);
        }

        public void flush() {
            this.printWriter.flush();
        }

        public void close() {
            this.printWriter.flush();
            this.printWriter.close();
        }
    }
}

