/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.interpreter.values.utilities;

import org.intocps.maestro.interpreter.values.ArrayValue;
import org.intocps.maestro.interpreter.values.UpdatableValue;
import org.intocps.maestro.interpreter.values.Value;

public class ArrayUpdatableValue
extends UpdatableValue {
    private final ArrayValue<Value> owner;
    private final int index;

    public ArrayUpdatableValue(ArrayValue<Value> owner, int index) {
        super(owner);
        this.owner = owner;
        this.index = index;
    }

    @Override
    public void setValue(Value newValue) {
        if (this.index >= this.owner.getValues().size()) {
            throw new RuntimeException("Out of bounds for array");
        }
        if (this.owner.getValues().get(this.index).deref() instanceof ArrayValue) {
            throw new RuntimeException("Assigning array to nested array is not allowed.");
        }
        this.owner.getValues().set(this.index, newValue);
    }

    @Override
    public Value deref() {
        return this.owner.getValues().get(this.index).deref();
    }
}

