/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.interpreter.values;

import org.intocps.maestro.interpreter.InterpreterException;
import org.intocps.maestro.interpreter.values.IntegerValue;
import org.intocps.maestro.interpreter.values.NumericValue;
import org.intocps.maestro.interpreter.values.Value;

public class RealValue
extends NumericValue {
    final double value;

    public RealValue(double value) {
        this.value = value;
    }

    public double getValue() {
        return this.value;
    }

    public String toString() {
        return "RealValue{value=" + this.value + "}";
    }

    @Override
    public long longValue() {
        long rounded = Math.round(this.value);
        if ((double)rounded != this.value) {
            throw new InterpreterException("Value " + this.value + " is not an integer");
        }
        return rounded;
    }

    @Override
    public int intValue() {
        long rounded = Math.round(this.value);
        if ((double)rounded != this.value) {
            throw new InterpreterException("Value " + this.value + " is not an integer");
        }
        if (rounded <= Integer.MAX_VALUE && rounded >= Integer.MIN_VALUE) {
            return (int)rounded;
        }
        throw new InterpreterException("Cannot convert " + rounded + " to int");
    }

    @Override
    public double realValue() {
        return this.value;
    }

    @Override
    public int compareTo(Value value) {
        Value other = value.deref();
        if (other instanceof RealValue) {
            RealValue ro = (RealValue)other;
            return (int)Math.round(Math.signum(this.value - ro.getValue()));
        }
        if (other instanceof IntegerValue) {
            IntegerValue ro = (IntegerValue)other;
            return (int)Math.round(Math.signum(this.value - (double)ro.getValue()));
        }
        return super.compareTo(value);
    }
}

