/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.interpreter.values.variablestep.constraint.samplingrate;

import java.math.BigDecimal;

public class Sampling {
    private Integer base;
    private Integer rate;
    private Integer startTime;

    public Sampling(Integer base, Integer rate, Integer startTime) {
        this.base = base;
        this.rate = rate;
        this.startTime = startTime;
    }

    public Double calcTimeToNextSample(Double currentTime) {
        Double dStartTime = Math.pow(10.0, this.base.intValue()) * (double)this.startTime.intValue();
        Double dRate = Math.pow(10.0, this.base.intValue()) * (double)this.rate.intValue();
        if (currentTime < dStartTime) {
            return dStartTime - currentTime;
        }
        Double shiftedCurrentTime = Sampling.rmEpsError(currentTime - dStartTime);
        Double nNextSample = Math.floor(Sampling.rmEpsError(shiftedCurrentTime / dRate)) + 1.0;
        Double shiftedNextSampleTime = Sampling.rmEpsError(dRate * nNextSample);
        return Sampling.rmEpsError(shiftedNextSampleTime - shiftedCurrentTime);
    }

    static double rmEpsError(double value) {
        Integer epsExp = 14;
        BigDecimal b = new BigDecimal(value);
        return b.setScale((int)epsExp, 4).doubleValue();
    }
}

