/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.interpreter.values.variablestep.constraint.zerocrossing;

import java.util.Observable;
import java.util.Observer;
import org.intocps.maestro.interpreter.values.variablestep.CurrentSolutionPoint;
import org.intocps.maestro.interpreter.values.variablestep.InitializationMsgJson;
import org.intocps.maestro.interpreter.values.variablestep.StepsizeInterval;
import org.intocps.maestro.interpreter.values.variablestep.constraint.ConstraintHandler;
import org.intocps.maestro.interpreter.values.variablestep.constraint.zerocrossing.detection.ZerocrossingConstraintState;
import org.intocps.maestro.interpreter.values.variablestep.constraint.zerocrossing.detection.ZerocrossingDetector;
import org.intocps.maestro.interpreter.values.variablestep.constraint.zerocrossing.stepsize.DefaultZcStepsizeAdjustmentStrategy;
import org.intocps.maestro.interpreter.values.variablestep.constraint.zerocrossing.stepsize.ZcStepsizeAdjustmentStrategy;
import org.intocps.maestro.interpreter.values.variablestep.valuetracker.OptionalDifferenceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZerocrossingHandler
implements Observer,
ConstraintHandler {
    static final Logger logger = LoggerFactory.getLogger(ZerocrossingHandler.class);
    private final Double tol;
    private final String id;
    private final StepsizeInterval interval;
    private final ZerocrossingDetector detector;
    private final ZcStepsizeAdjustmentStrategy stepsizeAdjustmentStrategy;
    private ZerocrossingHandler previousState = null;
    private Double prevStepsize;
    private Double lastStepsizeLimitedByContinuousConstraint;
    private Double currentTime;
    private Double nextTime;

    public ZerocrossingHandler(ZerocrossingHandler zh) {
        this.tol = zh.tol;
        this.id = zh.id;
        this.prevStepsize = zh.prevStepsize;
        this.lastStepsizeLimitedByContinuousConstraint = zh.lastStepsizeLimitedByContinuousConstraint;
        this.currentTime = zh.currentTime;
        this.nextTime = zh.nextTime;
        this.interval = zh.interval;
        this.detector = zh.detector;
        this.stepsizeAdjustmentStrategy = zh.stepsizeAdjustmentStrategy;
    }

    public ZerocrossingHandler(Observable observable, InitializationMsgJson.Constraint constraint, StepsizeInterval interval, Double strongRelaxationFactor) {
        OptionalDifferenceTracker tracker = new OptionalDifferenceTracker(observable, constraint.getPorts(), constraint.getOrder());
        this.detector = new ZerocrossingDetector(tracker);
        this.tol = constraint.getAbsoluteTolerance();
        this.id = constraint.getId();
        this.interval = interval;
        observable.addObserver(this);
        this.stepsizeAdjustmentStrategy = new DefaultZcStepsizeAdjustmentStrategy(tracker, this.tol, interval, strongRelaxationFactor, constraint.getSafety());
    }

    @Override
    public void update(Observable obs, Object arg) {
        if (obs instanceof CurrentSolutionPoint) {
            CurrentSolutionPoint cs = (CurrentSolutionPoint)obs;
            CurrentSolutionPoint.Operation op = cs.getOperation();
            if (CurrentSolutionPoint.Operation.ADVANCE.equals((Object)op)) {
                this.previousState = new ZerocrossingHandler(this);
                this.prevStepsize = cs.getPrevStepsize();
                this.lastStepsizeLimitedByContinuousConstraint = cs.getLastStepsizeLimitedByContinuousConstraint();
                this.currentTime = cs.getCurrentTime();
                this.nextTime = null;
            }
            if (CurrentSolutionPoint.Operation.PEEK.equals((Object)op)) {
                this.nextTime = cs.getNextTime();
            }
            if (CurrentSolutionPoint.Operation.ROLLBACK.equals((Object)op)) {
                this.prevStepsize = this.previousState.prevStepsize;
                this.lastStepsizeLimitedByContinuousConstraint = this.previousState.lastStepsizeLimitedByContinuousConstraint;
                this.currentTime = this.previousState.currentTime;
                this.nextTime = this.previousState.nextTime;
                this.previousState = null;
            }
        }
    }

    @Override
    public Double getMaxStepSize() {
        return this.stepsizeAdjustmentStrategy.getStepsize(this.detector.getZerocrossingState(), this.lastStepsizeLimitedByContinuousConstraint);
    }

    @Override
    public Boolean wasStepValid() {
        this.detector.updateZeroCrossingState();
        if (ZerocrossingConstraintState.CROSSED.equals((Object)this.detector.getZerocrossingState())) {
            this.logZerocrossing();
            if (this.detector.hasZerocrossingViolatedTolerance(this.tol).booleanValue()) {
                this.logToleranceViolation();
                return false;
            }
        }
        return true;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getDecision() {
        return this.stepsizeAdjustmentStrategy.getDecision();
    }

    @Override
    public Boolean isRelaxingStrongly() {
        return this.stepsizeAdjustmentStrategy.isRelaxingStrongly();
    }

    private void logZerocrossing() {
        Double resolvedDistance = this.detector.getResolvedDistanceToZerocrossing();
        Object msg = "A zerocrossing of constraint \"";
        msg = (String)msg + this.id;
        msg = (String)msg + "\" occurred in the time interval [ ";
        msg = (String)msg + this.currentTime;
        msg = (String)msg + " ; ";
        msg = (String)msg + this.nextTime;
        msg = (String)msg + " ] and was hit with a distance of ";
        msg = (String)msg + resolvedDistance;
        logger.warn((String)msg);
    }

    private void logToleranceViolation() {
        Double peekStepsize = this.nextTime - this.currentTime;
        Boolean isStepsizeMinimal = peekStepsize.equals(this.interval.getMinimalStepsize());
        Double resolvedDistance = this.detector.getResolvedDistanceToZerocrossing();
        Object msg = "Absolute tolerance violated!\n";
        msg = (String)msg + "\t| A zerocrossing of constraint \"";
        msg = (String)msg + this.id;
        msg = (String)msg + "\"\n";
        msg = (String)msg + "\t| occurred in the time interval [ ";
        msg = (String)msg + this.currentTime;
        msg = (String)msg + " ; ";
        msg = (String)msg + this.nextTime;
        msg = (String)msg + " ]\n";
        msg = (String)msg + "\t| and could only be resolved with a distance of ";
        msg = (String)msg + resolvedDistance;
        msg = (String)msg + "\n\t| which is greather than the absolute tolerance of ";
        msg = (String)msg + this.tol;
        if (isStepsizeMinimal.booleanValue()) {
            msg = (String)msg + "\n\t| The stepsize equals the minimal stepsize of ";
            msg = (String)msg + this.interval.getMinimalStepsize();
            msg = (String)msg + " !";
            msg = (String)msg + "\n\t| Decrease the minimal stepsize or increase this constraint's tolerance";
        } else {
            msg = (String)msg + "\n\t| Increase the 'safety' parameter of this constraint for more conservatism";
        }
        logger.warn((String)msg);
    }
}

