/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.interpreter.values.csv;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.intocps.maestro.interpreter.InterpreterException;
import org.intocps.maestro.interpreter.values.ArrayValue;
import org.intocps.maestro.interpreter.values.BooleanValue;
import org.intocps.maestro.interpreter.values.ExternalModuleValue;
import org.intocps.maestro.interpreter.values.FunctionValue;
import org.intocps.maestro.interpreter.values.IntegerValue;
import org.intocps.maestro.interpreter.values.RealValue;
import org.intocps.maestro.interpreter.values.StringValue;
import org.intocps.maestro.interpreter.values.Value;
import org.intocps.maestro.interpreter.values.VoidValue;

public class CsvFileValue
extends ExternalModuleValue<PrintWriter> {
    public CsvFileValue(PrintWriter writer) {
        super(CsvFileValue.createCsvMembers(writer), writer);
    }

    public static <T extends Value> List<T> getArrayValue(Value value, Class<T> clz) {
        if ((value = value.deref()) instanceof ArrayValue) {
            ArrayValue array = (ArrayValue)value;
            if (((ArrayValue)value).getValues().isEmpty()) {
                return Collections.emptyList();
            }
            if (!clz.isAssignableFrom(array.getValues().get(0).getClass())) {
                throw new InterpreterException("Array not containing the right type");
            }
            return array.getValues();
        }
        throw new InterpreterException("Value is not an array");
    }

    public static String getString(Value value) {
        if ((value = value.deref()) instanceof StringValue) {
            return ((StringValue)value).getValue();
        }
        throw new InterpreterException("Value is not string");
    }

    public static double getDouble(Value value) {
        if ((value = value.deref()) instanceof RealValue) {
            return ((RealValue)value).getValue();
        }
        throw new InterpreterException("Value is not double");
    }

    private static Map<String, Value> createCsvMembers(PrintWriter writer) {
        HashMap<String, Value> componentMembers = new HashMap<String, Value>();
        componentMembers.put("writeHeader", new FunctionValue.ExternalFunctionValue(fcargs -> {
            CsvFileValue.checkArgLength(fcargs, 1);
            List<StringValue> headers = CsvFileValue.getArrayValue((Value)fcargs.get(0), StringValue.class);
            writer.println(Stream.concat(Stream.of("time"), headers.stream().map(StringValue::getValue)).collect(Collectors.joining(",")));
            return new VoidValue();
        }));
        componentMembers.put("writeRow", new FunctionValue.ExternalFunctionValue(fcargs -> {
            CsvFileValue.checkArgLength(fcargs, 2);
            double time = CsvFileValue.getDouble((Value)fcargs.get(0));
            ArrayValue arrayValue = (ArrayValue)((Value)fcargs.get(1)).deref();
            Vector<Serializable> data = new Vector<Serializable>();
            data.add(Double.valueOf(time));
            for (Value d : arrayValue.getValues()) {
                if (d instanceof IntegerValue) {
                    data.add(Integer.valueOf(((IntegerValue)d).intValue()));
                }
                if (d instanceof RealValue) {
                    data.add(Double.valueOf(((RealValue)d).realValue()));
                }
                if (!(d instanceof BooleanValue)) continue;
                data.add(((BooleanValue)d).getValue());
            }
            writer.println(data.stream().map(Object::toString).collect(Collectors.joining(",")));
            return new VoidValue();
        }));
        return componentMembers;
    }
}

