/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.interpreter;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.intocps.maestro.ast.node.ARootDocument;
import org.intocps.maestro.interpreter.ITransitionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectorySpecificationProvider
implements ITransitionManager.ISpecificationProvider {
    static final Logger logger = LoggerFactory.getLogger(DirectorySpecificationProvider.class);
    final File root;
    final Function<File, ARootDocument> parseAndCheck;
    final Map<Path, ARootDocument> candidates = new HashMap<Path, ARootDocument>();
    final Set<Path> removedCandidates = new HashSet<Path>();
    final PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher("glob:**/*.mabl");
    private final int checkFrequency;
    private final int minimumStepBeforeOffering;
    int offeringCounter = 0;
    long lastChecked;

    public DirectorySpecificationProvider(File root, Function<File, ARootDocument> parseAndCheck) {
        this(root, parseAndCheck, 10, 0);
    }

    public DirectorySpecificationProvider(File root, Function<File, ARootDocument> parseAndCheck, int checkFrequency, int minimumStepBeforeOffering) {
        this.root = root;
        this.parseAndCheck = parseAndCheck;
        this.checkFrequency = checkFrequency;
        this.minimumStepBeforeOffering = minimumStepBeforeOffering;
    }

    @Override
    public Map<Path, ARootDocument> get() {
        if (System.currentTimeMillis() - this.lastChecked > (long)this.checkFrequency * 1000L) {
            if (this.root != null && this.root.exists()) {
                try (Stream<Path> walker = Files.walk(this.root.toPath(), new FileVisitOption[0]);){
                    List specPaths = walker.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(this.pathMatcher::matches).collect(Collectors.toList());
                    for (Path path : specPaths) {
                        if (this.removedCandidates.contains(path) || this.candidates.containsKey(path)) continue;
                        try {
                            logger.debug("Processing path: {}", (Object)path);
                            ARootDocument spec = this.parseAndCheck.apply(path.toFile());
                            if (spec != null) {
                                logger.debug("Processing path: {}. Done spec found.", (Object)path);
                                this.candidates.put(path, spec);
                                continue;
                            }
                            logger.debug("Processing path: {}. Invalid spec path.", (Object)path);
                        }
                        catch (Exception e) {
                            logger.error("Failed to parse candidate: " + path, (Throwable)e);
                        }
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            this.lastChecked = System.currentTimeMillis();
        }
        if (!this.candidates.isEmpty()) {
            ++this.offeringCounter;
            if (this.minimumStepBeforeOffering > this.offeringCounter) {
                return new HashMap<Path, ARootDocument>();
            }
        }
        return this.candidates;
    }

    @Override
    public Map<Path, ARootDocument> get(String name) {
        return this.get();
    }

    @Override
    public void remove(ARootDocument specification) {
        this.candidates.entrySet().stream().filter(map -> ((ARootDocument)map.getValue()).equals((Object)specification)).map(Map.Entry::getKey).findFirst().ifPresent(key -> {
            this.candidates.remove(key);
            this.removedCandidates.add((Path)key);
            this.offeringCounter = 0;
        });
    }
}

