/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.interpreter;

import java.time.Duration;
import java.time.Instant;
import org.intocps.maestro.ast.analysis.AnalysisException;
import org.intocps.maestro.ast.analysis.intf.IQuestionAnswer;
import org.intocps.maestro.ast.node.ARootDocument;
import org.intocps.maestro.interpreter.Context;
import org.intocps.maestro.interpreter.DefaultExternalValueFactory;
import org.intocps.maestro.interpreter.ITransitionManager;
import org.intocps.maestro.interpreter.Interpreter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MableInterpreter {
    static final Logger logger = LoggerFactory.getLogger(MableInterpreter.class);
    final ITransitionManager transitionManager;
    private final DefaultExternalValueFactory loadFactory;

    public MableInterpreter(DefaultExternalValueFactory loadFactory) {
        this(loadFactory, null);
    }

    public MableInterpreter(DefaultExternalValueFactory loadFactory, ITransitionManager transitionManager) {
        this.loadFactory = loadFactory;
        this.transitionManager = transitionManager;
    }

    public void execute(ARootDocument document) throws AnalysisException {
        logger.info("Starting Mable Interpreter...");
        long startTime = System.nanoTime();
        Instant start = Instant.now();
        document.apply((IQuestionAnswer)new Interpreter(this.loadFactory, this.transitionManager), (Object)new Context(null));
        long stopTime = System.nanoTime();
        Instant end = Instant.now();
        System.out.println("Interpretation time: " + (stopTime - startTime) + " " + Duration.between(start, end));
    }
}

