/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.interpreter.values.modeltransition;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.intocps.maestro.interpreter.InterpreterTransitionException;
import org.intocps.maestro.interpreter.values.BooleanValue;
import org.intocps.maestro.interpreter.values.FunctionValue;
import org.intocps.maestro.interpreter.values.ModuleValue;
import org.intocps.maestro.interpreter.values.StringValue;
import org.intocps.maestro.interpreter.values.Value;
import org.intocps.maestro.interpreter.values.VoidValue;
import org.intocps.maestro.interpreter.values.modeltransition.ModelTransitionStore;

public class ModelTransitionValue
extends ModuleValue {
    public ModelTransitionValue(String transitionPath) {
        super(ModelTransitionValue.createMembers(ModelTransitionStore.getInstance(transitionPath)));
    }

    private static Map<String, Value> createMembers(ModelTransitionStore instance) {
        HashMap<String, Value> members = new HashMap<String, Value>();
        members.put("setValue", new FunctionValue.ExternalFunctionValue(fcargs -> {
            List<Value> args = fcargs.stream().map(Value::deref).collect(Collectors.toList());
            ModelTransitionValue.checkArgLength(args, 2);
            Value idVal = args.get(0);
            String id = ((StringValue)idVal).getValue();
            Value val = args.get(1);
            instance.put(id, val);
            return new VoidValue();
        }));
        members.put("getValue", new FunctionValue.ExternalFunctionValue(fcargs -> {
            List<Value> args = fcargs.stream().map(Value::deref).collect(Collectors.toList());
            ModelTransitionValue.checkArgLength(args, 1);
            Value idVal = args.get(0);
            String id = ((StringValue)idVal).getValue();
            return instance.get(id);
        }));
        members.put("doTransition", new FunctionValue.ExternalFunctionValue(fcargs -> {
            Path transitionFile = instance.getNextTransitionFile();
            instance.writeTransitionLog();
            instance.setNextTransitionFile();
            throw new InterpreterTransitionException(transitionFile.toFile());
        }));
        members.put("nextTransition", new FunctionValue.ExternalFunctionValue(fcargs -> {
            Path transitionFile = instance.getNextTransitionFile();
            return new BooleanValue(Files.exists(transitionFile, new LinkOption[0]));
        }));
        return members;
    }
}

