/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.interpreter.values.variablestep.valuetracker;

import java.util.List;
import java.util.Observable;
import org.intocps.maestro.framework.fmi2.ModelConnection;
import org.intocps.maestro.interpreter.values.variablestep.valuetracker.DoubleValueTracker;
import org.intocps.maestro.interpreter.values.variablestep.valuetracker.ValueTracker;

public class OptionalDifferenceTracker
implements ValueTracker {
    private ValueTracker value1 = null;
    private ValueTracker value2 = null;
    private Boolean isDefinedByDifference;

    public OptionalDifferenceTracker(Observable observable, List<ModelConnection.Variable> variables, Integer predictionOrder) {
        this.isDefinedByDifference = variables.size() == 2;
        this.value1 = new DoubleValueTracker(observable, variables.get(0), predictionOrder);
        if (this.isDefinedByDifference.booleanValue()) {
            this.value2 = new DoubleValueTracker(observable, variables.get(1), predictionOrder);
        }
    }

    public OptionalDifferenceTracker(Observable observable, ModelConnection.Variable variable, Integer predictionOrder) {
        this.value1 = new DoubleValueTracker(observable, variable, predictionOrder);
        this.isDefinedByDifference = false;
    }

    @Override
    public Double getNextValue() {
        return this.isDefinedByDifference != false ? this.value1.getNextValue() - this.value2.getNextValue() : this.value1.getNextValue();
    }

    @Override
    public Double getCurrentValue() {
        return this.isDefinedByDifference != false ? this.value1.getCurrentValue() - this.value2.getCurrentValue() : this.value1.getCurrentValue();
    }

    @Override
    public Double getPreviousValue() {
        if (this.value1.getPreviousValue() == null) {
            return null;
        }
        return this.isDefinedByDifference != false ? this.value1.getPreviousValue() - this.value2.getPreviousValue() : this.value1.getPreviousValue();
    }

    @Override
    public Double getPrevPrevValue() {
        if (this.value1.getPrevPrevValue() == null) {
            return null;
        }
        return this.isDefinedByDifference != false ? this.value1.getPrevPrevValue() - this.value2.getPrevPrevValue() : this.value1.getPrevPrevValue();
    }

    @Override
    public Double getFirstDerivative() {
        return this.isDefinedByDifference != false ? this.value1.getFirstDerivative() - this.value2.getFirstDerivative() : this.value1.getFirstDerivative();
    }

    @Override
    public Double getSecondDerivative() {
        return this.isDefinedByDifference != false ? this.value1.getSecondDerivative() - this.value2.getSecondDerivative() : this.value1.getSecondDerivative();
    }

    @Override
    public Double getExtrapolationErrorEstimate() {
        return this.isDefinedByDifference != false ? this.value1.getExtrapolationErrorEstimate() - this.value2.getExtrapolationErrorEstimate() : this.value1.getExtrapolationErrorEstimate();
    }

    @Override
    public Integer getPredictionOrder() {
        return this.value1.getPredictionOrder();
    }
}

