/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.interpreter;

import com.spencerwi.either.Either;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.intocps.maestro.ast.AModuleDeclaration;
import org.intocps.maestro.interpreter.IExternalValueFactory;
import org.intocps.maestro.interpreter.InterpreterException;
import org.intocps.maestro.interpreter.api.IValueLifecycleHandler;
import org.intocps.maestro.interpreter.extensions.ArrayUtilLifecycleHandler;
import org.intocps.maestro.interpreter.extensions.BooleanLogicLifecycleHandler;
import org.intocps.maestro.interpreter.extensions.CsvLifecycleHandler;
import org.intocps.maestro.interpreter.extensions.DataWriterLifecycleHandler;
import org.intocps.maestro.interpreter.extensions.Fmi2LifecycleHandler;
import org.intocps.maestro.interpreter.extensions.JavaClasspathLoaderLifecycleHandler;
import org.intocps.maestro.interpreter.extensions.LoggerLifecycleHandler;
import org.intocps.maestro.interpreter.extensions.MEnvLifecycleHandler;
import org.intocps.maestro.interpreter.extensions.MathLifecycleHandler;
import org.intocps.maestro.interpreter.extensions.ModelTransitionLifecycleHandler;
import org.intocps.maestro.interpreter.values.Value;
import org.intocps.maestro.interpreter.values.VoidValue;
import org.reflections.Reflections;
import org.reflections.scanners.SubTypesScanner;

public class DefaultExternalValueFactory
implements IExternalValueFactory {
    static final List<Class<? extends IValueLifecycleHandler>> defaultHandlers = Arrays.asList(LoggerLifecycleHandler.class, CsvLifecycleHandler.class, ArrayUtilLifecycleHandler.class, JavaClasspathLoaderLifecycleHandler.class, MathLifecycleHandler.class, Fmi2LifecycleHandler.class);
    private final File workingDirectory;
    private final ByteArrayOutputStream baos;
    private final Function<String, AModuleDeclaration> resolver;
    protected Map<String, IValueLifecycleHandler> lifecycleHandlers;
    protected Map<Value, IValueLifecycleHandler> values = new HashMap<Value, IValueLifecycleHandler>();

    public DefaultExternalValueFactory(File workingDirectory, Function<String, AModuleDeclaration> resolver, InputStream config) throws IOException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        this.workingDirectory = workingDirectory;
        this.resolver = resolver;
        this.lifecycleHandlers = new HashMap<String, IValueLifecycleHandler>();
        for (Class<? extends IValueLifecycleHandler> handler : defaultHandlers) {
            this.lifecycleHandlers.put(handler.getAnnotation(IValueLifecycleHandler.ValueLifecycle.class).name(), this.instantiateHandler(workingDirectory, handler));
        }
        this.baos = new ByteArrayOutputStream();
        if (config != null) {
            config.transferTo(this.baos);
        }
        this.lifecycleHandlers.put(DataWriterLifecycleHandler.class.getAnnotation(IValueLifecycleHandler.ValueLifecycle.class).name(), new DataWriterLifecycleHandler(workingDirectory, new ByteArrayInputStream(this.baos.toByteArray())));
        this.lifecycleHandlers.put(MEnvLifecycleHandler.class.getAnnotation(IValueLifecycleHandler.ValueLifecycle.class).name(), new MEnvLifecycleHandler(new ByteArrayInputStream(this.baos.toByteArray())));
        for (Class cls : new Class[]{Fmi2LifecycleHandler.class, LoggerLifecycleHandler.class, BooleanLogicLifecycleHandler.class, MathLifecycleHandler.class}) {
            this.lifecycleHandlers.put(cls.getAnnotation(IValueLifecycleHandler.ValueLifecycle.class).name(), this.instantiateHandler(workingDirectory, cls));
        }
        this.lifecycleHandlers.put(ModelTransitionLifecycleHandler.class.getAnnotation(IValueLifecycleHandler.ValueLifecycle.class).name(), new ModelTransitionLifecycleHandler());
    }

    public void addLifecycleHandler(Class<? extends IValueLifecycleHandler> handlerClass) throws InvocationTargetException, InstantiationException, IllegalAccessException, NoSuchMethodException {
        IValueLifecycleHandler value;
        IValueLifecycleHandler.ValueLifecycle annotation = handlerClass.getAnnotation(IValueLifecycleHandler.ValueLifecycle.class);
        if (annotation != null && (value = this.instantiateHandler(this.workingDirectory, handlerClass)) != null) {
            this.lifecycleHandlers.put(annotation.name(), value);
        }
    }

    public void addLifecycleHandler(IValueLifecycleHandler handler) {
        IValueLifecycleHandler.ValueLifecycle annotation = handler.getClass().getAnnotation(IValueLifecycleHandler.ValueLifecycle.class);
        if (annotation != null && handler != null) {
            this.lifecycleHandlers.put(annotation.name(), handler);
        }
    }

    private IValueLifecycleHandler instantiateHandler(File workingDirectory, Class<? extends IValueLifecycleHandler> handler) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        IValueLifecycleHandler value;
        try {
            value = handler.getDeclaredConstructor(File.class, Function.class).newInstance(workingDirectory, this.resolver);
        }
        catch (NoSuchMethodException e) {
            try {
                value = handler.getDeclaredConstructor(File.class).newInstance(workingDirectory);
            }
            catch (NoSuchMethodException e2) {
                try {
                    value = handler.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (NoSuchMethodException e3) {
                    return null;
                }
            }
        }
        return value;
    }

    @Override
    public boolean supports(String type) throws Exception {
        return this.lazyGet(type) != null;
    }

    private IValueLifecycleHandler lazyGet(String type) throws Exception {
        IValueLifecycleHandler known = this.lifecycleHandlers.get(type);
        if (known != null) {
            return known;
        }
        List<Class<IValueLifecycleHandler>> handlers = this.scanForLifecycleHandlers(IValueLifecycleHandler.class);
        for (Class handler : handlers.stream().filter(h -> !this.lifecycleHandlers.containsKey(h.getAnnotation(IValueLifecycleHandler.ValueLifecycle.class).name())).collect(Collectors.toList())) {
            IValueLifecycleHandler value = this.instantiateHandler(this.workingDirectory, handler);
            if (value == null) continue;
            this.lifecycleHandlers.putIfAbsent(handler.getAnnotation(IValueLifecycleHandler.ValueLifecycle.class).name(), value);
        }
        if (this.lifecycleHandlers.containsKey(type)) {
            return this.lifecycleHandlers.get(type);
        }
        return null;
    }

    private <T> List<Class<? extends T>> scanForLifecycleHandlers(Class<T> type) {
        Reflections reflections = new Reflections(new Object[]{"org.intocps.maestro", this.getClass().getClassLoader(), new SubTypesScanner()});
        Set subTypes = reflections.getSubTypesOf(type);
        Predicate<Class> containsAnnotation = clz -> clz.getAnnotation(IValueLifecycleHandler.ValueLifecycle.class) != null;
        return subTypes.stream().filter(containsAnnotation).collect(Collectors.toList());
    }

    @Override
    public Either<Exception, Value> create(String loaderName, List<Value> args) {
        IValueLifecycleHandler handler = null;
        try {
            handler = this.lazyGet(loaderName);
        }
        catch (Exception e) {
            return Either.left((Object)e);
        }
        if (handler == null) {
            throw new InterpreterException("Could not construct type: " + loaderName);
        }
        Either<Exception, Value> value = handler.instantiate(args);
        if (value.isRight()) {
            this.values.put((Value)value.getRight(), handler);
        }
        return value;
    }

    @Override
    public Value destroy(Value value) {
        IValueLifecycleHandler handler = this.values.get(value.deref());
        if (handler != null) {
            handler.destroy(value);
            this.values.remove(value);
            return new VoidValue();
        }
        throw new InterpreterException("UnLoad of unknown type: " + value);
    }

    @Override
    public IExternalValueFactory changeWorkingDirectory(Path newSuggestion, InputStream config) throws IOException, InvocationTargetException, NoSuchMethodException, IllegalAccessException, InstantiationException {
        return new DefaultExternalValueFactory(newSuggestion.toFile(), this.resolver, config == null ? new ByteArrayInputStream(this.baos.toByteArray()) : config);
    }
}

