/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.interpreter;

import com.spencerwi.either.Either;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Vector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.intocps.maestro.ast.AAndBinaryExp;
import org.intocps.maestro.ast.ABasicBlockStm;
import org.intocps.maestro.ast.AEqualBinaryExp;
import org.intocps.maestro.ast.AGreaterBinaryExp;
import org.intocps.maestro.ast.AGreaterEqualBinaryExp;
import org.intocps.maestro.ast.ALessBinaryExp;
import org.intocps.maestro.ast.ALessEqualBinaryExp;
import org.intocps.maestro.ast.AMinusBinaryExp;
import org.intocps.maestro.ast.AMinusUnaryExp;
import org.intocps.maestro.ast.AMultiplyBinaryExp;
import org.intocps.maestro.ast.ANotEqualBinaryExp;
import org.intocps.maestro.ast.ANotUnaryExp;
import org.intocps.maestro.ast.AOrBinaryExp;
import org.intocps.maestro.ast.AParallelBlockStm;
import org.intocps.maestro.ast.APlusBinaryExp;
import org.intocps.maestro.ast.AVariableDeclaration;
import org.intocps.maestro.ast.analysis.AnalysisException;
import org.intocps.maestro.ast.analysis.QuestionAnswerAdaptor;
import org.intocps.maestro.ast.analysis.intf.IQuestionAnswer;
import org.intocps.maestro.ast.node.AArrayIndexExp;
import org.intocps.maestro.ast.node.AArrayInitializer;
import org.intocps.maestro.ast.node.AArrayStateDesignator;
import org.intocps.maestro.ast.node.AAssigmentStm;
import org.intocps.maestro.ast.node.ABoolLiteralExp;
import org.intocps.maestro.ast.node.ABooleanPrimitiveType;
import org.intocps.maestro.ast.node.ABreakStm;
import org.intocps.maestro.ast.node.AByteNumericPrimitiveType;
import org.intocps.maestro.ast.node.ACallExp;
import org.intocps.maestro.ast.node.AErrorStm;
import org.intocps.maestro.ast.node.AExpInitializer;
import org.intocps.maestro.ast.node.AExpressionStm;
import org.intocps.maestro.ast.node.AFieldExp;
import org.intocps.maestro.ast.node.AFloatLiteralExp;
import org.intocps.maestro.ast.node.AFloatNumericPrimitiveType;
import org.intocps.maestro.ast.node.AFmuMappingStm;
import org.intocps.maestro.ast.node.AFunctionType;
import org.intocps.maestro.ast.node.AIdentifierExp;
import org.intocps.maestro.ast.node.AIdentifierStateDesignator;
import org.intocps.maestro.ast.node.AIfStm;
import org.intocps.maestro.ast.node.AInstanceMappingStm;
import org.intocps.maestro.ast.node.AIntLiteralExp;
import org.intocps.maestro.ast.node.AIntNumericPrimitiveType;
import org.intocps.maestro.ast.node.ALoadExp;
import org.intocps.maestro.ast.node.ALocalVariableStm;
import org.intocps.maestro.ast.node.ALongNumericPrimitiveType;
import org.intocps.maestro.ast.node.ANameType;
import org.intocps.maestro.ast.node.ANullExp;
import org.intocps.maestro.ast.node.AParExp;
import org.intocps.maestro.ast.node.ARealLiteralExp;
import org.intocps.maestro.ast.node.ARealNumericPrimitiveType;
import org.intocps.maestro.ast.node.ARefExp;
import org.intocps.maestro.ast.node.ARootDocument;
import org.intocps.maestro.ast.node.AShortNumericPrimitiveType;
import org.intocps.maestro.ast.node.ASimulationSpecificationCompilationUnit;
import org.intocps.maestro.ast.node.AStringLiteralExp;
import org.intocps.maestro.ast.node.AStringPrimitiveType;
import org.intocps.maestro.ast.node.ATransferAsStm;
import org.intocps.maestro.ast.node.ATransferStm;
import org.intocps.maestro.ast.node.ATryStm;
import org.intocps.maestro.ast.node.AUIntLiteralExp;
import org.intocps.maestro.ast.node.AUIntNumericPrimitiveType;
import org.intocps.maestro.ast.node.AUnloadExp;
import org.intocps.maestro.ast.node.AWhileStm;
import org.intocps.maestro.ast.node.INode;
import org.intocps.maestro.ast.node.PExp;
import org.intocps.maestro.ast.node.PStm;
import org.intocps.maestro.ast.node.PType;
import org.intocps.maestro.ast.node.SNumericPrimitiveType;
import org.intocps.maestro.interpreter.BreakException;
import org.intocps.maestro.interpreter.ByRefInterpreter;
import org.intocps.maestro.interpreter.Context;
import org.intocps.maestro.interpreter.ErrorException;
import org.intocps.maestro.interpreter.IExternalValueFactory;
import org.intocps.maestro.interpreter.ITransitionManager;
import org.intocps.maestro.interpreter.InterpreterException;
import org.intocps.maestro.interpreter.InterpreterTransitionException;
import org.intocps.maestro.interpreter.ModuleContext;
import org.intocps.maestro.interpreter.StopException;
import org.intocps.maestro.interpreter.values.ArrayValue;
import org.intocps.maestro.interpreter.values.BooleanValue;
import org.intocps.maestro.interpreter.values.ByteValue;
import org.intocps.maestro.interpreter.values.ExternalModuleValue;
import org.intocps.maestro.interpreter.values.FloatValue;
import org.intocps.maestro.interpreter.values.FunctionValue;
import org.intocps.maestro.interpreter.values.IntegerValue;
import org.intocps.maestro.interpreter.values.LongValue;
import org.intocps.maestro.interpreter.values.ModuleValue;
import org.intocps.maestro.interpreter.values.NullValue;
import org.intocps.maestro.interpreter.values.NumericValue;
import org.intocps.maestro.interpreter.values.RealValue;
import org.intocps.maestro.interpreter.values.ShortValue;
import org.intocps.maestro.interpreter.values.StringValue;
import org.intocps.maestro.interpreter.values.UndefinedValue;
import org.intocps.maestro.interpreter.values.UnsignedIntegerValue;
import org.intocps.maestro.interpreter.values.UpdatableValue;
import org.intocps.maestro.interpreter.values.Value;
import org.intocps.maestro.interpreter.values.VoidValue;
import org.intocps.maestro.interpreter.values.utilities.ArrayUpdatableValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Interpreter
extends QuestionAnswerAdaptor<Context, Value> {
    static final Logger logger = LoggerFactory.getLogger(Interpreter.class);
    static final Map<Class<? extends PType>, Class<? extends Value>> typeValueMappings = new HashMap<Class<? extends PType>, Class<? extends Value>>(){
        {
            this.put(AIntNumericPrimitiveType.class, IntegerValue.class);
            this.put(AByteNumericPrimitiveType.class, ByteValue.class);
            this.put(AShortNumericPrimitiveType.class, ShortValue.class);
            this.put(AUIntNumericPrimitiveType.class, UnsignedIntegerValue.class);
            this.put(ALongNumericPrimitiveType.class, LongValue.class);
            this.put(AFloatNumericPrimitiveType.class, FloatValue.class);
            this.put(ARealNumericPrimitiveType.class, RealValue.class);
            this.put(AStringPrimitiveType.class, StringValue.class);
            this.put(ABooleanPrimitiveType.class, BooleanValue.class);
            this.put(ANameType.class, ExternalModuleValue.class);
        }
    };
    private final IExternalValueFactory loadFactory;
    private final ITransitionManager transitionManager;

    public Interpreter(IExternalValueFactory loadFactory) {
        this(loadFactory, null);
    }

    public Interpreter(IExternalValueFactory loadFactory, ITransitionManager transitionManager) {
        this.loadFactory = loadFactory;
        this.transitionManager = transitionManager;
    }

    public IExternalValueFactory getLoadFactory() {
        return this.loadFactory;
    }

    List<Value> evaluate(List<? extends PExp> list, Context ctxt) throws AnalysisException {
        Vector<Value> values = new Vector<Value>();
        for (PExp pExp : list) {
            values.add((Value)pExp.apply((IQuestionAnswer)this, (Object)ctxt));
        }
        return values;
    }

    public Value caseARootDocument(ARootDocument node, Context question) throws AnalysisException {
        AnalysisException[] exception = new AnalysisException[]{null};
        Value result = node.getContent().stream().filter(f -> f instanceof ASimulationSpecificationCompilationUnit).findFirst().map(spec -> {
            try {
                return (Value)spec.apply((IQuestionAnswer)this, (Object)question);
            }
            catch (AnalysisException e) {
                exception[0] = e;
                return null;
            }
        }).orElse(null);
        if (result == null) {
            throw exception[0];
        }
        return result;
    }

    public Value caseASimulationSpecificationCompilationUnit(ASimulationSpecificationCompilationUnit node, Context question) throws AnalysisException {
        return (Value)node.getBody().apply((IQuestionAnswer)this, (Object)question);
    }

    public Value caseABasicBlockStm(ABasicBlockStm node, Context question) throws AnalysisException {
        Context ctxt = new Context(question);
        for (PStm stm : node.getBody()) {
            stm.apply((IQuestionAnswer)this, (Object)ctxt);
        }
        return new VoidValue();
    }

    public Value caseAParallelBlockStm(AParallelBlockStm node, Context question) throws AnalysisException {
        Context ctxt = new Context(question);
        Optional<Optional> errors = ((Stream)node.getBody().stream().parallel()).map(s -> {
            try {
                s.apply((IQuestionAnswer)this, (Object)ctxt);
            }
            catch (AnalysisException e) {
                return Optional.of(e);
            }
            return Optional.empty();
        }).findFirst();
        if (errors.isPresent() && errors.get().isPresent()) {
            throw (AnalysisException)((Object)errors.get().get());
        }
        return new VoidValue();
    }

    public Value caseAInstanceMappingStm(AInstanceMappingStm node, Context question) {
        return new VoidValue();
    }

    public Value caseAFmuMappingStm(AFmuMappingStm node, Context question) throws AnalysisException {
        return new VoidValue();
    }

    public Value caseALocalVariableStm(ALocalVariableStm node, Context question) throws AnalysisException {
        return (Value)node.getDeclaration().apply((IQuestionAnswer)this, (Object)question);
    }

    public Value caseALoadExp(ALoadExp node, Context question) throws AnalysisException {
        if (node.getArgs().size() < 1) {
            throw new AnalysisException("load contains too few arguments. At least a type is required");
        }
        List<Value> args = this.evaluate(node.getArgs(), question);
        String loaderName = ((StringValue)args.get(0)).getValue();
        try {
            if (this.loadFactory.supports(loaderName)) {
                Either<Exception, Value> valueE = this.loadFactory.create(loaderName, args.subList(1, args.size()));
                if (valueE.isLeft()) {
                    throw new AnalysisException((Throwable)valueE.getLeft());
                }
                return (Value)valueE.getRight();
            }
        }
        catch (Exception e) {
            throw new AnalysisException("Load failed", (Throwable)e);
        }
        throw new AnalysisException("Load of unknown type: " + loaderName);
    }

    public Value caseAUnloadExp(AUnloadExp node, Context question) throws AnalysisException {
        List args = this.evaluate(node.getArgs(), question).stream().map(Value::deref).collect(Collectors.toList());
        Value nameVal = (Value)args.get(0);
        return this.loadFactory.destroy(nameVal);
    }

    public Value caseAIdentifierStateDesignator(AIdentifierStateDesignator node, Context question) throws AnalysisException {
        return question.lookup(node.getName());
    }

    public Value caseAArrayStateDesignator(AArrayStateDesignator node, Context question) throws AnalysisException {
        Value arrayValue = (Value)node.getTarget().apply((IQuestionAnswer)this, (Object)question);
        if (!(arrayValue.deref() instanceof ArrayValue)) {
            throw new InterpreterException("Array designator is not an array: " + arrayValue);
        }
        ArrayValue array = (ArrayValue)arrayValue.deref();
        int index = ((NumericValue)((Value)node.getExp().apply((IQuestionAnswer)this, (Object)question)).deref()).intValue();
        return new ArrayUpdatableValue(array, index);
    }

    public Value caseAAssigmentStm(AAssigmentStm node, Context question) throws AnalysisException {
        Value newValue = (Value)node.getExp().apply((IQuestionAnswer)this, (Object)question);
        Value currentValue = (Value)node.getTarget().apply((IQuestionAnswer)this, (Object)question);
        if (!(currentValue instanceof UpdatableValue)) {
            throw new InterpreterException("Cannot assign to a constant value. " + node);
        }
        try {
            UpdatableValue currentUpdatableValue = (UpdatableValue)currentValue;
            currentUpdatableValue.setValue(newValue.deref());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed at: " + node, e);
        }
        return new VoidValue();
    }

    public Value caseANotEqualBinaryExp(ANotEqualBinaryExp node, Context question) throws AnalysisException {
        BooleanValue equals = this.equals((Value)node.getLeft().apply((IQuestionAnswer)this, (Object)question), (Value)node.getRight().apply((IQuestionAnswer)this, (Object)question));
        return new BooleanValue(equals.getValue() == false);
    }

    public ArrayValue createArrayValue(List<PExp> sizes, PType type, Context question) throws AnalysisException {
        ArrayList<Value> arrayValues = new ArrayList<Value>();
        for (int i = 0; i < ((NumericValue)((Value)sizes.get(0).apply((IQuestionAnswer)this, (Object)question)).deref()).intValue(); ++i) {
            if (sizes.size() > 1) {
                List<PExp> nextSizes = sizes.subList(1, sizes.size());
                arrayValues.add(new UpdatableValue(this.createArrayValue(nextSizes, type, question)));
                continue;
            }
            if (type instanceof AFunctionType || type instanceof ARealNumericPrimitiveType) {
                arrayValues.add(new RealValue(0.0));
                continue;
            }
            if (type instanceof SNumericPrimitiveType) {
                arrayValues.add(new ByteValue(0));
                continue;
            }
            if (type instanceof ABooleanPrimitiveType) {
                arrayValues.add(new BooleanValue(false));
                continue;
            }
            if (type instanceof AStringPrimitiveType) {
                arrayValues.add(new StringValue(""));
                continue;
            }
            arrayValues.add(new NullValue());
        }
        return new ArrayValue(arrayValues);
    }

    public Value caseAVariableDeclaration(AVariableDeclaration node, Context question) throws AnalysisException {
        if (node.getExternal() != null && node.getExternal().booleanValue()) {
            return new VoidValue();
        }
        if (!node.getSize().isEmpty()) {
            ArrayValue arrayValue;
            if (node.getInitializer() != null) {
                arrayValue = (ArrayValue)node.getInitializer().apply((IQuestionAnswer)this, (Object)question);
            } else {
                if (node.getSize() == null || node.getSize().isEmpty()) {
                    throw new InterpreterException("Array size cannot be unspecified when no .conlizer is specified: " + node.getName());
                }
                arrayValue = this.createArrayValue(node.getSize(), node.getType(), question);
            }
            Class<? extends Value> targetValueType = typeValueMappings.get(node.getType().getClass());
            for (int i = 0; i < arrayValue.getValues().size(); ++i) {
                Value v = (Value)arrayValue.getValues().get(i);
                if (targetValueType == null || targetValueType.isAssignableFrom(v.getClass()) || !v.isNumeric()) continue;
                NumericValue upcasted = ((NumericValue)v).upCast(targetValueType);
                if (upcasted == null) {
                    throw new InterpreterException(String.format("Array initializer value at index %d '%s' could not be upcasted. In ", i, v.toString()) + "initializer is specified: " + node.getName());
                }
                arrayValue.getValues().set(i, upcasted);
            }
            question.put(node.getName(), (Value)new UpdatableValue(arrayValue));
        } else {
            Class<? extends Value> targetValueType;
            Value initialValue;
            Value value = initialValue = node.getInitializer() == null ? new UndefinedValue() : (Value)node.getInitializer().apply((IQuestionAnswer)this, (Object)question);
            if (initialValue.deref().isNumeric() && (targetValueType = typeValueMappings.get(node.getType().getClass())) != null) {
                NumericValue upcasted = ((NumericValue)initialValue.deref()).upCast(targetValueType);
                if (upcasted == null) {
                    throw new InterpreterException(String.format("Initializer value could not be upcasted. In ", initialValue.deref().toString()) + "initializer is specified: " + node.getName() + " in " + node);
                }
                initialValue = upcasted;
            }
            question.put(node.getName(), (Value)new UpdatableValue(initialValue));
        }
        return new VoidValue();
    }

    public Value caseAExpInitializer(AExpInitializer node, Context question) throws AnalysisException {
        return (Value)node.getExp().apply((IQuestionAnswer)this, (Object)question);
    }

    public Value caseAArrayInitializer(AArrayInitializer node, Context question) throws AnalysisException {
        ArrayValue array = new ArrayValue(this.evaluate(node.getExp(), question).stream().map(v -> v.deref()).collect(Collectors.toList()));
        return array;
    }

    public Value caseAFieldExp(AFieldExp node, Context question) throws AnalysisException {
        Value root = (Value)node.getRoot().apply((IQuestionAnswer)this, (Object)question);
        if (root instanceof ModuleValue) {
            ModuleContext moduleContext = new ModuleContext((ModuleValue)root, question);
            return moduleContext.lookup(node.getField());
        }
        throw new InterpreterException("Unhandled node: " + node);
    }

    public Value caseAExpressionStm(AExpressionStm node, Context question) throws AnalysisException {
        return (Value)node.getExp().apply((IQuestionAnswer)this, (Object)question);
    }

    public Value caseAIdentifierExp(AIdentifierExp node, Context question) {
        Value val = question.lookup(node.getName());
        if (val == null) {
            throw new InterpreterException("Variable undefined: '" + node.getName() + "':" + node.getName().getSymbol().getLine());
        }
        return val;
    }

    public Value caseAPlusBinaryExp(APlusBinaryExp node, Context question) throws AnalysisException {
        NumericValue left = (NumericValue)((Value)node.getLeft().apply((IQuestionAnswer)this, (Object)question)).deref();
        NumericValue right = (NumericValue)((Value)node.getRight().apply((IQuestionAnswer)this, (Object)question)).deref();
        if (!left.isNumericDecimal() && !right.isNumericDecimal()) {
            return new IntegerValue(left.intValue() + right.intValue());
        }
        return new RealValue(left.realValue() + right.realValue());
    }

    public Value caseAMinusBinaryExp(AMinusBinaryExp node, Context question) throws AnalysisException {
        NumericValue left = (NumericValue)((Value)node.getLeft().apply((IQuestionAnswer)this, (Object)question)).deref();
        NumericValue right = (NumericValue)((Value)node.getRight().apply((IQuestionAnswer)this, (Object)question)).deref();
        if (!left.isNumericDecimal() && !right.isNumericDecimal()) {
            return new IntegerValue(left.intValue() - right.intValue());
        }
        return new RealValue(left.realValue() - right.realValue());
    }

    public Value caseACallExp(ACallExp node, Context question) throws AnalysisException {
        Value function;
        Context callContext = question;
        if (node.getObject() != null) {
            Value v = ((Value)node.getObject().apply((IQuestionAnswer)this, (Object)question)).deref();
            if (v instanceof NullValue) {
                logger.error("The target object: \"" + node.getObject().toString() + "\" is null. Related call: \"" + node.toString() + "\"");
                throw new InterpreterException("Unhandled node: " + node);
            }
            ModuleValue objectModule = (ModuleValue)v;
            callContext = new ModuleContext(objectModule, question);
        }
        if ((function = callContext.lookup(node.getMethodName())) instanceof FunctionValue) {
            try {
                return ((FunctionValue)function).evaluate(this.evaluate(node.getArgs(), callContext));
            }
            catch (InterpreterTransitionException te) {
                throw te;
            }
            catch (Exception e) {
                throw new InterpreterException("Unable to evaluate node: " + node, e);
            }
        }
        throw new InterpreterException("Unhandled node: " + node);
    }

    public Value caseAWhileStm(AWhileStm node, Context question) throws AnalysisException {
        try {
            while (((BooleanValue)((Value)node.getTest().apply((IQuestionAnswer)this, (Object)question)).deref()).getValue().booleanValue()) {
                node.getBody().apply((IQuestionAnswer)this, (Object)question);
            }
        }
        catch (BreakException e) {
            logger.trace("Loop stopped:" + node);
        }
        return new VoidValue();
    }

    public Value caseATryStm(ATryStm node, Context question) throws AnalysisException {
        try {
            node.getBody().apply((IQuestionAnswer)this, (Object)question);
        }
        catch (ErrorException e) {
            logger.info("Error in simulation: " + e.getMessage());
            logger.info("Continuing with finally");
            node.getFinally().apply((IQuestionAnswer)this, (Object)question);
            throw e;
        }
        catch (StopException e) {
            logger.info("Stop in simulation: " + e.getMessage());
            logger.info("Continuing with finally");
        }
        node.getFinally().apply((IQuestionAnswer)this, (Object)question);
        return new VoidValue();
    }

    public Value caseAErrorStm(AErrorStm node, Context question) throws AnalysisException {
        String message = "";
        if (node.getExp() != null) {
            Value msg = ((Value)node.getExp().apply((IQuestionAnswer)this, (Object)question)).deref();
            message = msg instanceof StringValue ? ((StringValue)msg).getValue() : msg.toString();
        }
        throw new ErrorException(message);
    }

    public Value caseAIfStm(AIfStm node, Context question) throws AnalysisException {
        if (((BooleanValue)((Value)node.getTest().apply((IQuestionAnswer)this, (Object)question)).deref()).getValue().booleanValue()) {
            node.getThen().apply((IQuestionAnswer)this, (Object)question);
        } else if (node.getElse() != null) {
            node.getElse().apply((IQuestionAnswer)this, (Object)question);
        }
        return new VoidValue();
    }

    public Value caseALessBinaryExp(ALessBinaryExp node, Context question) throws AnalysisException {
        NumericValue left = (NumericValue)((Value)node.getLeft().apply((IQuestionAnswer)this, (Object)question)).deref();
        NumericValue right = (NumericValue)((Value)node.getRight().apply((IQuestionAnswer)this, (Object)question)).deref();
        return new BooleanValue(left.deref().compareTo(right.deref()) < 0);
    }

    public Value caseALessEqualBinaryExp(ALessEqualBinaryExp node, Context question) throws AnalysisException {
        NumericValue left = (NumericValue)((Value)node.getLeft().apply((IQuestionAnswer)this, (Object)question)).deref();
        NumericValue right = (NumericValue)((Value)node.getRight().apply((IQuestionAnswer)this, (Object)question)).deref();
        return new BooleanValue(left.deref().compareTo(right.deref()) <= 0);
    }

    public Value caseAGreaterBinaryExp(AGreaterBinaryExp node, Context question) throws AnalysisException {
        NumericValue left = (NumericValue)((Value)node.getLeft().apply((IQuestionAnswer)this, (Object)question)).deref();
        NumericValue right = (NumericValue)((Value)node.getRight().apply((IQuestionAnswer)this, (Object)question)).deref();
        return new BooleanValue(left.deref().compareTo(right.deref()) > 0);
    }

    public Value caseAEqualBinaryExp(AEqualBinaryExp node, Context question) throws AnalysisException {
        return this.equals((Value)node.getLeft().apply((IQuestionAnswer)this, (Object)question), (Value)node.getRight().apply((IQuestionAnswer)this, (Object)question));
    }

    private BooleanValue equals(Value lv, Value rv) throws AnalysisException {
        if ((lv = lv.deref()).equals(rv = rv.deref())) {
            return new BooleanValue(true);
        }
        if (lv instanceof NumericValue && rv instanceof NumericValue) {
            NumericValue left = (NumericValue)lv;
            NumericValue right = (NumericValue)rv;
            return new BooleanValue(left.deref().compareTo(right.deref()) == 0);
        }
        if (lv instanceof BooleanValue && rv instanceof BooleanValue) {
            BooleanValue left = (BooleanValue)lv;
            BooleanValue right = (BooleanValue)rv;
            return new BooleanValue(left.getValue().compareTo(right.getValue()) == 0);
        }
        if (lv instanceof NullValue && rv instanceof NullValue) {
            return new BooleanValue(true);
        }
        return new BooleanValue(false);
    }

    public Value caseAOrBinaryExp(AOrBinaryExp node, Context question) throws AnalysisException {
        return new BooleanValue(((BooleanValue)((Value)node.getLeft().apply((IQuestionAnswer)this, (Object)question)).deref()).getValue() != false || ((BooleanValue)((Value)node.getRight().apply((IQuestionAnswer)this, (Object)question)).deref()).getValue() != false);
    }

    public Value caseAParExp(AParExp node, Context question) throws AnalysisException {
        return (Value)node.getExp().apply((IQuestionAnswer)this, (Object)question);
    }

    public Value caseAAndBinaryExp(AAndBinaryExp node, Context question) throws AnalysisException {
        return new BooleanValue(((BooleanValue)((Value)node.getLeft().apply((IQuestionAnswer)this, (Object)question)).deref()).getValue() != false && ((BooleanValue)((Value)node.getRight().apply((IQuestionAnswer)this, (Object)question)).deref()).getValue() != false);
    }

    public Value caseAGreaterEqualBinaryExp(AGreaterEqualBinaryExp node, Context question) throws AnalysisException {
        NumericValue left = (NumericValue)((Value)node.getLeft().apply((IQuestionAnswer)this, (Object)question)).deref();
        NumericValue right = (NumericValue)((Value)node.getRight().apply((IQuestionAnswer)this, (Object)question)).deref();
        return new BooleanValue(left.deref().compareTo(right.deref()) >= 0);
    }

    public Value caseARealLiteralExp(ARealLiteralExp node, Context question) throws AnalysisException {
        return NumericValue.valueOf(node.getValue());
    }

    public Value caseAFloatLiteralExp(AFloatLiteralExp node, Context question) throws AnalysisException {
        return NumericValue.valueOf(node.getValue().floatValue());
    }

    public Value caseABoolLiteralExp(ABoolLiteralExp node, Context question) throws AnalysisException {
        return new BooleanValue(node.getValue());
    }

    public Value caseAStringLiteralExp(AStringLiteralExp node, Context question) throws AnalysisException {
        return new StringValue(node.getValue());
    }

    public Value caseAIntLiteralExp(AIntLiteralExp node, Context question) throws AnalysisException {
        return NumericValue.valueOf(node.getValue());
    }

    public Value caseAUIntLiteralExp(AUIntLiteralExp node, Context question) throws AnalysisException {
        return NumericValue.valueOf(node.getValue());
    }

    protected Value getInnerArrayValue(ArrayValue<Value> arrayValue, List<NumericValue> indices) {
        return indices.size() > 1 ? this.getInnerArrayValue((ArrayValue)arrayValue.getValues().get(indices.get(0).intValue()).deref(), indices.subList(1, indices.size())) : arrayValue.getValues().get(indices.get(0).intValue());
    }

    public Value caseAArrayIndexExp(AArrayIndexExp node, Context question) throws AnalysisException {
        Value value = ((Value)node.getArray().apply((IQuestionAnswer)this, (Object)question)).deref();
        if (value instanceof ArrayValue) {
            List<NumericValue> indices = this.evaluate(node.getIndices(), question).stream().map(Value::deref).map(NumericValue.class::cast).collect(Collectors.toList());
            return this.getInnerArrayValue((ArrayValue)value, indices);
        }
        throw new AnalysisException("No array or index for: " + node);
    }

    public Value caseANotUnaryExp(ANotUnaryExp node, Context question) throws AnalysisException {
        Value value = (Value)node.getExp().apply((IQuestionAnswer)this, (Object)question);
        if (!(value.deref() instanceof BooleanValue)) {
            throw new InterpreterException("Invalid type in not expression");
        }
        return new BooleanValue(((BooleanValue)value.deref()).getValue() == false);
    }

    public Value caseABreakStm(ABreakStm node, Context question) throws AnalysisException {
        throw new BreakException();
    }

    public Value caseANullExp(ANullExp node, Context question) throws AnalysisException {
        return new NullValue();
    }

    public Value caseAMultiplyBinaryExp(AMultiplyBinaryExp node, Context question) throws AnalysisException {
        NumericValue x = (NumericValue)((Value)node.getLeft().apply((IQuestionAnswer)this, (Object)question)).deref();
        NumericValue y = (NumericValue)((Value)node.getRight().apply((IQuestionAnswer)this, (Object)question)).deref();
        if (x instanceof RealValue || y instanceof RealValue) {
            return new RealValue(x.realValue() * y.realValue());
        }
        return new IntegerValue(x.intValue() * y.intValue());
    }

    public Value caseATransferStm(ATransferStm node, Context question) throws AnalysisException {
        ITransitionManager.ITTransitionInfo info;
        if (this.transitionManager != null && (info = this.transitionManager.getTransferInfo(node, question, node.getNames().stream().limit(1L).map(AStringLiteralExp::getValue).findFirst().orElse(null))) != null) {
            this.transitionManager.transfer(this, info);
            throw new StopException("Stopping previous simulation as a result of a model transfer: " + info.describe());
        }
        return new VoidValue();
    }

    public Value caseATransferAsStm(ATransferAsStm node, Context question) {
        return new VoidValue();
    }

    public Value createNewReturnValue(INode node, Context question) throws AnalysisException {
        logger.debug("Unhandled interpreter node: {}", (Object)node.getClass().getSimpleName());
        throw new InterpreterException("Unhandled node: " + node);
    }

    public Value caseARefExp(ARefExp node, Context question) throws AnalysisException {
        ByRefInterpreter byRefInterpreter = new ByRefInterpreter(this.loadFactory);
        return (Value)node.getExp().apply((IQuestionAnswer)byRefInterpreter, (Object)question);
    }

    public Value createNewReturnValue(Object node, Context question) throws AnalysisException {
        logger.debug("Unhandled interpreter object: {}", (Object)node.getClass().getSimpleName());
        throw new InterpreterException("Unhandled object: " + node);
    }

    public Value caseAMinusUnaryExp(AMinusUnaryExp node, Context question) throws AnalysisException {
        NumericValue exp = (NumericValue)((Value)node.getExp().apply((IQuestionAnswer)this, (Object)question)).deref();
        if (exp instanceof IntegerValue) {
            return new IntegerValue(exp.intValue() * -1);
        }
        return new RealValue(exp.realValue() * -1.0);
    }
}

