/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.interpreter.extensions;

import com.spencerwi.either.Either;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.stream.IntStream;
import org.intocps.maestro.interpreter.api.IValueLifecycleHandler;
import org.intocps.maestro.interpreter.extensions.BaseLifecycleHandler;
import org.intocps.maestro.interpreter.values.StringValue;
import org.intocps.maestro.interpreter.values.Value;

@IValueLifecycleHandler.ValueLifecycle(name="JavaClasspathLoader")
public class JavaClasspathLoaderLifecycleHandler
extends BaseLifecycleHandler {
    @Override
    public Either<Exception, Value> instantiate(List<Value> args) {
        if (args.isEmpty()) {
            return Either.left((Object)new Exception("Missing arguments for java classpath loader. Expecting: <fully qualified class name> <args>..."));
        }
        Value classNameArg = args.get(0).deref();
        if (classNameArg instanceof StringValue) {
            String qualifiedClassName = ((StringValue)classNameArg).getValue();
            try {
                Class<?> clz = Class.forName(qualifiedClassName);
                if (!Value.class.isAssignableFrom(clz)) {
                    return Either.left((Object)new Exception("Class not compatible with: " + Value.class.getName()));
                }
                int argCount = args.size() - 1;
                Class[] argTypes = (Class[])IntStream.range(0, argCount).mapToObj(i -> Value.class).toArray(Class[]::new);
                if (argTypes.length == 0) {
                    Constructor<?> ctor = clz.getDeclaredConstructor(new Class[0]);
                    return Either.right((Object)((Value)ctor.newInstance(new Object[0])));
                }
                Constructor<?> ctor = clz.getDeclaredConstructor(argTypes);
                return Either.right((Object)((Value)ctor.newInstance(args.stream().skip(1L).toArray(Value[]::new))));
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                return Either.left((Object)e);
            }
        }
        return Either.left((Object)new Exception("Missing name of the class to load"));
    }
}

