/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.interpreter.extensions.fmi3;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Vector;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.intocps.fmi.FmiInvalidNativeStateException;
import org.intocps.fmi.FmuInvocationException;
import org.intocps.fmi.jnifmuapi.fmi3.Fmi3Instance;
import org.intocps.fmi.jnifmuapi.fmi3.Fmi3State;
import org.intocps.fmi.jnifmuapi.fmi3.Fmi3Status;
import org.intocps.fmi.jnifmuapi.fmi3.Fmu3;
import org.intocps.fmi.jnifmuapi.fmi3.FmuResult;
import org.intocps.fmi.jnifmuapi.fmi3.IFmi3Fmu;
import org.intocps.fmi.jnifmuapi.fmi3.IFmi3Instance;
import org.intocps.fmi.jnifmuapi.fmi3.IIntermediateUpdateCallback;
import org.intocps.fmi.jnifmuapi.fmi3.ILogMessageCallback;
import org.intocps.maestro.ast.AFunctionDeclaration;
import org.intocps.maestro.ast.AModuleDeclaration;
import org.intocps.maestro.ast.node.AIntNumericPrimitiveType;
import org.intocps.maestro.ast.node.ANameType;
import org.intocps.maestro.ast.node.AReferenceType;
import org.intocps.maestro.ast.node.PType;
import org.intocps.maestro.interpreter.Fmi2Interpreter;
import org.intocps.maestro.interpreter.Interpreter;
import org.intocps.maestro.interpreter.InterpreterException;
import org.intocps.maestro.interpreter.extensions.fmi3.Fmi3InstanceArgMapping;
import org.intocps.maestro.interpreter.extensions.fmi3.Fmi3StateArgMapping;
import org.intocps.maestro.interpreter.extensions.fmi3.Fmi3StatusArgMapping;
import org.intocps.maestro.interpreter.extensions.fmi3.ResultProxyArgMapper;
import org.intocps.maestro.interpreter.external.ExternalReflectCallHelper;
import org.intocps.maestro.interpreter.external.IArgMapping;
import org.intocps.maestro.interpreter.external.TP;
import org.intocps.maestro.interpreter.values.BooleanValue;
import org.intocps.maestro.interpreter.values.ByteValue;
import org.intocps.maestro.interpreter.values.FunctionValue;
import org.intocps.maestro.interpreter.values.IntegerValue;
import org.intocps.maestro.interpreter.values.LongValue;
import org.intocps.maestro.interpreter.values.NullValue;
import org.intocps.maestro.interpreter.values.NumericValue;
import org.intocps.maestro.interpreter.values.RealValue;
import org.intocps.maestro.interpreter.values.UnsignedIntegerValue;
import org.intocps.maestro.interpreter.values.UpdatableValue;
import org.intocps.maestro.interpreter.values.Value;
import org.intocps.maestro.interpreter.values.VoidValue;
import org.intocps.maestro.interpreter.values.fmi.Fmu3InstanceValue;
import org.intocps.maestro.interpreter.values.fmi.Fmu3StateValue;
import org.intocps.maestro.interpreter.values.fmi.Fmu3Value;
import org.intocps.maestro.interpreter.values.utilities.ByteArrayArrayValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Fmi3Interpreter {
    static final ExternalReflectCallHelper.ArgMapping boolArrayOutArgMapper = new ExternalReflectCallHelper.ArgMapping(TP.Bool, 2, ExternalReflectCallHelper.ArgMapping.InOut.Output, null);
    static final ExternalReflectCallHelper.ArgMapping doubleArrayOutArgMapper = new ExternalReflectCallHelper.ArgMapping(TP.Real, 2, ExternalReflectCallHelper.ArgMapping.InOut.Output, null);
    static final ExternalReflectCallHelper.ArgMapping intInArgMapper = new ExternalReflectCallHelper.ArgMapping(TP.Int, 1, ExternalReflectCallHelper.ArgMapping.InOut.Input, null);
    static final ExternalReflectCallHelper.ArgMapping longInArgMapper = new ExternalReflectCallHelper.ArgMapping(TP.Long, 1, ExternalReflectCallHelper.ArgMapping.InOut.Input, null);
    static final ExternalReflectCallHelper.ArgMapping doubleInArgMapper = new ExternalReflectCallHelper.ArgMapping(TP.Real, 1, ExternalReflectCallHelper.ArgMapping.InOut.Input, null);
    static final ExternalReflectCallHelper.ArgMapping boolInArgMapper = new ExternalReflectCallHelper.ArgMapping(TP.Bool, 1, ExternalReflectCallHelper.ArgMapping.InOut.Input, null);
    static final ExternalReflectCallHelper.ArgMapping doubleArrayInArgMapper = new ExternalReflectCallHelper.ArgMapping(TP.Real, 2, ExternalReflectCallHelper.ArgMapping.InOut.Input, null);
    static final ExternalReflectCallHelper.ArgMapping boolArrayInArgMapper = new ExternalReflectCallHelper.ArgMapping(TP.Bool, 2, ExternalReflectCallHelper.ArgMapping.InOut.Input, null);
    static final ExternalReflectCallHelper.ArgMapping intArrayInArgMapper = new ExternalReflectCallHelper.ArgMapping(TP.Int, 2, ExternalReflectCallHelper.ArgMapping.InOut.Input, null);
    static final ExternalReflectCallHelper.ArgMapping longArrayInArgMapper = new ExternalReflectCallHelper.ArgMapping(TP.Long, 2, ExternalReflectCallHelper.ArgMapping.InOut.Input, null);
    static final ExternalReflectCallHelper.ArgMapping uintArrayOutArgMapper = new ExternalReflectCallHelper.ArgMapping(TP.Int, 2, ExternalReflectCallHelper.ArgMapping.InOut.Output, null);
    static final ExternalReflectCallHelper.ArgMapping longArrayOutArgMapper = new ExternalReflectCallHelper.ArgMapping(TP.Long, 2, ExternalReflectCallHelper.ArgMapping.InOut.Output, null);
    static final ExternalReflectCallHelper.ArgMapping intArrayOutArgMapper = new ExternalReflectCallHelper.ArgMapping(TP.Int, 2, ExternalReflectCallHelper.ArgMapping.InOut.Output, null);
    static final ExternalReflectCallHelper.ArgMapping boolOutArgMapper = new ExternalReflectCallHelper.ArgMapping(TP.Bool, 1, ExternalReflectCallHelper.ArgMapping.InOut.Output, null);
    static final ExternalReflectCallHelper.ArgMapping doubleOutArgMapper = new ExternalReflectCallHelper.ArgMapping(TP.Real, 1, ExternalReflectCallHelper.ArgMapping.InOut.Output, null);
    static final Logger logger = LoggerFactory.getLogger(Interpreter.class);
    private final File workingDirectory;
    private final Function<String, AModuleDeclaration> resolver;

    public Fmi3Interpreter(File workingDirectory, Function<String, AModuleDeclaration> resolver) {
        this.workingDirectory = workingDirectory;
        this.resolver = resolver;
    }

    public static Double getDouble(Value value) {
        if (value == null || value instanceof NullValue) {
            return null;
        }
        if ((value = value.deref()) == null || value instanceof NullValue) {
            return null;
        }
        if (value.isNumeric()) {
            return ((NumericValue)value).doubleValue();
        }
        throw new InterpreterException("Value is not double");
    }

    public static UpdatableValue getUpdatable(Value v) {
        if (!(v instanceof UpdatableValue)) {
            throw new InterpreterException("value not a reference value");
        }
        return (UpdatableValue)v;
    }

    public Map<String, Value> createFmuMembers(File workingDirectory, String guid, IFmi3Fmu fmu) {
        AModuleDeclaration fmi3Module = this.resolver.apply("FMI3");
        HashMap<String, Value> functions = new HashMap<String, Value>();
        functions.put("instantiateCoSimulation", new FunctionValue.ExternalFunctionValue(fargs -> {
            Fmi2Interpreter.checkArgLength(fargs, 6);
            String name = Fmi2Interpreter.getString((Value)fargs.get(0));
            boolean visible = Fmi2Interpreter.getBool((Value)fargs.get(1));
            boolean logginOn = Fmi2Interpreter.getBool((Value)fargs.get(2));
            boolean eventModeUsed = Fmi2Interpreter.getBool((Value)fargs.get(3));
            boolean earlyReturnAllowed = Fmi2Interpreter.getBool((Value)fargs.get(4));
            long[] requiredIntermediateVariables = Fmi2Interpreter.getArrayValue((Value)fargs.get(5), Optional.empty(), NumericValue.class).stream().mapToLong(NumericValue::longValue).toArray();
            try {
                long startInstantiateTime = System.nanoTime();
                logger.debug(String.format("Loading native FMU. GUID: %s, NAME: %s", guid, name));
                BufferedOutputStream fmuLogOutputStream = workingDirectory == null ? null : new BufferedOutputStream(new FileOutputStream(new File(workingDirectory, name + ".log")));
                String formatter = "{} {} {} {}";
                String pattern = "%d{ISO8601} %-5p - %m%n";
                PatternLayout layout = PatternLayout.newBuilder().withPattern(pattern).withCharset(StandardCharsets.UTF_8).build();
                ILogMessageCallback logCallback = (arg_0, arg_1, arg_2, arg_3) -> Fmi3Interpreter.lambda$createFmuMembers$0(fmuLogOutputStream, (Layout)layout, arg_0, arg_1, arg_2, arg_3);
                IIntermediateUpdateCallback intermediateUpdateCallback = (instanceEnvironment, intermediateUpdateTime, clocksTicked, intermediateVariableSetRequested, intermediateVariableGetAllowed, intermediateStepFinished, canReturnEarly) -> new IIntermediateUpdateCallback.IntermediateUpdateResponse(false, intermediateUpdateTime);
                IFmi3Instance instance = fmu.instantiateCoSimulation(name, guid, visible, logginOn, eventModeUsed, earlyReturnAllowed, requiredIntermediateVariables, logCallback, null);
                if (instance == null) {
                    logger.debug("Instance instantiate failed");
                    return new NullValue();
                }
                long stopInstantiateTime = System.nanoTime();
                System.out.println("Interpretation instantiate took: " + (stopInstantiateTime - startInstantiateTime));
                return Fmi3Interpreter.getFmuInstanceValue(fmuLogOutputStream, instance, name, this.resolver);
            }
            catch (IOException | NoSuchMethodException e) {
                e.printStackTrace();
                return null;
            }
        }));
        functions.put("freeInstance", new FunctionValue.ExternalFunctionValue(fargs -> {
            fargs = fargs.stream().map(Value::deref).collect(Collectors.toList());
            logger.debug("freeInstance");
            if (fargs.size() != 1) {
                throw new InterpreterException("Too few arguments");
            }
            if (!(fargs.get(0) instanceof Fmu3InstanceValue)) {
                throw new InterpreterException("Argument must be an external module reference");
            }
            Fmu3InstanceValue component = (Fmu3InstanceValue)fargs.get(0);
            try {
                OutputStream loggerOutputStream = component.getFmuLoggerOutputStream();
                if (loggerOutputStream != null) {
                    loggerOutputStream.close();
                }
                ((IFmi3Instance)component.getModule()).freeInstance();
            }
            catch (IOException | FmuInvocationException e) {
                e.printStackTrace();
            }
            return new VoidValue();
        }));
        functions.put("unload", new FunctionValue.ExternalFunctionValue(fargs -> {
            fargs = fargs.stream().map(Value::deref).collect(Collectors.toList());
            logger.debug("unload");
            if (fargs.size() != 0) {
                throw new InterpreterException("Too many arguments");
            }
            try {
                fmu.unLoad();
            }
            catch (FmuInvocationException e) {
                e.printStackTrace();
            }
            return new VoidValue();
        }));
        Fmi3Interpreter.checkRequiredFunctions(fmi3Module, functions);
        return functions;
    }

    static boolean checkRequiredFunctions(AModuleDeclaration module, Map<String, Value> functions) {
        Set expectedFunctions = module.getFunctions().stream().map(f -> f.getName().getText()).collect(Collectors.toSet());
        List missingFunctions = expectedFunctions.stream().filter(f -> !functions.containsKey(f)).collect(Collectors.toList());
        if (!missingFunctions.isEmpty()) {
            logger.warn("Runtime type '{}' does not match declaration. Missing: '{}'", (Object)module.getName().getText(), (Object)missingFunctions.stream().sorted().collect(Collectors.joining(",\n\t", "\n\t", "")));
            return false;
        }
        return true;
    }

    public static Function<ExternalReflectCallHelper.ArgMappingContext, IArgMapping> getFmi3InstanceCustomArgMapper() {
        Set statusRetuningFunctions = Arrays.stream(Fmi3Instance.class.getDeclaredMethods()).filter(m -> m.getReturnType().getSimpleName().equals("Fmi3Status")).map(Method::getName).collect(Collectors.toSet());
        Function<ExternalReflectCallHelper.ArgMappingContext, IArgMapping> costumeArgMapper = tCtxt -> {
            PType t = tCtxt.getArgType();
            boolean output = t instanceof AReferenceType;
            if (output) {
                t = ((AReferenceType)t).getType();
            }
            if (tCtxt.getArgType() instanceof AIntNumericPrimitiveType && tCtxt.getArgName() == null && statusRetuningFunctions.contains(tCtxt.getFunctionName())) {
                return new Fmi3StatusArgMapping();
            }
            if (t instanceof ANameType) {
                String typeName = ((ANameType)t).getName().getText();
                if (typeName.equals("FMI3Instance")) {
                    return new Fmi3InstanceArgMapping();
                }
                if (typeName.equals("FMU3State")) {
                    return new Fmi3StateArgMapping((ExternalReflectCallHelper.ArgMappingContext)tCtxt);
                }
            }
            return null;
        };
        return costumeArgMapper;
    }

    private static Value getFmuInstanceValue(BufferedOutputStream fmuLogOutputStream, IFmi3Instance instance, String name, Function<String, AModuleDeclaration> resolver) throws NoSuchMethodException {
        AModuleDeclaration module = resolver.apply("FMI3Instance");
        HashMap<String, Value> functions = new HashMap<String, Value>();
        Predicate<AFunctionDeclaration> functionFilter = fun -> !fun.getName().getText().equals("enterInitializationMode") && !fun.getName().getText().equals("setBinary");
        Set resultRetuningFunctions = Arrays.stream(Fmi3Instance.class.getDeclaredMethods()).filter(m -> m.getReturnType().getName().equals(FmuResult.class.getName())).map(Method::getName).collect(Collectors.toSet());
        Function<ExternalReflectCallHelper.ArgMappingContext, IArgMapping> costumeArgMapper = Fmi3Interpreter.getFmi3InstanceCustomArgMapper();
        Vector autobindWarnings = new Vector();
        for (AFunctionDeclaration function : module.getFunctions()) {
            if (functionFilter != null && !functionFilter.test(function)) continue;
            functions.computeIfAbsent(function.getName().getText(), key -> {
                try {
                    ExternalReflectCallHelper builder = new ExternalReflectCallHelper(function, instance, costumeArgMapper);
                    if (resultRetuningFunctions.contains(function.getName().getText())) {
                        return Fmi3Interpreter.handleResultReturns(builder).build();
                    }
                    return builder.build();
                }
                catch (NoSuchMethodException | RuntimeException e) {
                    autobindWarnings.add("Auto binding faild for: " + e.getMessage());
                    return null;
                }
            });
        }
        functions.put("enterInitializationMode", new FunctionValue.ExternalFunctionValue(fcargs -> {
            Fmi2Interpreter.checkArgLength(fcargs, 5);
            boolean toleranceDefined = Fmi2Interpreter.getBool((Value)fcargs.get(0));
            double tolerance = Fmi3Interpreter.getDouble((Value)fcargs.get(1));
            double startTime = Fmi3Interpreter.getDouble((Value)fcargs.get(2));
            boolean stopTimeDefined = Fmi2Interpreter.getBool((Value)fcargs.get(3));
            Double stopTime = Fmi3Interpreter.getDouble((Value)fcargs.get(4));
            try {
                Fmi3Status res = instance.enterInitializationMode(toleranceDefined ? Double.valueOf(tolerance) : null, startTime, stopTimeDefined ? stopTime : null);
                return new IntegerValue(res.value);
            }
            catch (FmuInvocationException e) {
                throw new InterpreterException(e);
            }
        }));
        functions.put("completedIntegratorStep", new FunctionValue.ExternalFunctionValue(fcargs -> {
            Fmi2Interpreter.checkArgLength(fcargs, 3);
            try {
                FmuResult res = instance.completedIntegratorStep(((Boolean)boolInArgMapper.map((Value)fcargs.get(0))).booleanValue());
                boolArrayOutArgMapper.mapOut((Value)fcargs.get(1), new boolean[]{((IFmi3Instance.CompletedIntegratorStepResponse)res.result).isEnterEventMode()});
                boolArrayOutArgMapper.mapOut((Value)fcargs.get(2), new boolean[]{((IFmi3Instance.CompletedIntegratorStepResponse)res.result).isTerminateSimulation()});
                return Fmi3StatusArgMapping.status2IntValue(res.status);
            }
            catch (FmuInvocationException e) {
                throw new InterpreterException(e);
            }
        }));
        functions.put("getAdjointDerivative", new FunctionValue.ExternalFunctionValue(fcargs -> {
            Fmi2Interpreter.checkArgLength(fcargs, 8);
            try {
                FmuResult res = instance.getGetAdjointDerivative((long[])longArrayInArgMapper.map((Value)fcargs.get(0)), (long[])longArrayInArgMapper.map((Value)fcargs.get(2)), (double[])doubleArrayInArgMapper.map((Value)fcargs.get(4)), ((Integer)intInArgMapper.map((Value)fcargs.get(5))).intValue());
                doubleArrayOutArgMapper.mapOut((Value)fcargs.get(6), res.result);
                return Fmi3StatusArgMapping.status2IntValue(res.status);
            }
            catch (FmuInvocationException e) {
                throw new InterpreterException(e);
            }
        }));
        functions.put("getOutputDerivatives", new FunctionValue.ExternalFunctionValue(fcargs -> {
            Fmi2Interpreter.checkArgLength(fcargs, 5);
            try {
                FmuResult res = instance.getOutputDerivatives((long[])longArrayInArgMapper.map((Value)fcargs.get(0)), (int[])intArrayInArgMapper.map((Value)fcargs.get(2)));
                doubleArrayOutArgMapper.mapOut((Value)fcargs.get(3), res.result);
                return Fmi3StatusArgMapping.status2IntValue(res.status);
            }
            catch (FmuInvocationException e) {
                throw new InterpreterException(e);
            }
        }));
        functions.put("getShiftDecimal", new FunctionValue.ExternalFunctionValue(fcargs -> {
            Fmi2Interpreter.checkArgLength(fcargs, 3);
            try {
                FmuResult res = instance.getShiftDecimal((long[])longArrayInArgMapper.map((Value)fcargs.get(0)));
                doubleArrayOutArgMapper.mapOut((Value)fcargs.get(2), res.result);
                return Fmi3StatusArgMapping.status2IntValue(res.status);
            }
            catch (FmuInvocationException e) {
                throw new InterpreterException(e);
            }
        }));
        functions.put("getShiftFraction", new FunctionValue.ExternalFunctionValue(fcargs -> {
            Fmi2Interpreter.checkArgLength(fcargs, 4);
            try {
                FmuResult res = instance.getShiftFraction((long[])longArrayInArgMapper.map((Value)fcargs.get(0)));
                uintArrayOutArgMapper.mapOut((Value)fcargs.get(2), ((IFmi3Instance.GetShiftFractionResponse)res.result).getShiftCounters());
                uintArrayOutArgMapper.mapOut((Value)fcargs.get(3), ((IFmi3Instance.GetShiftFractionResponse)res.result).getResolutions());
                return Fmi3StatusArgMapping.status2IntValue(res.status);
            }
            catch (FmuInvocationException e) {
                throw new InterpreterException(e);
            }
        }));
        functions.put("getVariableDependencies", new FunctionValue.ExternalFunctionValue(fcargs -> {
            Fmi2Interpreter.checkArgLength(fcargs, 6);
            try {
                FmuResult res = instance.getVariableDependencies(((Long)longInArgMapper.map((Value)fcargs.get(0))).longValue(), ((Long)intInArgMapper.map((Value)fcargs.get(5))).longValue());
                intArrayOutArgMapper.mapOut((Value)fcargs.get(1), ((IFmi3Instance.VariableDependency)res.result).getElementIndicesOfDependent());
                longArrayOutArgMapper.mapOut((Value)fcargs.get(2), ((IFmi3Instance.VariableDependency)res.result).getIndependents());
                longArrayOutArgMapper.mapOut((Value)fcargs.get(3), ((IFmi3Instance.VariableDependency)res.result).getElementIndicesOfIndependents());
                intArrayOutArgMapper.mapOut((Value)fcargs.get(4), ((IFmi3Instance.VariableDependency)res.result).getDependencyKinds());
                return Fmi3StatusArgMapping.status2IntValue(res.status);
            }
            catch (FmuInvocationException e) {
                throw new InterpreterException(e);
            }
        }));
        functions.put("setClock", new FunctionValue.ExternalFunctionValue(fcargs -> {
            Fmi2Interpreter.checkArgLength(fcargs, 3);
            try {
                Fmi3Status res = instance.setClock((long[])longArrayInArgMapper.map((Value)fcargs.get(0)), (boolean[])boolArrayInArgMapper.map((Value)fcargs.get(2)));
                return new IntegerValue(res.value);
            }
            catch (FmuInvocationException e) {
                throw new InterpreterException(e);
            }
        }));
        functions.put("setContinuousStates", new FunctionValue.ExternalFunctionValue(fcargs -> {
            Fmi2Interpreter.checkArgLength(fcargs, 2);
            try {
                Fmi3Status res = instance.setContinuousStates((double[])doubleArrayInArgMapper.map((Value)fcargs.get(0)));
                return new IntegerValue(res.value);
            }
            catch (FmuInvocationException e) {
                throw new InterpreterException(e);
            }
        }));
        functions.put("setIntervalDecimal", new FunctionValue.ExternalFunctionValue(fcargs -> {
            Fmi2Interpreter.checkArgLength(fcargs, 3);
            try {
                Fmi3Status res = instance.setIntervalDecimal((long[])longArrayInArgMapper.map((Value)fcargs.get(0)), (double[])doubleArrayInArgMapper.map((Value)fcargs.get(2)));
                return new IntegerValue(res.value);
            }
            catch (FmuInvocationException e) {
                throw new InterpreterException(e);
            }
        }));
        functions.put("setIntervalFraction", new FunctionValue.ExternalFunctionValue(fcargs -> {
            Fmi2Interpreter.checkArgLength(fcargs, 4);
            try {
                Fmi3Status res = instance.setIntervalFraction((long[])longArrayInArgMapper.map((Value)fcargs.get(0)), (long[])longArrayInArgMapper.map((Value)fcargs.get(2)), (long[])longArrayInArgMapper.map((Value)fcargs.get(3)));
                return new IntegerValue(res.value);
            }
            catch (FmuInvocationException e) {
                throw new InterpreterException(e);
            }
        }));
        functions.put("setShiftDecimal", new FunctionValue.ExternalFunctionValue(fcargs -> {
            Fmi2Interpreter.checkArgLength(fcargs, 3);
            Fmi3Status res = instance.setShiftDecimal((long[])longArrayInArgMapper.map((Value)fcargs.get(0)), (double[])doubleArrayInArgMapper.map((Value)fcargs.get(2)));
            return new IntegerValue(res.value);
        }));
        functions.put("setShiftFraction", new FunctionValue.ExternalFunctionValue(fcargs -> {
            Fmi2Interpreter.checkArgLength(fcargs, 4);
            Fmi3Status res = instance.setShiftFraction((long[])longArrayInArgMapper.map((Value)fcargs.get(0)), (long[])longArrayInArgMapper.map((Value)fcargs.get(2)), (long[])longArrayInArgMapper.map((Value)fcargs.get(3)));
            return new IntegerValue(res.value);
        }));
        functions.put("updateDiscreteStates", new FunctionValue.ExternalFunctionValue(fcargs -> {
            Fmi2Interpreter.checkArgLength(fcargs, 6);
            try {
                FmuResult res = instance.updateDiscreteStates();
                boolOutArgMapper.mapOut((Value)fcargs.get(0), ((IFmi3Instance.UpdateDiscreteStates)res.result).isDiscreteStatesNeedUpdate());
                boolOutArgMapper.mapOut((Value)fcargs.get(1), ((IFmi3Instance.UpdateDiscreteStates)res.result).isTerminateSimulation());
                boolOutArgMapper.mapOut((Value)fcargs.get(2), ((IFmi3Instance.UpdateDiscreteStates)res.result).isNominalsOfContinuousStatesChanged());
                boolOutArgMapper.mapOut((Value)fcargs.get(3), ((IFmi3Instance.UpdateDiscreteStates)res.result).isValuesOfContinuousStatesChanged());
                boolOutArgMapper.mapOut((Value)fcargs.get(4), ((IFmi3Instance.UpdateDiscreteStates)res.result).isNextEventTimeDefined());
                doubleOutArgMapper.mapOut((Value)fcargs.get(5), ((IFmi3Instance.UpdateDiscreteStates)res.result).getNextEventTime());
                return Fmi3StatusArgMapping.status2IntValue(res.status);
            }
            catch (FmuInvocationException e) {
                throw new InterpreterException(e);
            }
        }));
        functions.put("getClock", new FunctionValue.ExternalFunctionValue(fcargs -> {
            Fmi2Interpreter.checkArgLength(fcargs, 3);
            try {
                FmuResult res = instance.getClock((long[])longArrayInArgMapper.map((Value)fcargs.get(0)));
                boolArrayOutArgMapper.mapOut((Value)fcargs.get(2), res.result);
                return Fmi3StatusArgMapping.status2IntValue(res.status);
            }
            catch (FmuInvocationException e) {
                throw new InterpreterException(e);
            }
        }));
        functions.put("getContinuousStateDerivatives", new FunctionValue.ExternalFunctionValue(fcargs -> {
            Fmi2Interpreter.checkArgLength(fcargs, 2);
            try {
                FmuResult res = instance.getContinuousStateDerivatives(((Integer)intInArgMapper.map((Value)fcargs.get(1))).intValue());
                doubleArrayOutArgMapper.mapOut((Value)fcargs.get(0), res.result);
                return Fmi3StatusArgMapping.status2IntValue(res.status);
            }
            catch (FmuInvocationException e) {
                throw new InterpreterException(e);
            }
        }));
        functions.put("getContinuousStates", new FunctionValue.ExternalFunctionValue(fcargs -> {
            Fmi2Interpreter.checkArgLength(fcargs, 2);
            try {
                FmuResult res = instance.getGetContinuousStates(((Integer)intInArgMapper.map((Value)fcargs.get(1))).intValue());
                doubleArrayOutArgMapper.mapOut((Value)fcargs.get(0), res.result);
                return Fmi3StatusArgMapping.status2IntValue(res.status);
            }
            catch (FmuInvocationException e) {
                throw new InterpreterException(e);
            }
        }));
        functions.put("getDirectionalDerivative", new FunctionValue.ExternalFunctionValue(fcargs -> {
            Fmi2Interpreter.checkArgLength(fcargs, 8);
            try {
                FmuResult res = instance.getDirectionalDerivative((long[])longArrayInArgMapper.map((Value)fcargs.get(0)), (long[])longArrayInArgMapper.map((Value)fcargs.get(2)), (double[])doubleArrayInArgMapper.map((Value)fcargs.get(4)));
                doubleArrayOutArgMapper.mapOut((Value)fcargs.get(6), res.result);
                return Fmi3StatusArgMapping.status2IntValue(res.status);
            }
            catch (FmuInvocationException e) {
                throw new InterpreterException(e);
            }
        }));
        functions.put("getEventIndicators", new FunctionValue.ExternalFunctionValue(fcargs -> {
            Fmi2Interpreter.checkArgLength(fcargs, 2);
            try {
                FmuResult res = instance.getGetEventIndicators(((Integer)intInArgMapper.map((Value)fcargs.get(1))).intValue());
                doubleArrayOutArgMapper.mapOut((Value)fcargs.get(0), res.result);
                return Fmi3StatusArgMapping.status2IntValue(res.status);
            }
            catch (FmuInvocationException e) {
                throw new InterpreterException(e);
            }
        }));
        functions.put("getIntervalDecimal", new FunctionValue.ExternalFunctionValue(fcargs -> {
            Fmi2Interpreter.checkArgLength(fcargs, 4);
            try {
                FmuResult res = instance.getIntervalDecimal((long[])longArrayInArgMapper.map((Value)fcargs.get(0)));
                doubleArrayOutArgMapper.mapOut((Value)fcargs.get(2), ((IFmi3Instance.GetIntervalDecimalResponse)res.result).getIntervals());
                doubleArrayOutArgMapper.mapOut((Value)fcargs.get(3), ((IFmi3Instance.GetIntervalDecimalResponse)res.result).getQualifiers());
                return Fmi3StatusArgMapping.status2IntValue(res.status);
            }
            catch (FmuInvocationException e) {
                throw new InterpreterException(e);
            }
        }));
        functions.put("getIntervalFraction", new FunctionValue.ExternalFunctionValue(fcargs -> {
            Fmi2Interpreter.checkArgLength(fcargs, 5);
            try {
                FmuResult res = instance.getIntervalFraction((long[])longArrayInArgMapper.map((Value)fcargs.get(0)));
                uintArrayOutArgMapper.mapOut((Value)fcargs.get(2), ((IFmi3Instance.IntervalFractionResponse)res.result).getIntervalCounters());
                uintArrayOutArgMapper.mapOut((Value)fcargs.get(3), ((IFmi3Instance.IntervalFractionResponse)res.result).getResolutions());
                intInArgMapper.mapOut((Value)fcargs.get(3), Arrays.stream(((IFmi3Instance.IntervalFractionResponse)res.result).getQualifiers()).map(q -> q.getValue()).toArray());
                return Fmi3StatusArgMapping.status2IntValue(res.status);
            }
            catch (FmuInvocationException e) {
                throw new InterpreterException(e);
            }
        }));
        functions.put("getNominalsOfContinuousStates", new FunctionValue.ExternalFunctionValue(fcargs -> {
            Fmi2Interpreter.checkArgLength(fcargs, 2);
            try {
                FmuResult res = instance.getGetNominalsOfContinuousStates(((Integer)intInArgMapper.map((Value)fcargs.get(1))).intValue());
                doubleArrayOutArgMapper.mapOut((Value)fcargs.get(0), res.result);
                return Fmi3StatusArgMapping.status2IntValue(res.status);
            }
            catch (FmuInvocationException e) {
                throw new InterpreterException(e);
            }
        }));
        functions.put("getNumberOfContinuousStates", new FunctionValue.ExternalFunctionValue(fcargs -> {
            Fmi2Interpreter.checkArgLength(fcargs, 1);
            try {
                FmuResult res = instance.getNumberOfContinuousStates();
                longArrayOutArgMapper.mapOut((Value)fcargs.get(0), res.result);
                return Fmi3StatusArgMapping.status2IntValue(res.status);
            }
            catch (FmuInvocationException e) {
                throw new InterpreterException(e);
            }
        }));
        functions.put("getNumberOfEventIndicators", new FunctionValue.ExternalFunctionValue(fcargs -> {
            Fmi2Interpreter.checkArgLength(fcargs, 1);
            try {
                FmuResult res = instance.getNumberOfEventIndicators();
                ExternalReflectCallHelper.ArgMapping uintOutArgMapper = new ExternalReflectCallHelper.ArgMapping(TP.Long, 1, ExternalReflectCallHelper.ArgMapping.InOut.Output, null);
                uintOutArgMapper.mapOut((Value)fcargs.get(0), res.result);
                UpdatableValue v = (UpdatableValue)fcargs.get(0);
                v.setValue(new UnsignedIntegerValue(((LongValue)v.deref()).getValue()));
                return Fmi3StatusArgMapping.status2IntValue(res.status);
            }
            catch (FmuInvocationException e) {
                throw new InterpreterException(e);
            }
        }));
        functions.put("doStep", new FunctionValue.ExternalFunctionValue(fcargs -> {
            Fmi2Interpreter.checkArgLength(fcargs, 7);
            double currentCommunicationPoint = Fmi3Interpreter.getDouble((Value)fcargs.get(0));
            double communicationStepSize = Fmi3Interpreter.getDouble((Value)fcargs.get(1));
            boolean noSetFMUStatePriorToCurrentPoint = Fmi2Interpreter.getBool((Value)fcargs.get(2));
            UpdatableValue eventHandlingNeeded = Fmi3Interpreter.getUpdatable((Value)fcargs.get(3));
            UpdatableValue terminateSimulation = Fmi3Interpreter.getUpdatable((Value)fcargs.get(4));
            UpdatableValue earlyReturn = Fmi3Interpreter.getUpdatable((Value)fcargs.get(5));
            UpdatableValue lastSuccessfulTime = Fmi3Interpreter.getUpdatable((Value)fcargs.get(6));
            try {
                FmuResult res = instance.doStep(currentCommunicationPoint, communicationStepSize, noSetFMUStatePriorToCurrentPoint);
                if (res.status == Fmi3Status.OK) {
                    eventHandlingNeeded.setValue(new BooleanValue(((IFmi3Instance.DoStepResult)res.result).isEventHandlingNeeded()));
                    terminateSimulation.setValue(new BooleanValue(((IFmi3Instance.DoStepResult)res.result).isTerminateSimulation()));
                    earlyReturn.setValue(new BooleanValue(((IFmi3Instance.DoStepResult)res.result).isEarlyReturn()));
                    lastSuccessfulTime.setValue(new RealValue(((IFmi3Instance.DoStepResult)res.result).getLastSuccessfulTime()));
                }
                return new IntegerValue(res.status.value);
            }
            catch (FmuInvocationException e) {
                throw new InterpreterException(e);
            }
        }));
        functions.put("setFMUState", new FunctionValue.ExternalFunctionValue(fcargs -> {
            Fmi2Interpreter.checkArgLength(fcargs, 1);
            Value v = ((Value)fcargs.get(0)).deref();
            if (v instanceof Fmu3StateValue) {
                try {
                    Fmu3StateValue stateValue = (Fmu3StateValue)v;
                    Fmi3Status res = instance.setState((Fmi3State)stateValue.getModule());
                    return new IntegerValue(res.value);
                }
                catch (FmuInvocationException e) {
                    throw new InterpreterException(e);
                }
            }
            throw new InterpreterException("Invalid value");
        }));
        functions.put("getFMUState", new FunctionValue.ExternalFunctionValue(fcargs -> {
            Fmi2Interpreter.checkArgLength(fcargs, 1);
            if (!(fcargs.get(0) instanceof UpdatableValue)) {
                throw new InterpreterException("value not a reference value");
            }
            try {
                FmuResult res = instance.getState();
                if (res.status == Fmi3Status.OK) {
                    UpdatableValue ref = (UpdatableValue)fcargs.get(0);
                    ref.setValue(new Fmu3StateValue((Fmi3State)res.result));
                }
                return new IntegerValue(res.status.value);
            }
            catch (FmuInvocationException e) {
                throw new InterpreterException(e);
            }
        }));
        functions.put("freeFMUState", new FunctionValue.ExternalFunctionValue(fcargs -> {
            Fmi2Interpreter.checkArgLength(fcargs, 1);
            Value v = ((Value)fcargs.get(0)).deref();
            if (v instanceof Fmu3StateValue) {
                try {
                    Fmu3StateValue stateValue = (Fmu3StateValue)v;
                    Fmi3Status res = instance.freeState((Fmi3State)stateValue.getModule());
                    return new IntegerValue(res.value);
                }
                catch (FmuInvocationException e) {
                    throw new InterpreterException(e);
                }
            }
            throw new InterpreterException("Invalid value");
        }));
        functions.put("setBinary", new FunctionValue.ExternalFunctionValue(fcargs -> {
            Fmi2Interpreter.checkArgLength(fcargs, 3);
            long elementsToUse = Fmi2Interpreter.getUint((Value)fcargs.get(1));
            long[] scalarValueIndices = Fmi2Interpreter.getArrayValue((Value)fcargs.get(0), Optional.of(elementsToUse), NumericValue.class).stream().mapToLong(NumericValue::longValue).toArray();
            ByteArrayArrayValue buffer = (ByteArrayArrayValue)((Value)fcargs.get(2)).deref();
            List elements = ((List)buffer.getModule()).stream().map(a -> a.stream().mapToInt(ByteValue::intValue).toArray()).collect(Collectors.toList());
            byte[][] data = new byte[elements.size()][];
            for (int i = 0; i < data.length; ++i) {
                byte[] bytes = new byte[((int[])elements.get(i)).length];
                for (int j = 0; j < ((int[])elements.get(i)).length; ++j) {
                    bytes[j] = Integer.valueOf(((int[])elements.get(i))[j]).byteValue();
                }
                data[i] = bytes;
            }
            try {
                Fmi3Status res = instance.setBinary(scalarValueIndices, (byte[][])data);
                return new IntegerValue(res.value);
            }
            catch (FmiInvalidNativeStateException e) {
                throw new InterpreterException(e);
            }
        }));
        functions.put("getBinary", new FunctionValue.ExternalFunctionValue(fcargs -> {
            Fmi2Interpreter.checkArgLength(fcargs, 3);
            long elementsToUse = Fmi2Interpreter.getUint((Value)fcargs.get(1));
            long[] scalarValueIndices = Fmi2Interpreter.getArrayValue((Value)fcargs.get(0), Optional.of(elementsToUse), NumericValue.class).stream().mapToLong(NumericValue::longValue).toArray();
            ByteArrayArrayValue buffer = (ByteArrayArrayValue)((Value)fcargs.get(2)).deref();
            try {
                FmuResult res = instance.getBinary(scalarValueIndices, scalarValueIndices.length);
                ((List)buffer.getModule()).clear();
                for (int i = 0; i < ((byte[][])res.result).length; ++i) {
                    int[] values = new int[((byte[][])res.result)[i].length];
                    for (int j = 0; j < values.length; ++j) {
                        values[j] = ((byte[][])res.result)[i][j];
                    }
                    ((List)buffer.getModule()).add(Arrays.stream(values).mapToObj(ByteValue::new).collect(Collectors.toList()));
                }
                return new IntegerValue(res.status.value);
            }
            catch (FmiInvalidNativeStateException e) {
                throw new InterpreterException(e);
            }
        }));
        if (!Fmi3Interpreter.checkRequiredFunctions(module, functions)) {
            autobindWarnings.forEach(arg_0 -> ((Logger)logger).warn(arg_0));
        }
        return new Fmu3InstanceValue(functions, instance, name, fmuLogOutputStream);
    }

    private static ExternalReflectCallHelper handleResultReturns(ExternalReflectCallHelper builder) {
        builder.addReturn(new ResultProxyArgMapper(new Fmi3StatusArgMapping(), builder.stream().filter(arg -> arg.getDirection() == ExternalReflectCallHelper.ArgMapping.InOut.Output).collect(Collectors.toList())));
        builder.stream().filter(arg -> arg.getDirection() == ExternalReflectCallHelper.ArgMapping.InOut.Output).forEach(arg -> arg.setDirection(ExternalReflectCallHelper.ArgMapping.InOut.OutputThroughReturn));
        return builder;
    }

    public Value createFmiValue(String path, String guid) {
        try {
            long startExecTime = System.nanoTime();
            URI uri = URI.create(path);
            if (!uri.isAbsolute()) {
                uri = new File(".").toURI().resolve(uri);
            }
            File file = new File(uri);
            Fmu3 fmu = new Fmu3(file);
            fmu.load();
            Map<String, Value> functions = this.createFmuMembers(this.workingDirectory, guid, (IFmi3Fmu)fmu);
            long stopTime = System.nanoTime();
            System.out.println("Interpretation load took: " + (stopTime - startExecTime));
            return new Fmu3Value(functions, (IFmi3Fmu)fmu);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new NullValue();
        }
    }

    private static /* synthetic */ void lambda$createFmuMembers$0(BufferedOutputStream fmuLogOutputStream, Layout layout, String instanceName, Fmi3Status status, String category, String message) {
        logger.info("NATIVE: instance: '{}', status: '{}', category: '{}', message: {}", new Object[]{instanceName, status, category, message});
        if (fmuLogOutputStream == null) {
            return;
        }
        Log4jLogEvent.Builder builder = Log4jLogEvent.newBuilder().setMessage((Message)new ParameterizedMessage("{} {} {} {}", new Object[]{category, status, instanceName, message}));
        switch (status) {
            case OK: 
            case Discard: {
                builder.setLevel(Level.INFO);
                break;
            }
            case Error: 
            case Fatal: {
                builder.setLevel(Level.ERROR);
            }
            case Warning: {
                builder.setLevel(Level.WARN);
                break;
            }
            default: {
                builder.setLevel(Level.TRACE);
            }
        }
        try {
            Log4jLogEvent event = builder.build();
            fmuLogOutputStream.write(layout.toByteArray((LogEvent)event));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

