/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.interpreter.values;

import org.intocps.maestro.interpreter.values.ByteValue;
import org.intocps.maestro.interpreter.values.FloatValue;
import org.intocps.maestro.interpreter.values.IntegerValue;
import org.intocps.maestro.interpreter.values.LongValue;
import org.intocps.maestro.interpreter.values.RealValue;
import org.intocps.maestro.interpreter.values.ShortValue;
import org.intocps.maestro.interpreter.values.UnsignedIntegerValue;
import org.intocps.maestro.interpreter.values.Value;

public abstract class NumericValue
extends Value {
    public static NumericValue valueOf(byte value) {
        return new ByteValue(value);
    }

    public static NumericValue valueOf(short value) {
        if (value <= 255) {
            return NumericValue.valueOf(Integer.valueOf(value).byteValue());
        }
        return new ShortValue(Integer.valueOf(value).shortValue());
    }

    public static NumericValue valueOf(int value) {
        if (value <= 255) {
            return NumericValue.valueOf(Integer.valueOf(value).byteValue());
        }
        if (value <= Short.MAX_VALUE) {
            return new ShortValue(Integer.valueOf(value).shortValue());
        }
        return new IntegerValue(value);
    }

    public static NumericValue valueOf(long value) {
        if (value <= Integer.MAX_VALUE) {
            return NumericValue.valueOf((int)value);
        }
        return new LongValue(value);
    }

    public static NumericValue valueOf(float value) {
        if (value % 1.0f == 0.0f) {
            return NumericValue.valueOf((long)value);
        }
        return new FloatValue(Double.valueOf(value).floatValue());
    }

    public static NumericValue valueOf(double value) {
        if (value % 1.0 == 0.0) {
            return NumericValue.valueOf((long)value);
        }
        return new RealValue(value);
    }

    public <T extends Class<? extends NumericValue>> NumericValue upCast(T targetType) {
        if (targetType.isAssignableFrom(this.getClass())) {
            return this;
        }
        if (targetType == UnsignedIntegerValue.class) {
            return new UnsignedIntegerValue(this.longValue());
        }
        if (targetType == IntegerValue.class) {
            return new IntegerValue(this.intValue());
        }
        if (targetType == ShortValue.class) {
            return new ShortValue(Integer.valueOf(this.intValue()).shortValue());
        }
        if (targetType == LongValue.class) {
            return new LongValue(this.longValue());
        }
        if (targetType == FloatValue.class) {
            return new FloatValue(new Double(this.realValue()).floatValue());
        }
        if (targetType == RealValue.class) {
            return new RealValue(this.realValue());
        }
        return null;
    }

    public abstract long longValue();

    public abstract int intValue();

    public abstract double realValue();

    public abstract double doubleValue();

    public abstract float floatValue();

    @Override
    public boolean isNumeric() {
        return true;
    }
}

