/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.interpreter.values.utilities;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.intocps.maestro.interpreter.InterpreterException;
import org.intocps.maestro.interpreter.values.ArrayValue;
import org.intocps.maestro.interpreter.values.ExternalModuleValue;
import org.intocps.maestro.interpreter.values.FunctionValue;
import org.intocps.maestro.interpreter.values.NumericValue;
import org.intocps.maestro.interpreter.values.RealValue;
import org.intocps.maestro.interpreter.values.StringValue;
import org.intocps.maestro.interpreter.values.UpdatableValue;
import org.intocps.maestro.interpreter.values.Value;
import org.intocps.maestro.interpreter.values.VoidValue;
import org.intocps.maestro.interpreter.values.utilities.ByteArrayArrayValue;

public class ArrayUtilValue
extends ExternalModuleValue<Object> {
    public ArrayUtilValue() {
        super(ArrayUtilValue.createMembers(), null);
    }

    public static <T extends Value> List<T> getArrayValue(Value value, Class<T> clz) {
        if ((value = value.deref()) instanceof ArrayValue) {
            ArrayValue array = (ArrayValue)value;
            if (((ArrayValue)value).getValues().isEmpty()) {
                return Collections.emptyList();
            }
            if (!clz.isAssignableFrom(array.getValues().get(0).getClass())) {
                throw new InterpreterException("Array not containing the right type");
            }
            return array.getValues();
        }
        throw new InterpreterException("Value is not an array");
    }

    public static String getString(Value value) {
        if ((value = value.deref()) instanceof StringValue) {
            return ((StringValue)value).getValue();
        }
        throw new InterpreterException("Value is not string");
    }

    public static double getDouble(Value value) {
        if ((value = value.deref()) instanceof RealValue) {
            return ((RealValue)value).getValue();
        }
        throw new InterpreterException("Value is not double");
    }

    private static Map<String, Value> createMembers() {
        HashMap<String, Value> componentMembers = new HashMap<String, Value>();
        componentMembers.put("copyRealArray", new FunctionValue.ExternalFunctionValue(fcargs -> {
            int i;
            ArrayUtilValue.checkArgLength(fcargs, 5);
            List<RealValue> from = ArrayUtilValue.getArrayValue((Value)fcargs.get(0), RealValue.class);
            int fromIndex = ((NumericValue)((Value)fcargs.get(1)).deref()).intValue();
            int fromCount = ((NumericValue)((Value)fcargs.get(2)).deref()).intValue();
            UpdatableValue to = (UpdatableValue)fcargs.get(3);
            int toStartIndex = ((NumericValue)((Value)fcargs.get(4)).deref()).intValue();
            ArrayValue toSource = (ArrayValue)to.deref();
            NumericValue[] values = new NumericValue[toSource.getValues().size()];
            for (i = 0; i < fromCount; ++i) {
                values[toStartIndex + i] = from.get(i + fromIndex);
            }
            for (i = 0; i < toStartIndex; ++i) {
                values[i] = (NumericValue)toSource.getValues().get(i);
            }
            for (i = toStartIndex + fromCount; i < toSource.getValues().size(); ++i) {
                values[i] = (NumericValue)toSource.getValues().get(i);
            }
            ArrayValue<NumericValue> newValue = new ArrayValue<NumericValue>(Arrays.asList(values));
            to.setValue(newValue);
            return new VoidValue();
        }));
        componentMembers.put("createByteArrayArray", new FunctionValue.ExternalFunctionValue(fcargs -> {
            ArrayUtilValue.checkArgLength(fcargs, 1);
            int size = ((NumericValue)((Value)fcargs.get(0)).deref()).intValue();
            return new ByteArrayArrayValue(size);
        }));
        return componentMembers;
    }
}

