/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.interpreter.values.variablestep.constraint.boundeddifference.stepsize;

import java.util.Observable;
import java.util.Observer;
import org.intocps.maestro.interpreter.values.variablestep.CurrentSolutionPoint;
import org.intocps.maestro.interpreter.values.variablestep.InitializationMsgJson;
import org.intocps.maestro.interpreter.values.variablestep.StepsizeInterval;
import org.intocps.maestro.interpreter.values.variablestep.constraint.boundeddifference.BoundedDifferenceCalculator;
import org.intocps.maestro.interpreter.values.variablestep.constraint.boundeddifference.stepsize.BdStepsizeAdjustmentStrategy;

public class SimpleBdStepsizeAdjustmentStrategy
implements Observer,
BdStepsizeAdjustmentStrategy {
    private static final String HAS_SKIPPED_LOGTEXT = "choose the last stepsize that was limited by a continuous constraint and ";
    private static final Double STEPSIZE_TIGHTENING_FACTOR = 0.5;
    private static final Double STEPSIZE_STRONG_TIGHTENING_FACTOR = 0.01;
    private static final Double STEPSIZE_RELAXATION_FACTOR = 1.2;
    private static final Double TOLERANCE_RISKYBIN_FACTOR = 0.6;
    private static final Double TOLERANCE_TARGETBIN_FACTOR = 0.4;
    private static final Double TOLERANCE_SAFEBIN_FACTOR = 0.2;
    private final StepsizeInterval interval;
    private final BoundedDifferenceCalculator calculator;
    private final Double absTol;
    private final Double relTol;
    private final Double strongRelaxationFactor;
    private final Double safety;
    private final Boolean skipDiscrete;
    private SimpleBdStepsizeAdjustmentStrategy previousState = null;
    private Decision decision;
    private LimitingTolerance limitingTolerance;
    private Boolean hasSkippedDiscrete;
    private Boolean wasLastStepsizeLimitedByDiscreteConstraint;
    private Double lastStepsizeLimitedByContinuousConstraint;

    public SimpleBdStepsizeAdjustmentStrategy(SimpleBdStepsizeAdjustmentStrategy sas) {
        this.interval = sas.interval;
        this.calculator = sas.calculator;
        this.absTol = sas.absTol;
        this.relTol = sas.relTol;
        this.strongRelaxationFactor = sas.strongRelaxationFactor;
        this.decision = sas.decision;
        this.limitingTolerance = sas.limitingTolerance;
        this.safety = sas.safety;
        this.skipDiscrete = sas.skipDiscrete;
        this.hasSkippedDiscrete = sas.hasSkippedDiscrete;
        this.wasLastStepsizeLimitedByDiscreteConstraint = sas.wasLastStepsizeLimitedByDiscreteConstraint;
        this.lastStepsizeLimitedByContinuousConstraint = sas.lastStepsizeLimitedByContinuousConstraint;
    }

    public SimpleBdStepsizeAdjustmentStrategy(BoundedDifferenceCalculator calculator, InitializationMsgJson.Constraint jc, StepsizeInterval interval, Double strongRelaxationFactor, Observable observable) {
        this.calculator = calculator;
        this.absTol = jc.getAbsoluteTolerance();
        this.relTol = jc.getRelativeTolerance();
        this.safety = jc.getSafety();
        this.skipDiscrete = jc.getSkipDiscrete();
        this.interval = interval;
        this.strongRelaxationFactor = strongRelaxationFactor;
        if (this.skipDiscrete.booleanValue()) {
            observable.addObserver(this);
        }
    }

    @Override
    public void update(Observable obs, Object arg) {
        if (obs instanceof CurrentSolutionPoint) {
            CurrentSolutionPoint cs = (CurrentSolutionPoint)obs;
            CurrentSolutionPoint.Operation op = cs.getOperation();
            if (CurrentSolutionPoint.Operation.ADVANCE.equals((Object)op)) {
                this.previousState = new SimpleBdStepsizeAdjustmentStrategy(this);
                this.wasLastStepsizeLimitedByDiscreteConstraint = cs.wasLastStepsizeLimitedByDiscreteConstraint();
                this.lastStepsizeLimitedByContinuousConstraint = cs.getLastStepsizeLimitedByContinuousConstraint();
                this.hasSkippedDiscrete = false;
            }
            if (CurrentSolutionPoint.Operation.PEEK.equals((Object)op)) {
                // empty if block
            }
            if (CurrentSolutionPoint.Operation.ROLLBACK.equals((Object)op)) {
                this.wasLastStepsizeLimitedByDiscreteConstraint = this.previousState.wasLastStepsizeLimitedByDiscreteConstraint;
                this.lastStepsizeLimitedByContinuousConstraint = this.previousState.lastStepsizeLimitedByContinuousConstraint;
                this.hasSkippedDiscrete = this.previousState.hasSkippedDiscrete;
                this.decision = this.previousState.decision;
                this.limitingTolerance = this.previousState.limitingTolerance;
                this.previousState = null;
            }
        }
    }

    @Override
    public Double getStepsize(Double prevStepsize) {
        if (this.skipDiscrete.booleanValue() && this.wasLastStepsizeLimitedByDiscreteConstraint.booleanValue()) {
            return this.getStepsizeAfterDiscreteEvent(prevStepsize);
        }
        this.decision = this.getDecisionBasedOnCurrentValues(this.calcDistanceBin());
        return this.mapDecisionOnStepsize(this.decision, prevStepsize);
    }

    @Override
    public String getDecision() {
        String logIntro = this.hasSkippedDiscrete != false ? HAS_SKIPPED_LOGTEXT : "";
        return logIntro + this.decision.getLogTextBeginning() + this.limitingTolerance.getLogText() + this.decision.getLogTextEnding();
    }

    @Override
    public Boolean isRelaxingStrongly() {
        return Decision.RELAX_STRONGLY.equals((Object)this.decision);
    }

    private Double getStepsizeAfterDiscreteEvent(Double prevStepsize) {
        Decision repeatedDecision = this.removeRelaxations(this.decision);
        this.decision = this.getDecisionBasedOnCurrentValues(this.calcDistanceBin());
        Double dtFromCurrentValues = this.mapDecisionOnStepsize(this.decision, prevStepsize);
        Double dtFromRepeatedDecision = this.mapDecisionOnStepsize(repeatedDecision, this.lastStepsizeLimitedByContinuousConstraint);
        if (dtFromRepeatedDecision > dtFromCurrentValues) {
            this.decision = repeatedDecision;
            this.hasSkippedDiscrete = true;
            return dtFromRepeatedDecision;
        }
        return dtFromCurrentValues;
    }

    private Decision removeRelaxations(Decision aDecision) {
        if (Decision.RELAX_STRONGLY.equals((Object)aDecision) || Decision.RELAX.equals((Object)aDecision)) {
            return Decision.CONSTANT;
        }
        return aDecision;
    }

    private Double mapDecisionOnStepsize(Decision queryDecision, Double prevStepsize) {
        if (Decision.TIGHTEN_STRONGLY.equals((Object)queryDecision)) {
            return this.getStronglyTightenedStepsize(prevStepsize);
        }
        if (Decision.TIGHTEN.equals((Object)queryDecision)) {
            return this.getTightenedStepsize(prevStepsize);
        }
        if (Decision.CONSTANT.equals((Object)queryDecision)) {
            return prevStepsize;
        }
        if (Decision.RELAX.equals((Object)queryDecision)) {
            return this.getRelaxedStepsize(prevStepsize);
        }
        if (Decision.RELAX_STRONGLY.equals((Object)queryDecision)) {
            return this.getStronglyRelaxedStepsize(prevStepsize);
        }
        throw new IllegalStateException("Unreachable code");
    }

    private Decision getDecisionBasedOnCurrentValues(DistanceBin bin) {
        if (DistanceBin.VIOLATION.equals((Object)bin)) {
            return Decision.TIGHTEN_STRONGLY;
        }
        if (DistanceBin.RISKY.equals((Object)bin)) {
            return Decision.TIGHTEN;
        }
        if (DistanceBin.TARGET.equals((Object)bin)) {
            return Decision.CONSTANT;
        }
        if (DistanceBin.SAFE.equals((Object)bin)) {
            return Decision.RELAX;
        }
        if (DistanceBin.SAFEST.equals((Object)bin)) {
            return Decision.RELAX_STRONGLY;
        }
        throw new IllegalStateException("Unreachable code");
    }

    private DistanceBin calcDistanceBin() {
        DistanceBin absBin = this.getBinByDistanceAndTolerance(this.calculator.getAbsoluteDifference(), this.absTol);
        DistanceBin relBin = this.getBinByDistanceAndTolerance(this.calculator.getRelativeDifference(), this.relTol);
        if (absBin.ordinal() < relBin.ordinal()) {
            this.limitingTolerance = LimitingTolerance.ABSOLUTE;
            return absBin;
        }
        if (relBin.ordinal() < absBin.ordinal()) {
            this.limitingTolerance = LimitingTolerance.RELATIVE;
            return relBin;
        }
        this.limitingTolerance = LimitingTolerance.BOTH;
        return absBin;
    }

    private DistanceBin getBinByDistanceAndTolerance(Double dist, Double tol) {
        Double safetyFactor = 1.0 / (1.0 + this.safety);
        if (Math.abs(dist) <= tol * TOLERANCE_SAFEBIN_FACTOR * safetyFactor) {
            return DistanceBin.SAFEST;
        }
        if (Math.abs(dist) <= tol * TOLERANCE_TARGETBIN_FACTOR * safetyFactor) {
            return DistanceBin.SAFE;
        }
        if (Math.abs(dist) <= tol * TOLERANCE_RISKYBIN_FACTOR * safetyFactor) {
            return DistanceBin.TARGET;
        }
        if (Math.abs(dist) <= tol) {
            return DistanceBin.RISKY;
        }
        return DistanceBin.VIOLATION;
    }

    private Double getTightenedStepsize(Double prevStepsize) {
        return this.interval.saturateStepsize(prevStepsize * STEPSIZE_TIGHTENING_FACTOR);
    }

    private Double getStronglyTightenedStepsize(Double prevStepsize) {
        return this.interval.saturateStepsize(prevStepsize * STEPSIZE_STRONG_TIGHTENING_FACTOR);
    }

    private Double getRelaxedStepsize(Double prevStepsize) {
        return this.interval.saturateStepsize(prevStepsize * STEPSIZE_RELAXATION_FACTOR);
    }

    private Double getStronglyRelaxedStepsize(Double prevStepsize) {
        return this.interval.saturateStepsize(prevStepsize * this.strongRelaxationFactor);
    }

    private static enum Decision {
        RELAX_STRONGLY,
        RELAX,
        CONSTANT,
        TIGHTEN,
        TIGHTEN_STRONGLY;


        private String getLogTextBeginning() {
            switch (this) {
                case RELAX_STRONGLY: {
                    return "strongly relax the stepsize (very safe ";
                }
                case RELAX: {
                    return "relax the stepsize (safe ";
                }
                case CONSTANT: {
                    return "hold the stepsize constant (";
                }
                case TIGHTEN: {
                    return "tighten the stepsize (";
                }
                case TIGHTEN_STRONGLY: {
                    return "strongly tighten the stepsize (tolerance violation of ";
                }
            }
            return "";
        }

        private String getLogTextEnding() {
            switch (this) {
                case RELAX_STRONGLY: {
                    return ")";
                }
                case RELAX: {
                    return ")";
                }
                case CONSTANT: {
                    return " within target range)";
                }
                case TIGHTEN: {
                    return " close to tolerance violation)";
                }
                case TIGHTEN_STRONGLY: {
                    return ")";
                }
            }
            return "";
        }
    }

    private static enum DistanceBin {
        VIOLATION,
        RISKY,
        TARGET,
        SAFE,
        SAFEST;

    }

    private static enum LimitingTolerance {
        ABSOLUTE,
        RELATIVE,
        BOTH;


        private String getLogText() {
            switch (this) {
                case ABSOLUTE: {
                    return "absolute difference";
                }
                case RELATIVE: {
                    return "relative difference";
                }
                case BOTH: {
                    return "absolute and relative differences";
                }
            }
            return "";
        }
    }
}

