/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.interpreter.extensions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.spencerwi.either.Either;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.intocps.maestro.interpreter.api.IValueLifecycleHandler;
import org.intocps.maestro.interpreter.extensions.BaseLifecycleHandler;
import org.intocps.maestro.interpreter.values.Value;
import org.intocps.maestro.interpreter.values.csv.CsvDataWriter;
import org.intocps.maestro.interpreter.values.datawriter.DataWriterValue;

@IValueLifecycleHandler.ValueLifecycle(name="DataWriter")
public class DataWriterLifecycleHandler
extends BaseLifecycleHandler {
    static final String DEFAULT_CSV_FILENAME = "outputs.csv";
    final String DATA_WRITER_TYPE_NAME;
    final String dataWriterFileNameFinal;
    final List<String> dataWriterFilterFinal;
    private final File workingDirectory;

    public DataWriterLifecycleHandler(File workingDirectory, InputStream config) throws IOException {
        JsonNode configTree;
        this.workingDirectory = workingDirectory;
        this.DATA_WRITER_TYPE_NAME = this.getClass().getAnnotation(IValueLifecycleHandler.ValueLifecycle.class).name();
        String dataWriterFileName = DEFAULT_CSV_FILENAME;
        List dataWriterFilter = null;
        if (config != null && (configTree = new ObjectMapper().readTree(config)).has(this.DATA_WRITER_TYPE_NAME)) {
            JsonNode dwConfig = configTree.get(this.DATA_WRITER_TYPE_NAME);
            for (JsonNode val : dwConfig) {
                if (!val.has("type") || !val.get("type").isTextual() || !val.get("type").asText().equals("CSV")) continue;
                if (val.has("filename") && val.get("filename").isTextual()) {
                    dataWriterFileName = val.get("filename").asText();
                }
                if (!val.has("filter")) continue;
                dataWriterFilter = StreamSupport.stream(Spliterators.spliteratorUnknownSize(val.get("filter").iterator(), 16), false).map(v -> v.asText()).collect(Collectors.toList());
            }
        }
        this.dataWriterFileNameFinal = dataWriterFileName;
        this.dataWriterFilterFinal = dataWriterFilter;
    }

    @Override
    public Either<Exception, Value> instantiate(List<Value> args) {
        return Either.right((Object)new DataWriterValue(Collections.singletonList(new CsvDataWriter(this.workingDirectory == null ? new File(this.dataWriterFileNameFinal) : new File(this.workingDirectory, this.dataWriterFileNameFinal), this.dataWriterFilterFinal))));
    }
}

