/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.interpreter.extensions;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.spencerwi.either.Either;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.intocps.maestro.interpreter.InterpreterException;
import org.intocps.maestro.interpreter.api.IValueLifecycleHandler;
import org.intocps.maestro.interpreter.extensions.BaseLifecycleHandler;
import org.intocps.maestro.interpreter.values.BooleanValue;
import org.intocps.maestro.interpreter.values.ExternalModuleValue;
import org.intocps.maestro.interpreter.values.FunctionValue;
import org.intocps.maestro.interpreter.values.IntegerValue;
import org.intocps.maestro.interpreter.values.RealValue;
import org.intocps.maestro.interpreter.values.StringValue;
import org.intocps.maestro.interpreter.values.Value;

@IValueLifecycleHandler.ValueLifecycle(name="MEnv")
public class MEnvLifecycleHandler
extends BaseLifecycleHandler {
    public static final String ENVIRONMENT_VARIABLES = "environment_variables";
    private final Map<String, Object> rawData;

    public MEnvLifecycleHandler(InputStream config) throws IOException {
        Map map;
        this.rawData = config != null && config.available() > 0 ? (map = (Map)new ObjectMapper().readValue(config, (TypeReference)new TypeReference<Map<String, Object>>(){})) : null;
    }

    @Override
    public Either<Exception, Value> instantiate(List<Value> args) {
        if (this.rawData == null || !this.rawData.containsKey(ENVIRONMENT_VARIABLES)) {
            return Either.left((Object)new Exception("Missing required runtime key: environment_variables"));
        }
        Map data = (Map)this.rawData.get(ENVIRONMENT_VARIABLES);
        HashMap<String, FunctionValue.ExternalFunctionValue> members = new HashMap<String, FunctionValue.ExternalFunctionValue>();
        members.put("getBool", new FunctionValue.ExternalFunctionValue(a -> {
            Value.checkArgLength(a, 1);
            String key = this.getEnvName((List<Value>)a);
            Object val = data.get(key);
            if (val instanceof Integer) {
                return new BooleanValue((Integer)val > 1);
            }
            if (val instanceof Boolean) {
                return new BooleanValue((Boolean)val);
            }
            throw new InterpreterException("Env key not found with the right type. Key '" + key + "' value '" + val + "'");
        }));
        members.put("getInt", new FunctionValue.ExternalFunctionValue(a -> {
            Value.checkArgLength(a, 1);
            String key = this.getEnvName((List<Value>)a);
            Object val = data.get(key);
            if (val instanceof Integer) {
                return new IntegerValue((Integer)val);
            }
            throw new InterpreterException("Env key not found with the right type. Key '" + key + "' value '" + val + "'");
        }));
        members.put("getReal", new FunctionValue.ExternalFunctionValue(a -> {
            Value.checkArgLength(a, 1);
            String key = this.getEnvName((List<Value>)a);
            Object val = data.get(key);
            if (val instanceof Integer) {
                return new RealValue(((Integer)val).doubleValue());
            }
            if (val instanceof Double) {
                return new RealValue((Double)val);
            }
            throw new InterpreterException("Env key not found with the right type. Key '" + key + "' value '" + val + "'");
        }));
        members.put("getString", new FunctionValue.ExternalFunctionValue(a -> {
            Value.checkArgLength(a, 1);
            String key = this.getEnvName((List<Value>)a);
            Object val = data.get(key);
            if (val instanceof String) {
                return new StringValue((String)val);
            }
            throw new InterpreterException("Env key not found with the right type. Key '" + key + "' value '" + val + "'");
        }));
        ExternalModuleValue<Map<String, Object>> val = new ExternalModuleValue<Map<String, Object>>(members, data){};
        return Either.right((Object)val);
    }

    private String getEnvName(List<Value> a) {
        return ((StringValue)a.get(0).deref()).getValue();
    }
}

