/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.interpreter.values.variablestep;

public class StepsizeInterval {
    private static final Double DEFAULT_MIN_STEPSIZE = 1.0E-6;
    private static final Double DEFAULT_MAX_STEPSIZE = 1.0;
    private Double minimalStepsize;
    private Double maximalStepsize;

    public StepsizeInterval(Double min, Double max) {
        this.minimalStepsize = Math.min(min, max);
        this.maximalStepsize = Math.max(min, max);
    }

    public StepsizeInterval() {
        this(DEFAULT_MIN_STEPSIZE, DEFAULT_MAX_STEPSIZE);
    }

    public Double saturateStepsize(Double stepsize) {
        Double stepsizeClippedAtMin = Math.max(this.minimalStepsize, stepsize);
        return Math.min(this.maximalStepsize, stepsizeClippedAtMin);
    }

    public Double getMinimalStepsize() {
        return this.minimalStepsize;
    }

    public Double getMaximalStepsize() {
        return this.maximalStepsize;
    }
}

