/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.interpreter.values.variablestep.constraint.boundeddifference;

import java.util.Collections;
import java.util.List;
import java.util.Observable;
import java.util.Vector;
import org.intocps.maestro.framework.fmi2.ModelConnection;
import org.intocps.maestro.interpreter.values.variablestep.valuetracker.DoubleValueTracker;

public class BoundedDifferenceCalculator {
    private List<DoubleValueTracker> tracker = new Vector<DoubleValueTracker>();
    private Boolean isDefinedBySinglePort;

    public BoundedDifferenceCalculator(Observable observable, List<ModelConnection.Variable> variables) {
        this.isDefinedBySinglePort = variables.size() == 1;
        for (ModelConnection.Variable variable : variables) {
            this.tracker.add(new DoubleValueTracker(observable, variable, 1));
        }
    }

    public Double getAbsoluteDifference() {
        if (this.isDefinedBySinglePort.booleanValue()) {
            Double currentValue = this.tracker.get(0).getCurrentValue();
            Double previousValue = this.tracker.get(0).getPreviousValue();
            if (!currentValue.isNaN() && previousValue == null) {
                previousValue = currentValue;
            }
            return currentValue - previousValue;
        }
        List<Double> currentValues = this.getCurrentPortValues();
        return Collections.max(currentValues) - Collections.min(currentValues);
    }

    public Double getNextAbsoluteDifference() {
        if (this.isDefinedBySinglePort.booleanValue()) {
            Double currentValue = this.tracker.get(0).getCurrentValue();
            Double nextValue = this.tracker.get(0).getNextValue();
            return nextValue - currentValue;
        }
        List<Double> nextValues = this.getNextPortValues();
        return Collections.max(nextValues) - Collections.min(nextValues);
    }

    public Double getRelativeDifference() {
        if (this.isDefinedBySinglePort.booleanValue()) {
            Double currentValue = this.tracker.get(0).getCurrentValue();
            Double previousValue = this.tracker.get(0).getPreviousValue();
            if (!currentValue.isNaN() && previousValue == null) {
                previousValue = currentValue;
            }
            return this.getAbsoluteDifference() / Math.max(Math.max(Math.abs(currentValue), Math.abs(previousValue)), Double.MIN_VALUE);
        }
        List<Double> currentValues = this.getCurrentPortValues();
        return this.getAbsoluteDifference() / Math.max(Math.max(Collections.max(currentValues), Math.abs(Collections.min(currentValues))), Double.MIN_VALUE);
    }

    public Double getNextRelativeDifference() {
        if (this.isDefinedBySinglePort.booleanValue()) {
            Double currentValue = this.tracker.get(0).getCurrentValue();
            Double nextValue = this.tracker.get(0).getNextValue();
            return this.getNextAbsoluteDifference() / Math.max(Math.max(Math.abs(currentValue), Math.abs(nextValue)), Double.MIN_VALUE);
        }
        List<Double> nextValues = this.getNextPortValues();
        return this.getNextAbsoluteDifference() / Math.max(Math.max(Collections.max(nextValues), Math.abs(Collections.min(nextValues))), Double.MIN_VALUE);
    }

    private List<Double> getCurrentPortValues() {
        Vector<Double> currentValues = new Vector<Double>();
        for (DoubleValueTracker t : this.tracker) {
            currentValues.add(t.getCurrentValue());
        }
        return currentValues;
    }

    private List<Double> getNextPortValues() {
        Vector<Double> nextValues = new Vector<Double>();
        for (DoubleValueTracker t : this.tracker) {
            nextValues.add(t.getNextValue());
        }
        return nextValues;
    }
}

