/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.interpreter.values.variablestep.constraint.zerocrossing.detection;

import org.intocps.maestro.interpreter.values.variablestep.constraint.zerocrossing.detection.ZerocrossingConstraintState;
import org.intocps.maestro.interpreter.values.variablestep.valuetracker.OptionalDifferenceTracker;

public class ZerocrossingDetector {
    private OptionalDifferenceTracker tracker;
    private ZerocrossingConstraintState state;

    public ZerocrossingDetector(OptionalDifferenceTracker tracker) {
        this.tracker = tracker;
    }

    public Double getResolvedDistanceToZerocrossing() {
        if (!this.hasZerocrossingOccurred().booleanValue()) {
            return null;
        }
        Double currentDistance = Math.abs(this.tracker.getCurrentValue());
        Double nextDistance = Math.abs(this.tracker.getNextValue());
        return Math.min(currentDistance, nextDistance);
    }

    public Boolean hasZerocrossingViolatedTolerance(Double tolerance) {
        Double resolvedDistance = this.getResolvedDistanceToZerocrossing();
        return resolvedDistance > tolerance;
    }

    public void updateZeroCrossingState() {
        if (this.hasZerocrossingOccurred().booleanValue()) {
            this.state = ZerocrossingConstraintState.CROSSED;
            return;
        }
        if (this.isApproachingZerocrossing().booleanValue()) {
            this.state = ZerocrossingConstraintState.APPROACHING;
            return;
        }
        this.state = ZerocrossingConstraintState.DISTANCING;
    }

    public ZerocrossingConstraintState getZerocrossingState() {
        return this.state;
    }

    public Boolean isApproachingZerocrossing() {
        Double currentDistance = this.tracker.getCurrentValue();
        Double nextDistance = this.tracker.getNextValue();
        return Math.abs(nextDistance) - Math.abs(currentDistance) < 0.0;
    }

    public Boolean hasZerocrossingOccurred() {
        Double currentDistance = this.tracker.getCurrentValue();
        Double nextDistance = this.tracker.getNextValue();
        if (currentDistance == Double.MAX_VALUE || nextDistance == Double.MAX_VALUE) {
            return false;
        }
        return currentDistance * nextDistance <= 0.0;
    }
}

