/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.interpreter.external;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import org.intocps.maestro.ast.AFunctionDeclaration;
import org.intocps.maestro.ast.AModuleDeclaration;
import org.intocps.maestro.ast.node.ANameType;
import org.intocps.maestro.ast.node.PType;
import org.intocps.maestro.interpreter.external.ExternalReflectCallHelper;
import org.intocps.maestro.interpreter.external.IArgMapping;
import org.intocps.maestro.interpreter.values.ExternalModuleValue;
import org.intocps.maestro.interpreter.values.Value;

public class ExternalReflectModuleHelper {
    public static Map<String, Value> createMembers(AModuleDeclaration module, Object target, Predicate<AFunctionDeclaration> functionFilter) throws NoSuchMethodException {
        if (target == null) {
            throw new IllegalArgumentException("Target must not be null");
        }
        Function<ExternalReflectCallHelper.ArgMappingContext, IArgMapping> costumeArgMapper = tctxt -> {
            PType t = tctxt.getArgType();
            if (t instanceof ANameType && ((ANameType)t).getName().getText().equals("FMI3Instance")) {
                return new IArgMapping(){

                    @Override
                    public int getDimension() {
                        return 1;
                    }

                    @Override
                    public long[] getLimits() {
                        return null;
                    }

                    @Override
                    public ExternalReflectCallHelper.ArgMapping.InOut getDirection() {
                        return ExternalReflectCallHelper.ArgMapping.InOut.Input;
                    }

                    @Override
                    public void setDirection(ExternalReflectCallHelper.ArgMapping.InOut direction) {
                    }

                    @Override
                    public Object map(Value v) {
                        if (v instanceof ExternalModuleValue) {
                            return ((ExternalModuleValue)v).getModule();
                        }
                        return null;
                    }

                    @Override
                    public void mapOut(Value original, Object value) {
                        throw new RuntimeException("This is only for input so should not be called");
                    }

                    @Override
                    public Value mapOut(Object value, Map<IArgMapping, Value> outputArgs) {
                        return new ExternalModuleValue<Object>(this, null, value){};
                    }

                    @Override
                    public Class getType() {
                        return Object.class;
                    }

                    @Override
                    public String getDescriptiveName() {
                        return "FMI3Instance";
                    }

                    @Override
                    public String getDefaultTestValue() {
                        return "null";
                    }
                };
            }
            return null;
        };
        HashMap<String, Value> members = new HashMap<String, Value>();
        for (AFunctionDeclaration function : module.getFunctions()) {
            if (functionFilter != null && !functionFilter.test(function)) continue;
            members.put(function.getName().getText(), new ExternalReflectCallHelper(function, target, costumeArgMapper).build());
        }
        return members;
    }

    public static ExternalModuleValue createExternalModule(AModuleDeclaration module, final Object target, Predicate<AFunctionDeclaration> functionFilter) throws NoSuchMethodException {
        return new ExternalModuleValue(ExternalReflectModuleHelper.createMembers(module, target, functionFilter), target){

            public Object getModule() {
                return target;
            }
        };
    }
}

