/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.interpreter.values.modeltransition;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.Map;
import org.intocps.maestro.interpreter.values.Value;

class ModelTransitionStore {
    private static ModelTransitionStore instance = null;
    private Map<String, Value> values = new HashMap<String, Value>();
    private String transitionPath;
    private Path transitionFile;
    private Path transitionLog;
    private int transitionCount = 1;

    private ModelTransitionStore(String transitionPath) {
        this.transitionPath = transitionPath;
        this.transitionFile = Paths.get(transitionPath + "/" + transitionPath + "_" + this.transitionCount + ".mabl", new String[0]);
        this.transitionLog = Paths.get(transitionPath + "/log.txt", new String[0]);
        try {
            if (Files.exists(this.transitionLog, new LinkOption[0])) {
                Files.delete(this.transitionLog);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static ModelTransitionStore getInstance(String transitionPath) {
        if (instance == null) {
            instance = new ModelTransitionStore(transitionPath);
        }
        return instance;
    }

    public void put(String id, Value val) {
        this.values.put(id, val);
    }

    public Value get(String id) {
        return this.values.get(id);
    }

    public void writeTransitionLog() {
        try {
            Files.write(ModelTransitionStore.instance.transitionLog, (Integer.toString(this.transitionCount) + System.lineSeparator()).getBytes(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setNextTransitionFile() {
        ++this.transitionCount;
        this.transitionFile = Paths.get(this.transitionPath + "/" + this.transitionPath + "_" + this.transitionCount + ".mabl", new String[0]);
    }

    public Path getNextTransitionFile() {
        return this.transitionFile;
    }
}

