/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.interpreter.values.datawriter;

import java.util.List;
import java.util.UUID;
import org.intocps.maestro.interpreter.values.Value;
import org.intocps.maestro.interpreter.values.datawriter.IDataListener;

public class IntervalDataWriter
implements IDataListener {
    final double interval;
    double nextUpdateTime = 0.0;
    final IDataListener listener;

    public IntervalDataWriter(double interval, IDataListener listener) {
        this.interval = interval;
        this.listener = listener;
    }

    @Override
    public void writeHeader(UUID uuid, List<String> headers) {
        this.listener.writeHeader(uuid, headers);
    }

    @Override
    public void writeDataPoint(UUID uuid, double time, List<Value> dataPoint) {
        if (time >= this.nextUpdateTime) {
            this.nextUpdateTime += this.interval;
            this.listener.writeDataPoint(uuid, time, dataPoint);
        }
    }

    @Override
    public void close() {
        this.listener.close();
    }
}

