/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.interpreter.values.utilities;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.intocps.maestro.interpreter.InterpreterException;
import org.intocps.maestro.interpreter.values.ArrayValue;
import org.intocps.maestro.interpreter.values.ByteValue;
import org.intocps.maestro.interpreter.values.ExternalModuleValue;
import org.intocps.maestro.interpreter.values.FunctionValue;
import org.intocps.maestro.interpreter.values.IntegerValue;
import org.intocps.maestro.interpreter.values.NumericValue;
import org.intocps.maestro.interpreter.values.RealValue;
import org.intocps.maestro.interpreter.values.StringValue;
import org.intocps.maestro.interpreter.values.Value;
import org.intocps.maestro.interpreter.values.VoidValue;

public class ByteArrayArrayValue
extends ExternalModuleValue<List<List<ByteValue>>> {
    public ByteArrayArrayValue(int size) {
        this(ByteArrayArrayValue.create(size));
    }

    ByteArrayArrayValue(Map.Entry<Map<String, Value>, List<List<ByteValue>>> d) {
        super(d.getKey(), d.getValue());
    }

    public static Map.Entry<Map<String, Value>, List<List<ByteValue>>> create(int size) {
        ArrayList<List<ByteValue>> list = new ArrayList<List<ByteValue>>(size);
        return Map.entry(ByteArrayArrayValue.createMembers(list), list);
    }

    public static <T extends Value> List<T> getArrayValue(Value value, Class<T> clz) {
        if ((value = value.deref()) instanceof ArrayValue) {
            ArrayValue array = (ArrayValue)value;
            if (((ArrayValue)value).getValues().isEmpty()) {
                return Collections.emptyList();
            }
            if (!clz.isAssignableFrom(array.getValues().get(0).getClass())) {
                throw new InterpreterException("Array not containing the right type");
            }
            return array.getValues();
        }
        throw new InterpreterException("Value is not an array");
    }

    public static String getString(Value value) {
        if ((value = value.deref()) instanceof StringValue) {
            return ((StringValue)value).getValue();
        }
        throw new InterpreterException("Value is not string");
    }

    public static double getDouble(Value value) {
        if ((value = value.deref()) instanceof RealValue) {
            return ((RealValue)value).getValue();
        }
        throw new InterpreterException("Value is not double");
    }

    private static Map<String, Value> createMembers(List<List<ByteValue>> list) {
        HashMap<String, Value> componentMembers = new HashMap<String, Value>();
        componentMembers.put("set", new FunctionValue.ExternalFunctionValue(fcargs -> {
            ByteArrayArrayValue.checkArgLength(fcargs, 2);
            List<ByteValue> from = ByteArrayArrayValue.getArrayValue((Value)fcargs.get(1), ByteValue.class);
            int index = ((NumericValue)((Value)fcargs.get(0)).deref()).intValue();
            list.add(index, from);
            return new VoidValue();
        }));
        componentMembers.put("get", new FunctionValue.ExternalFunctionValue(fcargs -> {
            ByteArrayArrayValue.checkArgLength(fcargs, 1);
            int index = ((NumericValue)((Value)fcargs.get(0)).deref()).intValue();
            return new ArrayValue((List)list.get(index));
        }));
        componentMembers.put("getArraySizes", new FunctionValue.ExternalFunctionValue(fcargs -> {
            ByteArrayArrayValue.checkArgLength(fcargs, 0);
            return new ArrayValue(list.stream().map(List::size).map(IntegerValue::new).collect(Collectors.toList()));
        }));
        return componentMembers;
    }
}

