/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.interpreter.values.variablestep;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.intocps.maestro.framework.fmi2.ModelConnection;
import org.intocps.maestro.interpreter.values.variablestep.constraint.ConstraintType;
import org.intocps.maestro.interpreter.values.variablestep.constraint.samplingrate.Sampling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class InitializationMsgJson {
    public Map<String, String> fmus;
    public Map<String, List<String>> connections;
    public Map<String, Object> parameters;
    public Map<String, Object> algorithm;
    public Map<String, List<String>> livestream;
    public Map<String, List<String>> logVariables;
    public boolean visible;
    public boolean loggingOn;
    public String overrideLogLevel = null;
    public boolean parallelSimulation = false;
    public boolean stabalizationEnabled = false;
    public double global_absolute_tolerance = 0.0;
    public double global_relative_tolerance = 0.01;
    public boolean simulationProgramDelay = false;
    public boolean hasExternalSignals = false;

    @JsonIgnore
    public Map<String, URI> getFmuFiles() throws Exception {
        HashMap<String, URI> files = new HashMap<String, URI>();
        if (this.fmus != null) {
            for (Map.Entry<String, String> entry : this.fmus.entrySet()) {
                try {
                    files.put(entry.getKey(), new URI(entry.getValue()));
                }
                catch (Exception e) {
                    throw new Exception(entry.getKey() + "-" + entry.getValue() + ": " + e.getMessage(), e);
                }
            }
        }
        return files;
    }

    public static class Constraint {
        static final Logger logger = LoggerFactory.getLogger(Constraint.class);
        private static final Double DEFAULT_ABSOLUTE_TOLERANCE = 0.001;
        private static final Double DEFAULT_RELATIVE_TOLERANCE = 0.01;
        private static final Double DEFAULT_SAFETY = 0.0;
        private static final Integer DEFAULT_ORDER = 2;
        private static final Boolean DEFAULT_SKIPDISCRETE = true;
        public String type;
        public Integer order;
        public List<String> ports;
        public Double abstol;
        public Double reltol;
        public Double safety;
        public Integer base;
        public Integer rate;
        public Integer startTime;
        public Boolean skipDiscrete;
        private String id;

        public Double getAbsoluteTolerance() {
            return this.abstol == null ? DEFAULT_ABSOLUTE_TOLERANCE : this.abstol;
        }

        public Double getRelativeTolerance() {
            return this.reltol == null ? DEFAULT_RELATIVE_TOLERANCE : this.reltol;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getId() {
            if (this.id == null) {
                throw new IllegalStateException("Each constraint must have an id");
            }
            return this.id;
        }

        public Boolean getSkipDiscrete() {
            return this.skipDiscrete == null ? DEFAULT_SKIPDISCRETE : this.skipDiscrete;
        }

        public Double getSafety() {
            return this.safety == null ? DEFAULT_SAFETY : this.safety;
        }

        public ConstraintType getType() {
            return ConstraintType.lookup(this.type);
        }

        public Integer getOrder() {
            return this.order == null ? DEFAULT_ORDER : this.order;
        }

        public List<ModelConnection.Variable> getPorts() {
            Vector<ModelConnection.Variable> v = new Vector<ModelConnection.Variable>();
            if (this.ports == null || this.ports.isEmpty()) {
                return v;
            }
            for (String vs : this.ports) {
                try {
                    v.add(ModelConnection.Variable.parse((String)vs));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return v;
        }

        public Sampling getSampling() {
            return new Sampling(this.base, this.rate, this.startTime);
        }

        public static Constraint parse(Map<String, Object> value) {
            Constraint constraint = new Constraint();
            constraint.type = value.get("type").toString();
            for (Field f : constraint.getClass().getFields()) {
                if (!value.containsKey(f.getName())) continue;
                Object val = value.get(f.getName());
                if (f.getType() == Double.class && val.getClass() == Integer.class) {
                    val = (double)((Integer)val).intValue();
                }
                if (f.getType().isAssignableFrom(val.getClass())) {
                    try {
                        f.set(constraint, val);
                    }
                    catch (Exception e) {
                        logger.error("Failed parsing constraint", (Throwable)e);
                    }
                    continue;
                }
                logger.error("Constraint field type mismatch unable to set. Expected {}, Actual {}", f.getType(), val.getClass());
            }
            return constraint;
        }
    }
}

